/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.User;
import com.jfoenix.controls.JFXButton;
import controllers.AddBankController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class BanksController
implements Initializable {
    private User user;
    public static Stage addBankStage = new Stage();
    @FXML
    private JFXButton addBank;
    @FXML
    private JFXButton deleteBank;
    @FXML
    private JFXButton bankStatement;
    @FXML
    private JFXButton refresh;
    @FXML
    private JFXButton blockBank;
    @FXML
    private JFXButton unblockBank;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private TableView<Bank> allBanks;
    @FXML
    private TableColumn bankName;
    @FXML
    private TableColumn bankBranch;
    @FXML
    private TableColumn accountNumber;
    @FXML
    private TableColumn balance;
    @FXML
    private TableColumn lastTransactionDate;
    @FXML
    private TableColumn enabled;
    @FXML
    MaskerPane masker;
    @FXML
    private TableColumn lastReconciliation;
    @FXML
    private StackPane stackpane;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.bankName.setCellValueFactory((Callback)new PropertyValueFactory("bankName"));
        this.bankBranch.setCellValueFactory((Callback)new PropertyValueFactory("bankBranch"));
        this.accountNumber.setCellValueFactory((Callback)new PropertyValueFactory("bankAccount"));
        this.balance.setCellValueFactory((Callback)new PropertyValueFactory("balanceString"));
        this.lastTransactionDate.setCellValueFactory((Callback)new PropertyValueFactory("lastTransactionDate"));
        this.enabled.setCellValueFactory((Callback)new PropertyValueFactory("enabled"));
        this.refresh.setOnAction(e -> this.getData());
        this.notificationPane.setContent((Node)this.stackpane);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.getData();
        this.addBank.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/addBank.fxml").openStream());
                AddBankController controller = (AddBankController)loader.getController();
                controller.setUser(this.getUser());
                Scene scene = new Scene((Parent)itemPane);
                scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            addBankStage.close();
                        }
                    }
                });
                addBankStage.setScene(scene);
                addBankStage.setResizable(false);
                try {
                    addBankStage.initModality(Modality.APPLICATION_MODAL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    addBankStage.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                addBankStage.setTitle("Add Bank");
                addBankStage.show();
                addBankStage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                BanksController.this.getData();
                            }
                        });
                    }
                });
            }
            catch (Exception j) {
                j.printStackTrace();
            }
        });
        this.bankStatement.setOnAction(e -> {
            Bank myBank = (Bank)this.allBanks.getSelectionModel().getSelectedItem();
            myBank.generateStatement(this.getUser());
        });
    }

    public void getData() {
        Platform.runLater(() -> {
            this.masker.setVisible(true);
            this.allBanks.setItems(Bank.getAllBanks(this.getUser()));
            this.masker.setVisible(false);
        });
    }
}

