/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.User;
import filterscontrollers.BSFilter;
import filterscontrollers.GLAccountFilter;
import filterscontrollers.PNLFilter;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Hyperlink;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class BoardReportsController
implements Initializable {
    private User user;
    @FXML
    private Hyperlink trialBalance;
    @FXML
    private Hyperlink profitAndLossStatementGlobal;
    @FXML
    private Hyperlink balanceSheetMinimized;
    @FXML
    private Hyperlink balanceSheetDetailed;
    @FXML
    private Hyperlink bankDiscrepancy;
    @FXML
    private Hyperlink stockDiscrepancy;
    @FXML
    private Hyperlink vSMSalesPerProduct;
    @FXML
    private Hyperlink routeProfitability;
    @FXML
    private Hyperlink regionProfitability;
    @FXML
    private Hyperlink salesPerPostingGroup;
    @FXML
    private Hyperlink fuelConsumption;
    @FXML
    private Hyperlink completeEmptyMovement;
    @FXML
    private Hyperlink regionSales;
    @FXML
    private Hyperlink regionSalesPerProduct;
    @FXML
    private Hyperlink customerProfitability;
    @FXML
    private Hyperlink allCustomersProfitability;
    @FXML
    private Hyperlink allCustomers;
    @FXML
    private Hyperlink salesRep;
    @FXML
    private Hyperlink allSuppliers;
    @FXML
    private Hyperlink allAssets;
    @FXML
    private Hyperlink allWarehouses;
    @FXML
    private Hyperlink productMargins;
    @FXML
    private Hyperlink stockAnalysis;
    @FXML
    private Hyperlink purchaseSummary;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        if (!Config.showVSMReports) {
            this.salesRep.setVisible(false);
            this.vSMSalesPerProduct.setVisible(false);
            this.routeProfitability.setVisible(false);
            this.fuelConsumption.setVisible(false);
            this.completeEmptyMovement.setVisible(false);
        }
        if (!Config.showRegionReports) {
            this.regionSales.setVisible(false);
            this.regionSalesPerProduct.setVisible(false);
            this.regionProfitability.setVisible(false);
        }
        this.allCustomers.managedProperty().bind((ObservableValue)this.allCustomers.visibleProperty());
        this.salesRep.managedProperty().bind((ObservableValue)this.salesRep.visibleProperty());
        this.vSMSalesPerProduct.managedProperty().bind((ObservableValue)this.vSMSalesPerProduct.visibleProperty());
        this.routeProfitability.managedProperty().bind((ObservableValue)this.routeProfitability.visibleProperty());
        this.fuelConsumption.managedProperty().bind((ObservableValue)this.fuelConsumption.visibleProperty());
        this.completeEmptyMovement.managedProperty().bind((ObservableValue)this.completeEmptyMovement.visibleProperty());
        this.regionSales.managedProperty().bind((ObservableValue)this.regionSales.visibleProperty());
        this.regionSalesPerProduct.managedProperty().bind((ObservableValue)this.regionSalesPerProduct.visibleProperty());
        this.regionProfitability.managedProperty().bind((ObservableValue)this.regionProfitability.visibleProperty());
        this.bankDiscrepancy.setOnAction(e -> new Config().showDatesFilter(this.user, "bank_discrepancy", "Bank Discrepancy"));
        this.stockDiscrepancy.setOnAction(e -> new Config().loadItemsFilter("stock_discrepancy", "Stock Discrepancy", this.user));
        this.customerProfitability.setOnAction(e -> new Config().generateReport("customer_statement_products", "", this.user));
        this.allCustomersProfitability.setOnAction(e -> new Config().generateReport("all_customers_profitability", this.user));
        this.allCustomers.setOnAction(e -> new Config().generateReport("allcustomers", this.user));
        this.salesRep.setOnAction(e -> new Config().generateReport("sales_person_report", this.user));
        this.regionSales.setOnAction(e -> new Config().generateReport("region_sales_report", this.user));
        this.regionSalesPerProduct.setOnAction(e -> new Config().generateReport("region_sales_per_product", this.user));
        this.allSuppliers.setOnAction(e -> new Config().generateReport("allvendors", this.user));
        this.allAssets.setOnAction(e -> new Config().generateReport("allassets", this.user));
        this.allWarehouses.setOnAction(e -> new Config().generateReport("stockperlocation", this.user));
        this.productMargins.setOnAction(e -> new Config().generateReport("product_margins", this.user));
        this.stockAnalysis.setOnAction(e -> new Config().generateReport("stockanalysis", this.user));
        this.purchaseSummary.setOnAction(e -> new Config().generateReport("purchase_summary", this.user));
        this.vSMSalesPerProduct.setOnAction(e -> new Config().generateReport("sales_per_sales_rep", this.user));
        this.routeProfitability.setOnAction(e -> new Config().generateReport("route_profitability", this.user));
        this.regionProfitability.setOnAction(e -> new Config().generateReport("region_profitability", this.user));
        this.salesPerPostingGroup.setOnAction(e -> new Config().generateReport("sales_per_posting_group", this.user));
        this.fuelConsumption.setOnAction(e -> new Config().generateReport("fuel_consumption", this.user));
        this.completeEmptyMovement.setOnAction(e -> new Config().generateReport("complete_empty_movement", this.user));
        this.profitAndLossStatementGlobal.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/filtersfxml/pnlfilter.fxml").openStream());
                Scene editMember = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                PNLFilter controller = (PNLFilter)loader.getController();
                controller.setUser(this.getUser());
                stage.setTitle("Profit And Loss Filter");
                stage.setResizable(false);
                stage.show();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.balanceSheetMinimized.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/filtersfxml/bsfilter.fxml").openStream());
                Scene editMember = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                BSFilter controller = (BSFilter)loader.getController();
                controller.setReportName("balance_sheet_minimized");
                controller.setUser(this.getUser());
                stage.setTitle("Balance Sheet Filter");
                stage.setResizable(false);
                stage.show();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.balanceSheetDetailed.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/filtersfxml/bsfilter.fxml").openStream());
                Scene editMember = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                BSFilter controller = (BSFilter)loader.getController();
                controller.setReportName("balance_sheet_detailed");
                controller.setUser(this.getUser());
                stage.setTitle("Balance Sheet Filter");
                stage.setResizable(false);
                stage.show();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.trialBalance.setOnAction(e -> {
            try {
                Stage stage = new Stage();
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/filtersfxml/glaccountfilter.fxml").openStream());
                Scene scene = new Scene((Parent)itemPane);
                scene.setOnKeyPressed(t -> {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                });
                stage.setScene(scene);
                GLAccountFilter controller = (GLAccountFilter)loader.getController();
                controller.setReportName("trialbalance");
                controller.setUser(this.getUser());
                stage.setTitle("Trial Balance");
                stage.setResizable(false);
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.showAndWait();
            }
            catch (NullPointerException stage) {
            }
            catch (Exception i) {
                i.printStackTrace();
            }
        });
    }
}

