/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Account;
import classes.ChargeItem;
import classes.Config;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class ChargeItemController
implements Initializable {
    private User user;
    ChargeItem chargeItem;
    private int category;
    @FXML
    private VBox holder;
    @FXML
    private TextField description;
    @FXML
    private ComboBox<Account> account;
    @FXML
    private CheckBox taxable;
    @FXML
    private TextField taxrate;
    @FXML
    private TextField amount;
    @FXML
    private JFXButton addChargeItem;
    @FXML
    private JFXButton reset;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private HBox postToHBox;
    @FXML
    private ComboBox<String> postTo;
    @FXML
    private HBox depositHBox;
    @FXML
    private CheckBox deposit;
    @FXML
    private HBox managementFeeHbox;
    @FXML
    private CheckBox deductManagementFee;
    @FXML
    private HBox vsmHBox;
    @FXML
    private CheckBox requireVSM;
    @FXML
    private HBox fixedAssetHBox;
    @FXML
    private CheckBox requireFixedAsset;
    @FXML
    private Button searchAccount;
    @FXML
    private HBox regionHBox;
    @FXML
    private CheckBox requireRegion;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.account.setItems(Account.getAccounts(this.getUser()));
    }

    public ChargeItem getChargeItem() {
        return this.chargeItem;
    }

    public void setChargeItem(ChargeItem chargeItem) {
        this.chargeItem = chargeItem;
        this.description.setText(chargeItem.getName());
        this.account.setValue((Object)chargeItem.getAccount());
        this.taxable.setSelected(chargeItem.isTaxable());
        this.taxrate.setText(chargeItem.getTaxRate() + "");
        this.taxrate.setDisable(!this.taxable.isSelected());
        this.addChargeItem.setText("Save Changes");
        this.amount.setText(chargeItem.getAmount() + "");
        this.deposit.setSelected(chargeItem.isDeposit());
        this.deductManagementFee.setSelected(chargeItem.isDeductManagementFee());
        this.requireVSM.setSelected(chargeItem.isRequireVSM());
        this.requireFixedAsset.setSelected(chargeItem.isRequireFixedAsset());
        this.requireRegion.setSelected(chargeItem.isRequireRegion());
        this.postTo.setValue((Object)chargeItem.getPostTo());
        try {
            if (!((String)this.postTo.getValue()).trim().equalsIgnoreCase("landlord")) {
                this.account.setDisable(false);
            } else {
                this.account.setDisable(true);
                this.account.setValue(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getCategory() {
        return this.category;
    }

    public void setCategory(int category) {
        this.category = category;
        if (category == 5) {
            this.account.setDisable(true);
        } else {
            this.depositHBox.setVisible(false);
            this.managementFeeHbox.setVisible(false);
            this.postToHBox.setVisible(false);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.depositHBox.managedProperty().bind((ObservableValue)this.depositHBox.visibleProperty());
        this.postToHBox.managedProperty().bind((ObservableValue)this.postToHBox.visibleProperty());
        this.managementFeeHbox.managedProperty().bind((ObservableValue)this.managementFeeHbox.visibleProperty());
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.description, Validator.createEmptyValidator((String)"Required"));
        if (this.getCategory() != 5) {
            vs.registerValidator(this.account, Validator.createEmptyValidator((String)"Required"));
        }
        this.notificationPane.setContent((Node)this.holder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.notificationPane.setCloseButtonVisible(true);
        this.taxrate.setDisable(!this.taxable.isSelected());
        this.taxable.setOnAction(e -> this.taxrate.setDisable(!this.taxable.isSelected()));
        ObservableList postToOptions = FXCollections.observableArrayList();
        postToOptions.addAll((Object[])new String[]{"Landlord", "G/L Account"});
        this.postTo.setItems(postToOptions);
        this.postTo.setValue((Object)"Landlord");
        this.postTo.setOnAction(r -> {
            if (!((String)this.postTo.getValue()).trim().equalsIgnoreCase("landlord")) {
                this.account.setDisable(false);
            } else {
                this.account.setDisable(true);
                this.account.setValue(null);
            }
        });
        this.searchAccount.setOnAction(e -> {
            try {
                Gson gson = new Gson();
                String response = new Config().getObjectFromSelection("glaccount", gson.toJson((Object)this.account.getItems()), this.getUser());
                Account selected = (Account)gson.fromJson(response, Account.class);
                this.account.setValue((Object)selected);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.taxrate.addEventFilter(KeyEvent.KEY_TYPED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (!event.getCharacter().matches("[0123456789.]")) {
                    event.consume();
                }
            }
        });
        this.amount.addEventFilter(KeyEvent.KEY_TYPED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (!event.getCharacter().matches("[0123456789.]")) {
                    event.consume();
                }
            }
        });
        this.addChargeItem.setOnAction(e -> {
            String tDescription = this.description.getText().trim();
            Account glAccount = (Account)this.account.getValue();
            boolean tTaxable = this.taxable.isSelected();
            String tTaxRate = this.taxrate.getText().trim();
            double mTaxRate = 0.0;
            double mAmount = 0.0;
            boolean error = false;
            String message = "";
            String tAccountNumber = "";
            if (tDescription.length() < 4) {
                message = "Please provide a valid description. It must be more than 4 characters";
                error = true;
            }
            try {
                tAccountNumber = glAccount.getAccountNumber();
                if (tAccountNumber.equals(null) || tAccountNumber.equals("") || tAccountNumber.isEmpty()) {
                    throw new Exception();
                }
            }
            catch (Exception y) {
                if (this.getCategory() == 5) {
                    tAccountNumber = "";
                }
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select the G/L Account of the charge item";
                error = true;
            }
            if (tTaxable) {
                try {
                    mTaxRate = Double.parseDouble(tTaxRate);
                    if (mTaxRate > 100.0) {
                        message = message + (message.length() > 0 ? "\n" : "");
                        message = message + "Please enter a valid tax rate. It should be less than 100";
                        error = true;
                    }
                    if (!(mTaxRate > 0.0)) {
                        message = message + (message.length() > 0 ? "\n" : "");
                        message = message + "Please enter a valid tax rate. It should be more than 0";
                        error = true;
                    }
                }
                catch (Exception t) {
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please enter a valid tax rate";
                    error = true;
                }
            }
            try {
                mAmount = Double.parseDouble(this.amount.getText().trim());
            }
            catch (Exception u) {
                mAmount = 0.0;
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            } else {
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    try {
                        ChargeItem ci = this.getChargeItem();
                        int code = ci.getCode();
                        if (code > 0) {
                            params.put("code", code);
                        }
                    }
                    catch (Exception ci) {
                        // empty catch block
                    }
                    String tPostTo = "";
                    try {
                        tPostTo = ((String)this.postTo.getValue()).trim();
                    }
                    catch (Exception u) {
                        tPostTo = "";
                    }
                    params.put("category", this.getCategory());
                    params.put("description", tDescription);
                    params.put("accountNo", tAccountNumber);
                    params.put("taxable", tTaxable ? 1 : 0);
                    params.put("deposit", this.deposit.isSelected() ? 1 : 0);
                    params.put("deductManagementFee", this.deductManagementFee.isSelected() ? 1 : 0);
                    params.put("postTo", tPostTo);
                    params.put("taxRate", mTaxRate);
                    params.put("amount", mAmount);
                    params.put("requireVSM", this.requireVSM.isSelected() ? 1 : 0);
                    params.put("requireFixedAsset", this.requireFixedAsset.isSelected() ? 1 : 0);
                    params.put("requireRegion", this.requireRegion.isSelected() ? 1 : 0);
                    String response = Config.loadDataFromPhp("mastercreate?type=chargeitem", params, this.getUser());
                    System.out.println(response);
                    Gson g = new Gson();
                    JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        Stage stage = (Stage)this.addChargeItem.getScene().getWindow();
                        stage.close();
                    } else {
                        this.notificationPane.setText(jr.getMessage());
                        this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                        this.notificationPane.show();
                    }
                }
                catch (Exception t) {
                    t.printStackTrace();
                    this.notificationPane.setText("We experienced an error while adding the charge item. Please try again later.");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
            }
        });
    }
}

