/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.ServiceFeeVoucher;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.ImportServiceFee;
import controllers.ServiceFeeCardController;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.controlsfx.control.NotificationPane;

public class ChargeServiceFeeController
implements Initializable {
    private User user;
    boolean posted;
    @FXML
    private JFXButton createVoucher;
    @FXML
    private JFXButton importServiceFee;
    @FXML
    private JFXButton editVoucher;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private JFXButton refresh;
    @FXML
    private JFXButton delete;
    @FXML
    private TableView<ServiceFeeVoucher> allVouchers;
    @FXML
    private TableColumn code;
    @FXML
    private TableColumn period;
    @FXML
    private TableColumn createdOn;
    @FXML
    private TableColumn totalAmount;
    @FXML
    private TableColumn noOfVehicles;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public boolean isPosted() {
        return this.posted;
    }

    public void setPosted(boolean posted) {
        this.posted = posted;
        this.loadVouchers(this.getUser());
        this.createVoucher.setDisable(posted);
        this.importServiceFee.setDisable(posted);
        this.delete.setDisable(posted);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.refresh.setOnAction(e -> this.loadVouchers(this.getUser()));
        this.code.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        this.period.setCellValueFactory((Callback)new PropertyValueFactory("period"));
        this.createdOn.setCellValueFactory((Callback)new PropertyValueFactory("createdOn"));
        this.totalAmount.setCellValueFactory((Callback)new PropertyValueFactory("amountString"));
        this.noOfVehicles.setCellValueFactory((Callback)new PropertyValueFactory("noOfVehicles"));
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.allVouchers);
        this.editVoucher.setOnAction(e -> {
            try {
                ServiceFeeVoucher voucher = (ServiceFeeVoucher)this.allVouchers.getSelectionModel().getSelectedItem();
                int voucherNo = voucher.getId();
                this.editVoucher(voucher);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.delete.setOnAction(e -> {
            try {
                ServiceFeeVoucher voucher = (ServiceFeeVoucher)this.allVouchers.getSelectionModel().getSelectedItem();
                int voucherNo = voucher.getId();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("voucherNo", voucherNo);
                String response = Config.loadDataFromPhp("masterdelete?type=servicefeevoucher", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    this.loadVouchers(this.getUser());
                }
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
            }
            catch (NullPointerException voucher) {
            }
            catch (Exception y) {
                this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
        this.allVouchers.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    ServiceFeeVoucher rowData = (ServiceFeeVoucher)row.getItem();
                    ServiceFeeVoucher voucher = (ServiceFeeVoucher)this.allVouchers.getSelectionModel().getSelectedItem();
                    if (!voucher.equals(null)) {
                        this.editVoucher(voucher);
                    }
                }
            });
            return row;
        });
        this.createVoucher.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/serviceFeeCard.fxml").openStream());
                ServiceFeeCardController controller = (ServiceFeeCardController)loader.getController();
                controller.setUser(this.getUser());
                Scene scene = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(scene);
                stage.setResizable(false);
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.setTitle("Create Voucher");
                stage.show();
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ChargeServiceFeeController.this.loadVouchers(ChargeServiceFeeController.this.getUser());
                            }
                        });
                    }
                });
            }
            catch (Exception j) {
                j.printStackTrace();
            }
        });
        this.importServiceFee.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/importservicefee.fxml").openStream());
                ImportServiceFee controller = (ImportServiceFee)loader.getController();
                controller.setUser(this.getUser());
                Scene scene = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(scene);
                stage.setTitle("Import Service Fee");
                stage.show();
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ChargeServiceFeeController.this.loadVouchers(ChargeServiceFeeController.this.getUser());
                            }
                        });
                    }
                });
            }
            catch (Exception j) {
                j.printStackTrace();
            }
        });
    }

    public void loadVouchers(User user) {
        this.allVouchers.setItems(new ServiceFeeVoucher().getAllVouchers(this.isPosted(), user));
    }

    public void editVoucher(ServiceFeeVoucher sfv) {
        try {
            FXMLLoader loader = new FXMLLoader();
            AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/serviceFeeCard.fxml").openStream());
            Scene editVoucherScreen = new Scene((Parent)itemPane, 839.0, 658.0);
            final Stage stage = new Stage();
            editVoucherScreen.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(editVoucherScreen);
            ServiceFeeCardController controller = (ServiceFeeCardController)loader.getController();
            controller.setUser(this.getUser());
            controller.setVoucher(sfv);
            stage.setTitle("Edit Service Fee Voucher");
            stage.setResizable(false);
            try {
                stage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ChargeServiceFeeController.this.loadVouchers(ChargeServiceFeeController.this.getUser());
                        }
                    });
                }
            });
            stage.showAndWait();
        }
        catch (Exception p) {
            p.printStackTrace();
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while loading your edit service fee voucher screen. Please contact support");
            alert.showAndWait();
        }
    }
}

