/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.MemberImport;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.AllMembersController;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;
import org.controlsfx.control.NotificationPane;

public class ConfirmMemberImport
implements Initializable {
    private User user;
    @FXML
    private AnchorPane holder;
    @FXML
    private TableView<MemberImport> membersToImport;
    @FXML
    private TableColumn colMemberNumber;
    @FXML
    private TableColumn colFirstName;
    @FXML
    private TableColumn colMiddleName;
    @FXML
    private TableColumn colLastName;
    @FXML
    private TableColumn colIdNumber;
    @FXML
    private TableColumn colPhoneNumber;
    @FXML
    private TableColumn colEmailAddress;
    @FXML
    private TableColumn colDateOfBirth;
    @FXML
    private TableColumn colKraPin;
    @FXML
    NotificationPane notificationPane;
    @FXML
    private JFXButton importMembers;
    @FXML
    private JFXButton cancel;
    @FXML
    private ProgressBar progress;
    private ObservableList<MemberImport> dataSource;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public ObservableList<MemberImport> getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(ObservableList<MemberImport> dataSource) {
        this.dataSource = dataSource;
        this.membersToImport.setItems(dataSource);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.colMemberNumber.setCellValueFactory((Callback)new PropertyValueFactory("memberNo"));
        this.colFirstName.setCellValueFactory((Callback)new PropertyValueFactory("firstName"));
        this.colMiddleName.setCellValueFactory((Callback)new PropertyValueFactory("middleName"));
        this.colLastName.setCellValueFactory((Callback)new PropertyValueFactory("lastName"));
        this.colIdNumber.setCellValueFactory((Callback)new PropertyValueFactory("idNumber"));
        this.colPhoneNumber.setCellValueFactory((Callback)new PropertyValueFactory("phoneNumber"));
        this.colEmailAddress.setCellValueFactory((Callback)new PropertyValueFactory("emailAddress"));
        this.colDateOfBirth.setCellValueFactory((Callback)new PropertyValueFactory("dob"));
        this.colKraPin.setCellValueFactory((Callback)new PropertyValueFactory("kraPin"));
        this.importMembers.setOnAction(e -> {
            this.notificationPane.setGraphic((Node)new ProgressIndicator());
            this.notificationPane.setText("Validating your data. Please wait...");
            this.notificationPane.show();
            this.startTask();
        });
        this.notificationPane.setContent((Node)this.holder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.notificationPane.setCloseButtonVisible(true);
    }

    public void startTask() {
        Task<Void> task = new Task<Void>(){

            public Void call() throws InterruptedException {
                ObservableList myImports = ConfirmMemberImport.this.membersToImport.getItems();
                Gson g = new Gson();
                try {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ConfirmMemberImport.this.notificationPane.setText("Importing members. Please wait...");
                            ConfirmMemberImport.this.notificationPane.show();
                            try {
                                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                                Gson g = new Gson();
                                String response2 = Config.loadDataFromPhp("mastercreate?type=importmembers", params, ConfirmMemberImport.this.getUser());
                                JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                                if (myResponse.isStatus()) {
                                    AllMembersController.confirmImport.close();
                                } else {
                                    ConfirmMemberImport.this.notificationPane.setText(myResponse.getMessage());
                                    FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.TIMES);
                                    icon.setStyle("-fx-fill: #d32f2f;");
                                    icon.setSize("24.0");
                                    ConfirmMemberImport.this.notificationPane.setGraphic((Node)icon);
                                }
                            }
                            catch (Exception o) {
                                ConfirmMemberImport.this.notificationPane.setText("We encountered an error while importing your member list. Please try again later. ");
                                FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.BAN);
                                icon.setStyle("-fx-fill: #d32f2f;");
                                icon.setSize("24.0");
                                ConfirmMemberImport.this.notificationPane.setGraphic((Node)icon);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task);
        backgroundThread.setDaemon(true);
        this.progress.progressProperty().bind((ObservableValue)task.progressProperty());
        backgroundThread.start();
    }
}

