/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.Contact;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.User;
import com.google.gson.Gson;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class CreateContact
implements Initializable {
    private User user;
    @FXML
    private VBox vbCreateContact;
    @FXML
    private VBox vbHolder;
    @FXML
    private Label labelId;
    @FXML
    private TextField tfName;
    @FXML
    private TextField tfNumber;
    @FXML
    private Button btnSave;
    @FXML
    private Button btnCancel;
    @FXML
    private NotificationPane notificationPane;
    private Contact contact;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.vbHolder);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.tfName, Validator.createEmptyValidator((String)"Name is required"));
        vs.registerValidator((Control)this.tfNumber, Validator.createEmptyValidator((String)"Phone Number is required"));
        this.tfNumber.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.matches("\\d*")) {
                if (oldValue != null) {
                    this.tfNumber.setText(oldValue);
                } else {
                    this.tfNumber.setText("");
                }
            }
        });
    }

    @FXML
    void cancel(ActionEvent event) {
        Stage stage = (Stage)this.vbCreateContact.getScene().getWindow();
        stage.fireEvent(new Event(WindowEvent.WINDOW_CLOSE_REQUEST));
    }

    @FXML
    void saveContact(ActionEvent event) {
        String name = null;
        String number = null;
        boolean error = false;
        String errorMessage = "";
        NumberSeries ns = new NumberSeries(43, this.getUser());
        String id = this.labelId.getText().trim().length() > 1 ? this.labelId.getText().trim() : ns.getNextNumber();
        try {
            name = this.tfName.getText().trim();
            if (name.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage + "Enter a valid name";
        }
        try {
            number = this.tfNumber.getText().trim();
            if (number.length() < 10) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage + (errorMessage.length() > 1 ? "\nEnter a valid number. Must be 10 digits" : "Enter a valid number. Must be 10 digits");
        }
        if (error) {
            this.notificationPane.setText(errorMessage);
            this.notificationPane.show();
        } else {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("id", id);
            params.put("name", name);
            params.put("phoneNumber", number);
            String response = Config.loadDataFromPhp("mastercreate?type=contact", params, this.getUser());
            System.out.println(response);
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                if (this.labelId.getText().length() < 1) {
                    ns.updateLastUsed(id);
                    this.labelId.setText(id);
                }
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.show();
            } else {
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.show();
            }
        }
    }

    public void setContact(Contact contact) {
        this.contact = contact;
        this.labelId.setText(contact.getId());
        this.tfName.setText(contact.getName());
        this.tfNumber.setText(contact.getPhoneNumber());
    }
}

