/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.Contact;
import classes.ContactsGroup;
import classes.GroupMember;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.User;
import com.google.gson.Gson;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class CreateGroup
implements Initializable {
    private User user;
    @FXML
    private VBox vbCreateGroup;
    @FXML
    private VBox vbHolder;
    @FXML
    private Label labelId;
    @FXML
    private TextField tfName;
    @FXML
    private ComboBox<Object> cbContact;
    @FXML
    private Button btnAdd;
    @FXML
    private TableView<GroupMember> tvMembers;
    public static TableView<GroupMember> publicTable;
    @FXML
    private TableColumn<?, ?> tcId;
    @FXML
    private TableColumn<?, ?> tcName;
    @FXML
    private TableColumn<?, ?> tcPhone;
    @FXML
    private TableColumn<?, ?> tcRemove;
    @FXML
    private Button btnSave;
    @FXML
    private Button btnCancel;
    @FXML
    private NotificationPane notificationPane;
    private ContactsGroup group;
    private ObservableList<GroupMember> members;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.cbContact.setItems(new Contact().getAllContacts(this.getUser()));
    }

    public void initialize(URL location, ResourceBundle resources) {
        publicTable = this.tvMembers;
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.vbHolder);
        this.tcId.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.tcPhone.setCellValueFactory((Callback)new PropertyValueFactory("phone"));
        this.tcRemove.setCellValueFactory((Callback)new PropertyValueFactory("remove"));
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.tfName, Validator.createEmptyValidator((String)"Name is required"));
    }

    @FXML
    void addToGroup(ActionEvent event) {
        Contact contact;
        String id = this.labelId.getText().trim();
        if (id.length() < 1) {
            this.save();
            id = this.labelId.getText().trim();
        }
        if ((contact = (Contact)this.cbContact.getValue()) == null) {
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.setText("Select contact to add to this group");
            this.notificationPane.show();
        } else {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("group", id);
            params.put("contact", contact.getId());
            String response = Config.loadDataFromPhp("mastercreate?type=groupmember", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                this.members = new GroupMember().getAllMembers(id, this.getUser());
                this.itemsToTable();
            }
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.show();
        }
    }

    @FXML
    void cancel(ActionEvent event) {
        Stage stage = (Stage)this.vbCreateGroup.getScene().getWindow();
        stage.fireEvent(new Event(WindowEvent.WINDOW_CLOSE_REQUEST));
    }

    @FXML
    void saveGroup(ActionEvent event) {
        this.save();
    }

    private boolean save() {
        boolean error = false;
        String errorMessage = "";
        String name = "";
        NumberSeries ns = new NumberSeries(44, this.getUser());
        String id = this.labelId.getText().trim().length() > 1 ? this.labelId.getText().trim() : ns.getNextNumber();
        try {
            name = this.tfName.getText().trim();
            if (name.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            errorMessage = "Enter a valid name for contact group";
        }
        if (error) {
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.setText(errorMessage);
            this.notificationPane.show();
        } else {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("id", id);
            params.put("name", name);
            String response = Config.loadDataFromPhp("mastercreate?type=contactgroup", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.show();
            if (jr.isStatus()) {
                if (this.labelId.getText().trim().length() < 1) {
                    this.labelId.setText(id);
                    ns.updateLastUsed(id);
                }
                return true;
            }
        }
        return false;
    }

    public void setGroup(ContactsGroup contactsGroup) {
        this.group = contactsGroup;
        this.members = new GroupMember().getAllMembers(contactsGroup.getId(), this.getUser());
        this.tvMembers.setItems(this.members);
        this.tfName.setText(contactsGroup.getName());
        this.labelId.setText(contactsGroup.getId());
    }

    public void itemsToTable() {
        this.tvMembers.setItems(this.members);
    }
}

