/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.Contact;
import classes.ContactsGroup;
import classes.JsonResponses;
import classes.Sms;
import classes.User;
import com.google.gson.Gson;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class CreateMessage
implements Initializable {
    private User user;
    @FXML
    private VBox vbCreateMessage;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox vbHolder;
    @FXML
    private ComboBox<String> cbType;
    @FXML
    private ComboBox<Object> cbRecipient;
    @FXML
    private Label labelMessage;
    @FXML
    private Label labelId;
    @FXML
    private TextArea taMessage;
    @FXML
    private TextField tfNumber;
    @FXML
    private Button btnSaveDraft;
    @FXML
    private Button btnCancel;
    @FXML
    private Button btnSend;
    private Sms sms;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.vbHolder);
        this.cbType.setItems(FXCollections.observableArrayList(Arrays.asList("Group", "Individual")));
        this.cbType.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.equals("Group")) {
                Platform.runLater(() -> {
                    this.btnSaveDraft.setDisable(true);
                    this.cbRecipient.setItems(new ContactsGroup().getAllGroups(this.getUser()));
                    this.tfNumber.setEditable(false);
                });
            } else if (newValue.equals("Individual")) {
                Platform.runLater(() -> {
                    this.cbRecipient.setItems(new Contact().getAllContacts(this.getUser()));
                    this.btnSaveDraft.setDisable(false);
                    this.tfNumber.setEditable(true);
                });
            }
        });
        this.cbRecipient.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (this.cbType.getValue() != null && ((String)this.cbType.getValue()).equals("Individual")) {
                this.tfNumber.setText(((Contact)this.cbRecipient.getValue()).getPhoneNumber());
            }
        });
        this.tfNumber.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.matches("\\d*")) {
                if (oldValue != null) {
                    this.tfNumber.setText(oldValue);
                } else {
                    this.tfNumber.setText("");
                }
            }
        });
        this.cbType.getSelectionModel().select((Object)"Individual");
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.taMessage, Validator.createEmptyValidator((String)"Name is required"));
        vs.registerValidator(this.cbRecipient, Validator.createEmptyValidator((String)"Name is required"));
    }

    @FXML
    void cancel(ActionEvent event) {
        Stage stage = (Stage)this.vbCreateMessage.getScene().getWindow();
        stage.fireEvent(new Event(WindowEvent.WINDOW_CLOSE_REQUEST));
    }

    @FXML
    void saveDraft(ActionEvent event) {
        Contact contact;
        String type = (String)this.cbType.getValue();
        String recipient = null;
        String recipientNo = null;
        String message = null;
        String recipientType = null;
        boolean error = false;
        String errorMessage = "";
        try {
            contact = (Contact)this.cbRecipient.getValue();
            recipient = contact.getId();
            recipientNo = contact.getPhoneNumber();
            recipientType = "individual";
        }
        catch (Exception e) {
            recipient = "";
        }
        try {
            recipientNo = this.tfNumber.getText().trim();
            contact = (Contact)this.cbRecipient.getValue();
            if (contact != null && !contact.equals(recipientNo)) {
                recipient = "";
            }
            if (recipientNo.length() < 10) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            errorMessage = "Invalid phone number";
        }
        try {
            message = this.taMessage.getText().trim();
            if (message.equals("") || message.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            String string = errorMessage = errorMessage.length() > 1 ? "Enter a valid message" : "\nPlease Enter a valid message";
        }
        if (error) {
            this.notificationPane.setText(errorMessage);
            this.notificationPane.show();
        } else {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            if (this.labelId.getText().trim().length() > 0) {
                params.put("id", this.labelId.getText().trim());
            }
            params.put("recipientType", recipientType);
            params.put("recipient", recipient);
            params.put("recipientNo", recipientNo);
            params.put("message", message);
            params.put("status", "saved");
            String response = Config.loadDataFromPhp("mastercreate?type=sms", params, this.getUser());
            System.out.println(response);
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.show();
            if (jr.isStatus()) {
                Stage stage = (Stage)this.vbCreateMessage.getScene().getWindow();
                stage.fireEvent(new Event(WindowEvent.WINDOW_CLOSE_REQUEST));
            }
        }
    }

    @FXML
    void sendMesage(ActionEvent event) {
        String type = (String)this.cbType.getValue();
        String recipient = null;
        String recipientNo = null;
        String message = null;
        String recipientType = null;
        boolean error = false;
        String errorMessage = "";
        try {
            if (type.equals("Group")) {
                ContactsGroup group = (ContactsGroup)this.cbRecipient.getValue();
                recipient = group.getId();
                recipientType = "group";
            } else if (type.equals("Individual")) {
                Contact contact = (Contact)this.cbRecipient.getValue();
                if (contact == null) {
                    recipient = "";
                    recipientNo = this.tfNumber.getText();
                } else {
                    recipient = contact.getId();
                    recipientNo = contact.getPhoneNumber();
                }
                if (recipientNo.length() < 10) {
                    throw new Exception();
                }
                if (contact != null && !recipientNo.equals(contact.getPhoneNumber())) {
                    recipient = "";
                }
                recipientType = "individual";
            }
        }
        catch (Exception e) {
            error = true;
            errorMessage = "Invalid recipient(s)/ number" + e.getMessage();
            e.printStackTrace();
        }
        try {
            message = this.taMessage.getText().trim();
            if (message.equals("") || message.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            String string = errorMessage = errorMessage.length() > 1 ? "Enter a valid message" : "\nPlease Enter a valid message";
        }
        if (error) {
            this.notificationPane.setText(errorMessage);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        } else {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            if (this.labelId.getText().trim().length() > 0) {
                params.put("id", this.labelId.getText().trim());
            }
            params.put("recipientType", recipientType);
            params.put("recipient", recipient);
            params.put("recipientNo", recipientNo);
            params.put("message", message);
            params.put("status", "sent");
            String response = Config.loadDataFromPhp("mastercreate?type=sms", params, this.getUser());
            System.out.println(response);
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.show();
            if (jr.isStatus()) {
                Stage stage = (Stage)this.vbCreateMessage.getScene().getWindow();
                stage.fireEvent(new Event(WindowEvent.WINDOW_CLOSE_REQUEST));
            }
        }
    }

    public void setSms(Sms sms) {
        this.sms = sms;
        this.labelId.setText(sms.getId());
        this.tfNumber.setText(sms.getNumber());
        for (Object c : new Contact().getAllContacts(this.getUser())) {
            Contact cn = (Contact)c;
            if (!cn.getId().equals(sms.getContact().getId())) continue;
            this.cbRecipient.getSelectionModel().select((Object)cn);
        }
        this.taMessage.setText(sms.getMessage());
        this.cbType.setDisable(true);
        if (sms.getStatus().equals("sent")) {
            this.btnSaveDraft.setDisable(true);
            this.btnSend.setDisable(true);
            this.cbRecipient.setDisable(true);
            this.taMessage.setEditable(false);
            this.tfNumber.setEditable(false);
        }
    }
}

