/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.Customer;
import classes.Floor;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.PostingGroup;
import classes.PricingGroup;
import classes.Property;
import classes.Region;
import classes.Units;
import classes.User;
import classes.Vendor;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import sun.misc.BASE64Decoder;

public class CustomerCardController
implements Initializable {
    private String customerType;
    private Customer customer;
    private User user;
    String imagePath = "";
    @FXML
    private VBox root;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private TabPane holder;
    @FXML
    private Label customerNoLabel;
    @FXML
    private Label customerNo;
    @FXML
    private TextField firstName;
    @FXML
    private Button searchKRAPin;
    @FXML
    private TextField idNumber;
    @FXML
    private TextField phoneNumber;
    @FXML
    private TextField emailAddress;
    @FXML
    private TextField creditLimit;
    @FXML
    private TextField creditPeriod;
    @FXML
    private TextField contactPerson;
    @FXML
    private TextField contactPhone;
    @FXML
    private TextField contactPosition;
    @FXML
    private TextField contactEmailAddress;
    @FXML
    private TextArea remarks;
    @FXML
    private ComboBox<PostingGroup> postingGroup;
    @FXML
    private TextField kraPin;
    @FXML
    private DatePicker dateOfBirth;
    @FXML
    private JFXButton addCustomer;
    @FXML
    private ComboBox<PricingGroup> pricingGroup;
    @FXML
    private ComboBox<String> customerStatus;
    @FXML
    private JFXButton reset;
    @FXML
    private Tab generalDetailsTab;
    @FXML
    private ComboBox<Region> region;
    @FXML
    private ComboBox<Vendor> salesRep;
    @FXML
    private Tab nextOfKinTab;
    @FXML
    private TextField kinName;
    @FXML
    private TextField kinIdNo;
    @FXML
    private TextField kinPhoneNo;
    @FXML
    private ComboBox<String> kinRelationship;
    @FXML
    private Tab unitAllocationTab;
    @FXML
    private ComboBox<Property> property;
    @FXML
    private ComboBox<Floor> floor;
    @FXML
    private ComboBox<Units> unit;
    @FXML
    private DatePicker entryDate;
    @FXML
    private HBox dmsNoHBox;
    @FXML
    private TextField dmsNo;

    public String getCustomerType() {
        return this.customerType;
    }

    public void setCustomerType(String customerType) {
        this.customerType = customerType;
        if (customerType.equalsIgnoreCase("generalCustomer")) {
            this.holder.getTabs().remove((Object)this.nextOfKinTab);
            this.holder.getTabs().remove((Object)this.unitAllocationTab);
        } else if (customerType.equalsIgnoreCase("tenant")) {
            this.customerNoLabel.setText("Tenant No:");
            this.addCustomer.setText("Add Tenant");
            this.kinRelationship.setItems(new Config().getEnumText("customers", "next_of_kin_relationship", this.getUser()));
            this.generalDetailsTab.setText("Tenant Details");
            this.property.setItems(new Property().getAllProperties(this.getUser()));
        }
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
        this.customerNo.setText(customer.getCustomerNumber());
        this.firstName.setText(customer.getCustomerName());
        this.idNumber.setText(customer.getCustomerId());
        this.phoneNumber.setText(customer.getCustomerPhone());
        this.emailAddress.setText(customer.getCustomerEmail());
        this.kraPin.setText(customer.getKraPin());
        this.postingGroup.setValue((Object)customer.getCustomerPostingGroup());
        try {
            this.region.setValue((Object)customer.getRegion());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.salesRep.setValue((Object)customer.getSalesRep());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.dateOfBirth.setValue((Object)Config.stringToLocalDate(customer.getDateOfBirth()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.dmsNo.setText(customer.getDmsNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.kinName.setText(customer.getKinName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.kinIdNo.setText(customer.getKinIdNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.kinPhoneNo.setText(customer.getKinPhoneNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.kinRelationship.setValue((Object)customer.getKinRelationship());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.property.setValue((Object)customer.getProperty());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.floor.setValue((Object)customer.getFloor());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.unit.setValue((Object)customer.getUnit());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.entryDate.setValue((Object)Config.stringToLocalDate(customer.getEntryDate()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] imageByte = decoder.decodeBuffer(customer.getImage());
            ByteArrayInputStream bis = new ByteArrayInputStream(imageByte);
            Image image = new Image((InputStream)bis);
            bis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.pricingGroup.setValue((Object)customer.getPricingGroup());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.contactPerson.setText(customer.getContactPersonName());
        this.contactPhone.setText(customer.getContactPersonPhone());
        this.contactPosition.setText(customer.getContactPersonJobPosition());
        this.contactEmailAddress.setText(customer.getContactPersonEmail());
        this.remarks.setText(customer.getRemarks());
        this.creditPeriod.setText(customer.getCreditPeriod() + "");
        this.creditLimit.setText(customer.getCreditLimit() + "");
        this.addCustomer.setText("Save Changes");
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(final User user) {
        this.user = user;
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    CustomerCardController.this.notificationPane.setText("Loading Values. Please wait");
                    CustomerCardController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    CustomerCardController.this.notificationPane.show();
                });
                ObservableList<PostingGroup> allGroups = new PostingGroup().getAllPostingGroups(1, user);
                ObservableList<Region> allRegions = new Region().getAllRegions(user);
                ObservableList<Vendor> allReps = new Vendor().getAllVendors("Sales Rep", user);
                ObservableList<PricingGroup> allPrices = new PricingGroup().getPricingGroups(user);
                ObservableList allStatus = FXCollections.observableArrayList();
                allStatus.add((Object)"Active");
                allStatus.add((Object)"Blocked - Sales");
                allStatus.add((Object)"Blocked - Payments");
                allStatus.add((Object)"Blocked");
                allStatus.add((Object)"Archived");
                Platform.runLater(() -> {
                    CustomerCardController.this.postingGroup.setItems(allGroups);
                    CustomerCardController.this.region.setItems(allRegions);
                    CustomerCardController.this.salesRep.setItems(allReps);
                    CustomerCardController.this.pricingGroup.setItems(allPrices);
                    CustomerCardController.this.customerStatus.setItems(allStatus);
                    CustomerCardController.this.customerStatus.setValue(allStatus.get(0));
                    CustomerCardController.this.notificationPane.hide();
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.dmsNoHBox.managedProperty().bind((ObservableValue)this.dmsNoHBox.visibleProperty());
        if (!Config.showDMSNo) {
            this.dmsNoHBox.setVisible(false);
        }
        String path = System.getProperty("user.dir");
        path = path.replace("\\", "/");
        this.imagePath = path + "/holder.png";
        this.reset.setOnAction(e -> ((Stage)this.reset.getScene().getWindow()).close());
        this.property.setOnAction(e -> {
            Task<Void> task1 = new Task<Void>(){

                public Void call() {
                    String propertyCode = ((Property)CustomerCardController.this.property.getValue()).getPropertyCode();
                    CustomerCardController.this.floor.setItems(new Floor().getAllFloors(propertyCode, CustomerCardController.this.getUser()));
                    CustomerCardController.this.unit.setItems(new Units().getAllUnits(propertyCode, CustomerCardController.this.getUser()));
                    return null;
                }
            };
            Thread backgroundThread = new Thread((Runnable)task1);
            backgroundThread.setDaemon(true);
            backgroundThread.start();
        });
        this.floor.setOnAction(e -> {
            Task<Void> task1 = new Task<Void>(){

                public Void call() {
                    String propertyCode = ((Property)CustomerCardController.this.property.getValue()).getPropertyCode();
                    String floorId = ((Floor)CustomerCardController.this.floor.getValue()).getFloorId() + "";
                    CustomerCardController.this.unit.setItems(new Units().getFloorUnits(propertyCode, floorId, CustomerCardController.this.getUser()));
                    return null;
                }
            };
            Thread backgroundThread = new Thread((Runnable)task1);
            backgroundThread.setDaemon(true);
            backgroundThread.start();
        });
        ContextMenu imageOptions = new ContextMenu();
        MenuItem upload = new MenuItem("Upload");
        upload.setOnAction(e -> {
            FileChooser chooser = new FileChooser();
            chooser.setTitle("Select Item Picture");
            chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("All Images", new String[]{"*.jpg", "*.png"}), new FileChooser.ExtensionFilter("JPG", new String[]{"*.jpg"}), new FileChooser.ExtensionFilter("PNG", new String[]{"*.png"})});
            File file = chooser.showOpenDialog((Window)new Stage());
            if (file != null) {
                this.openFile(file);
            }
        });
        MenuItem reset = new MenuItem("Reset to Default");
        String myPath = path;
        reset.setOnAction(e -> {
            String fileLocation = myPath + "/holder.png";
            File imgFile = new File(fileLocation);
            this.openFile(imgFile);
        });
        imageOptions.getItems().addAll((Object[])new MenuItem[]{upload, reset});
        ValidationSupport validationSupport = new ValidationSupport();
        validationSupport.registerValidator((Control)this.firstName, Validator.createEmptyValidator((String)"First name is required"));
        validationSupport.registerValidator((Control)this.idNumber, Validator.createEmptyValidator((String)"Id number is required"));
        validationSupport.registerValidator((Control)this.phoneNumber, Validator.createEmptyValidator((String)"Phone number is required"));
        validationSupport.registerValidator((Control)this.kraPin, Validator.createEmptyValidator((String)"KRA PIN is required"));
        validationSupport.registerValidator((Control)this.kinIdNo, Validator.createEmptyValidator((String)"Required"));
        validationSupport.registerValidator((Control)this.kinName, Validator.createEmptyValidator((String)"Required"));
        validationSupport.registerValidator((Control)this.kinPhoneNo, Validator.createEmptyValidator((String)"Required"));
        validationSupport.registerValidator(this.property, Validator.createEmptyValidator((String)"Required"));
        validationSupport.registerValidator(this.unit, Validator.createEmptyValidator((String)"Required"));
        validationSupport.registerValidator((Control)this.entryDate, Validator.createEmptyValidator((String)"Required"));
        validationSupport.registerValidator((Control)this.dateOfBirth, Validator.createEmptyValidator((String)"Required"));
        validationSupport.registerValidator(this.postingGroup, Validator.createEmptyValidator((String)"Required"));
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        this.searchKRAPin.setOnAction(e -> {
            String myKra = this.kraPin.getText().trim();
            if (myKra.length() < 4) {
                this.notificationPane.setText("Please enter a valid kra pin");
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            } else {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("kraPin", myKra);
                String response = Config.loadDataFromPhp("masterfetch?type=krapinlookup", params, this.getUser());
                this.notificationPane.setGraphic((Node)Config.getCheckIcon());
                this.notificationPane.setText(response);
                this.notificationPane.show();
            }
        });
        this.addCustomer.setOnAction(e -> {
            int[] lengths;
            JsonResponses jr;
            String date;
            String tSalesRep;
            String tPostingGroup;
            String pin;
            String email;
            String phoneNo;
            String idNo;
            String customerName;
            this.addCustomer.setDisable(true);
            int regionCode = 0;
            int tPricingGroup = 0;
            int tCreditPeriod = 0;
            double tCreditLimit = 0.0;
            String tKinName = "";
            String tKinIdNo = "";
            String tKinPhoneNo = "";
            String tKinRelationship = "";
            String tProperty = "";
            String tFloor = "";
            String tUnit = "";
            String tEntryDate = "";
            String tContactPerson = "";
            String tContactPhone = "";
            String tContactPosition = "";
            String tContactEmail = "";
            String tRemarks = "";
            String tDMSNo = "";
            try {
                customerName = this.firstName.getText().trim();
            }
            catch (Exception u) {
                customerName = "";
            }
            try {
                idNo = this.idNumber.getText().trim();
            }
            catch (Exception y) {
                idNo = "";
            }
            try {
                phoneNo = this.phoneNumber.getText().trim();
            }
            catch (Exception y) {
                phoneNo = "";
            }
            try {
                email = this.emailAddress.getText().trim();
            }
            catch (Exception y) {
                email = "";
            }
            try {
                pin = this.kraPin.getText().trim();
            }
            catch (Exception y) {
                pin = "";
            }
            try {
                tPostingGroup = ((PostingGroup)this.postingGroup.getValue()).getCode() + "";
            }
            catch (Exception y) {
                tPostingGroup = "";
            }
            try {
                tSalesRep = ((Vendor)this.salesRep.getValue()).getVendorNumber();
            }
            catch (Exception y) {
                tSalesRep = "";
            }
            try {
                regionCode = ((Region)this.region.getValue()).getId();
            }
            catch (Exception y) {
                regionCode = 0;
            }
            try {
                tPricingGroup = ((PricingGroup)this.pricingGroup.getValue()).getId();
            }
            catch (Exception y) {
                tPricingGroup = 0;
            }
            try {
                tCreditLimit = Double.parseDouble(this.creditLimit.getText().trim());
            }
            catch (Exception y) {
                tCreditLimit = 0.0;
            }
            try {
                tCreditPeriod = Integer.parseInt(this.creditPeriod.getText().trim());
            }
            catch (Exception y) {
                tCreditPeriod = 0;
            }
            try {
                tContactPerson = this.contactPerson.getText().trim();
            }
            catch (Exception y) {
                tContactPerson = "";
            }
            try {
                tContactPhone = this.contactPhone.getText().trim();
            }
            catch (Exception y) {
                tContactPhone = "";
            }
            try {
                tContactPosition = this.contactPosition.getText().trim();
            }
            catch (Exception y) {
                tContactPosition = "";
            }
            try {
                tContactEmail = this.contactEmailAddress.getText().trim();
            }
            catch (Exception y) {
                tContactEmail = "";
            }
            try {
                tRemarks = this.remarks.getText().trim();
            }
            catch (Exception y) {
                tRemarks = "";
            }
            try {
                tDMSNo = this.dmsNo.getText().trim();
            }
            catch (Exception y) {
                tDMSNo = "";
            }
            try {
                LocalDate dob = (LocalDate)this.dateOfBirth.getValue();
                date = Config.localDateToString(dob);
            }
            catch (Exception t) {
                date = "";
            }
            ObservableList requiredFields = FXCollections.observableArrayList((Object[])new String[]{customerName, phoneNo, pin, tPostingGroup, date});
            ObservableList requiredHeaders = FXCollections.observableArrayList((Object[])new String[]{"Customer Name", "Phone No", "KRA PIN", "Customer Posting Group", "Date of Incorporation"});
            if (Config.MANDATORY_CUSTOMER_REG) {
                requiredFields.add((Object)idNo);
                requiredHeaders.add((Object)"Reg No");
            }
            if (!(jr = new Config().checkRequiredFields((ObservableList<String>)requiredFields, (ObservableList<String>)requiredHeaders, lengths = new int[]{3, 3, 10, 0, 1, 5})).isStatus()) {
                boolean error = false;
                String message = "";
                if (this.getCustomerType().equalsIgnoreCase("tenant")) {
                    try {
                        tKinName = this.kinName.getText().trim();
                        if (tKinName.length() == 0) {
                            throw new Exception();
                        }
                    }
                    catch (Exception i) {
                        error = true;
                        message = "Please enter the next of kin name";
                    }
                    try {
                        tKinIdNo = this.kinIdNo.getText().trim();
                        if (tKinIdNo.length() == 0) {
                            throw new Exception();
                        }
                    }
                    catch (Exception i) {
                        error = true;
                        message = message + (message.length() > 0 ? "\n" : "");
                        message = message + "Please enter the next of kin ID No";
                    }
                    try {
                        tKinPhoneNo = this.kinPhoneNo.getText().trim();
                        if (tKinPhoneNo.length() == 0) {
                            throw new Exception();
                        }
                    }
                    catch (Exception i) {
                        error = true;
                        message = message + (message.length() > 0 ? "\n" : "");
                        message = message + "Please enter the next of kin Phone No";
                    }
                    try {
                        tKinRelationship = ((String)this.kinRelationship.getValue()).trim();
                        if (tKinRelationship.length() == 0) {
                            throw new Exception();
                        }
                    }
                    catch (Exception i) {
                        error = true;
                        message = message + (message.length() > 0 ? "\n" : "");
                        message = message + "Please select the next of kin relationship";
                    }
                    try {
                        tProperty = ((Property)this.property.getValue()).getPropertyCode().trim();
                        if (tProperty.length() == 0) {
                            throw new Exception();
                        }
                    }
                    catch (Exception i) {
                        error = true;
                        message = message + (message.length() > 0 ? "\n" : "");
                        message = message + "Please select property to assign the tenant";
                    }
                    try {
                        tUnit = ((Units)this.unit.getValue()).getUnitId() + "";
                        if (tUnit.length() == 0) {
                            throw new Exception();
                        }
                    }
                    catch (Exception i) {
                        error = true;
                        message = message + (message.length() > 0 ? "\n" : "");
                        message = message + "Please select unit to assign the tenant";
                    }
                    try {
                        tFloor = ((Floor)this.floor.getValue()).getFloorId() + "";
                    }
                    catch (Exception p) {
                        error = true;
                        message = message + (message.length() > 0 ? "\n" : "");
                        message = message + "Please select floor to assign the tenant";
                    }
                    try {
                        tEntryDate = Config.localDateToString((LocalDate)this.entryDate.getValue());
                    }
                    catch (Exception u) {
                        error = true;
                        message = message + (message.length() > 0 ? "\n" : "");
                        message = message + "Please eneter the tenant entry date";
                    }
                }
                if (error) {
                    this.notificationPane.setText(message);
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                    this.addCustomer.setDisable(false);
                } else {
                    try {
                        this.notificationPane.setGraphic((Node)new ProgressIndicator());
                        this.notificationPane.setText("Adding Customer. Please wait...");
                        this.notificationPane.show();
                        String customerNumber = "";
                        boolean newCustomer = false;
                        NumberSeries nb = new NumberSeries(6, this.getUser());
                        try {
                            if (this.customerNo.getText().trim().length() < 1) {
                                throw new Exception();
                            }
                            customerNumber = this.customerNo.getText().trim();
                        }
                        catch (Exception u) {
                            newCustomer = true;
                            customerNumber = nb.getNextNumber();
                        }
                        ByteArrayOutputStream ba = Config.convertFileToJson(this.imagePath);
                        String photoJson = StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])ba.toByteArray()));
                        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                        params.put("customerNo", customerNumber);
                        params.put("customerName", customerName);
                        params.put("name", customerName);
                        params.put("idNo", idNo);
                        params.put("phoneNo", phoneNo);
                        params.put("email", email);
                        params.put("kraPin", pin);
                        params.put("dateOfBirth", date);
                        params.put("postingGroup", tPostingGroup);
                        params.put("salesAgent", tSalesRep);
                        params.put("region", regionCode);
                        params.put("pricingGroup", tPricingGroup);
                        params.put("creditLimit", tCreditLimit);
                        params.put("creditPeriod", tCreditPeriod);
                        params.put("customerType", this.getCustomerType());
                        params.put("kinName", tKinName);
                        params.put("kinIdNo", tKinIdNo);
                        params.put("kinPhoneNo", tKinPhoneNo);
                        params.put("kinRelationship", tKinRelationship);
                        params.put("property", tProperty);
                        params.put("floor", tFloor);
                        params.put("unit", tUnit);
                        params.put("entryDate", tEntryDate);
                        params.put("contactPerson", tContactPerson);
                        params.put("contactPhone", tContactPhone);
                        params.put("contactPosition", tContactPosition);
                        params.put("contactEmail", tContactEmail);
                        params.put("remarks", tRemarks);
                        params.put("dmsNO", tDMSNo);
                        Gson g = new Gson();
                        String url = "mastercreate?type=customer";
                        if (!newCustomer) {
                            url = "masterupdate?type=customer";
                        } else {
                            params.put("photo", photoJson);
                        }
                        String response2 = Config.loadDataFromPhp(url, params, this.getUser());
                        System.out.println(response2);
                        JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                        this.notificationPane.setText(myResponse.getMessage());
                        this.notificationPane.setGraphic((Node)myResponse.getIconFromStatus());
                        this.notificationPane.show();
                        if (myResponse.isStatus() && newCustomer) {
                            nb.updateLastUsed(customerNumber);
                            this.customerNo.setText(customerNumber);
                        }
                        this.addCustomer.setDisable(false);
                    }
                    catch (Exception t) {
                        this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                        this.notificationPane.setGraphic((Node)Config.getBanIcon());
                        this.addCustomer.setDisable(false);
                    }
                }
            } else {
                this.addCustomer.setDisable(false);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
        });
    }

    private void clear() {
        this.customerNo.setText(null);
        this.firstName.setText(null);
        this.idNumber.setText(null);
        this.phoneNumber.setText(null);
        this.emailAddress.setText(null);
        this.dateOfBirth.setValue(null);
        this.kraPin.setText(null);
        this.region.setValue(null);
        this.postingGroup.setValue(null);
        this.salesRep.setValue(null);
        this.kinName.setText(null);
        this.kinIdNo.setText(null);
        this.kinPhoneNo.setText(null);
        this.kinRelationship.setValue(null);
        this.property.setValue(null);
        this.floor.setValue(null);
        this.unit.setValue(null);
        this.entryDate.setValue(null);
    }

    private void openFile(File file) {
        boolean newCustomer = false;
        String tCustomerNo = "";
        try {
            tCustomerNo = this.customerNo.getText().trim();
            if (tCustomerNo.length() <= 0) {
                throw new Exception();
            }
            newCustomer = false;
        }
        catch (Exception y) {
            newCustomer = true;
        }
        if (newCustomer) {
            try {
                Image image = new Image(file.toURI().toString());
                this.imagePath = file.getPath();
            }
            catch (Exception image) {}
        } else {
            try {
                Image image = new Image(file.toURI().toString());
                try {
                    Image image2 = new Image(file.toURI().toString());
                    ImageView loader = new ImageView(image2);
                    loader.setFitHeight(30.0);
                    loader.setFitWidth(30.0);
                    this.notificationPane.setGraphic((Node)loader);
                    this.notificationPane.getStyleClass().add((Object)"dark");
                    this.notificationPane.setText("Updating Customer photo. Please wait...");
                    this.notificationPane.show();
                    ByteArrayOutputStream ba = Config.convertFileToJson(file.getPath());
                    String photoJson = StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])ba.toByteArray()));
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("customerNumber", tCustomerNo);
                    params.put("photo", photoJson);
                    Gson g = new Gson();
                    String response2 = Config.loadDataFromPhp("masterupdate?type=customerprofilephoto", params, this.getUser());
                    JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                    if (myResponse.isStatus()) {
                        this.notificationPane.setText(myResponse.getMessage());
                        this.notificationPane.setGraphic((Node)Config.getCheckIcon());
                    } else {
                        this.notificationPane.setText(myResponse.getMessage());
                        this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    }
                    this.addCustomer.setDisable(false);
                }
                catch (Exception t) {
                    t.printStackTrace();
                    this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.addCustomer.setDisable(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

