/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.Config;
import classes.Customer;
import classes.CustomerReceipt;
import classes.CustomerReceiptLines;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.PaymentMethod;
import classes.PaymentTypes;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.GeneralListController;
import java.net.URL;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class CustomerReceiptController
implements Initializable {
    private User user;
    ObservableList<CustomerReceiptLines> myLines = FXCollections.observableArrayList();
    CustomerReceipt receipt;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;
    @FXML
    private Label receiptNumber;
    @FXML
    private DatePicker paymentDate;
    @FXML
    private ComboBox<Customer> myCustomer;
    @FXML
    private Hyperlink customerBalance;
    @FXML
    private Button chooseCustomer;
    @FXML
    private ComboBox<Bank> bank;
    @FXML
    private ComboBox<PaymentMethod> paymentMethod;
    @FXML
    private Hyperlink incomeWithholding;
    @FXML
    private Hyperlink vatWitholding;
    @FXML
    private TextField externalRefNo;
    @FXML
    private ComboBox<PaymentTypes> paymentType;
    @FXML
    private TextField amount;
    @FXML
    private Hyperlink userName;
    @FXML
    private Hyperlink unUppliedAmount;
    @FXML
    private TableView<CustomerReceiptLines> allLines;
    @FXML
    private TableColumn colDate;
    @FXML
    private TableColumn colInvoice;
    @FXML
    private TableColumn colInvoiceAmount;
    @FXML
    private TableColumn colPaidAmount;
    @FXML
    private TableColumn colNewOutstanding;
    @FXML
    private JFXButton deleteReceipt;
    @FXML
    private JFXButton save;
    @FXML
    private JFXButton postReceipt;
    @FXML
    private JFXButton voidReceipt;

    public User getUser() {
        return this.user;
    }

    public void setUser(final User user) {
        this.user = user;
        this.userName.setText(user.getUserName());
        this.loadCustomers();
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    CustomerReceiptController.this.notificationPane.setText("Loading Values, Please wait");
                    CustomerReceiptController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    CustomerReceiptController.this.notificationPane.show();
                });
                ObservableList<Bank> allBanks = Bank.getAllBanks(user);
                ObservableList<PaymentMethod> allPaymentMethods = new PaymentMethod().getAllPaymentMethods(user);
                ObservableList<PaymentTypes> allTypes = new PaymentTypes().getAllPaymentTypes(user);
                Platform.runLater(() -> {
                    CustomerReceiptController.this.paymentType.setItems(allTypes);
                    CustomerReceiptController.this.bank.setItems(allBanks);
                    CustomerReceiptController.this.paymentMethod.setItems(allPaymentMethods);
                    try {
                        CustomerReceiptController.this.paymentType.setValue(CustomerReceiptController.this.paymentType.getItems().get(0));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    CustomerReceiptController.this.notificationPane.hide();
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public CustomerReceipt getReceipt() {
        return this.receipt;
    }

    public void setReceipt(CustomerReceipt receipt) {
        this.receipt = receipt;
        try {
            this.receiptNumber.setText(receipt.getReceiptNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.myCustomer.setValue((Object)receipt.getCustomer());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bank.setValue((Object)receipt.getBank());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.paymentMethod.setValue((Object)receipt.getPaymentMethod());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.externalRefNo.setText(receipt.getExternalRef());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            LocalDate localDate = LocalDate.parse(receipt.getPaymentDate());
            this.paymentDate.setValue((Object)localDate);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.amount.setText(receipt.getAmount() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (receipt.isPosted()) {
            this.deleteReceipt.setDisable(true);
            this.postReceipt.setDisable(true);
            this.voidReceipt.setDisable(false);
            this.save.setDisable(true);
        }
        if (receipt.isReversed()) {
            this.voidReceipt.setDisable(true);
        }
        this.loadCustomerInvoices();
        this.loadReceiptLines();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.voidReceipt.setDisable(true);
        this.paymentDate.setValue((Object)Config.getCurrentLocaldate());
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator(this.myCustomer, Validator.createEmptyValidator((String)"Please select the customer"));
        vs.registerValidator(this.paymentType, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.bank, Validator.createEmptyValidator((String)"Please select the bank"));
        vs.registerValidator(this.paymentMethod, Validator.createEmptyValidator((String)"Please select the payment method"));
        vs.registerValidator((Control)this.paymentDate, Validator.createEmptyValidator((String)"Please select the payment date"));
        vs.registerValidator((Control)this.amount, Validator.createEmptyValidator((String)"Please enter the amount"));
        Callback<TableColumn<CustomerReceiptLines, CustomerReceiptLines>, TableCell<CustomerReceiptLines, CustomerReceiptLines>> confirmCellFactory = new Callback<TableColumn<CustomerReceiptLines, CustomerReceiptLines>, TableCell<CustomerReceiptLines, CustomerReceiptLines>>(){

            public TableCell<CustomerReceiptLines, CustomerReceiptLines> call(TableColumn<CustomerReceiptLines, CustomerReceiptLines> param) {
                TableCell<CustomerReceiptLines, CustomerReceiptLines> cell = new TableCell<CustomerReceiptLines, CustomerReceiptLines>(){
                    private final Hyperlink btn = new Hyperlink("Edit");
                    {
                        this.btn.setOnAction(e -> {
                            CustomerReceiptLines data = (CustomerReceiptLines)this.getTableView().getItems().get(this.getIndex());
                            String quantity = data.getAmountToApply();
                            TextInputDialog alert = new TextInputDialog(quantity);
                            alert.setHeaderText(null);
                            alert.setTitle("Edit Paid Amount");
                            alert.setContentText("Edit Paid Amount");
                            Optional result = alert.showAndWait();
                            result.ifPresent(confirmedAmount -> {
                                try {
                                    double balance = data.getBalanceDouble() + data.getAmountToApplyDouble();
                                    double apply = Double.parseDouble(confirmedAmount.replace(",", ""));
                                    data.setAmountToApply(apply);
                                    data.setBalance(balance - apply);
                                    data.setManualApplication(true);
                                    CustomerReceiptController.this.autoApply();
                                }
                                catch (Exception y) {
                                    CustomerReceiptController.this.notificationPane.setText("Please enter a valid amount");
                                    CustomerReceiptController.this.notificationPane.setGraphic((Node)Config.getBanIcon());
                                    CustomerReceiptController.this.notificationPane.show();
                                }
                            });
                        });
                    }

                    public void updateItem(CustomerReceiptLines item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else {
                            this.btn.setText(item.getAmountToApply());
                            this.setGraphic((Node)this.btn);
                        }
                    }
                };
                return cell;
            }
        };
        this.colInvoice.setCellValueFactory((Callback)new PropertyValueFactory("invoiceNo"));
        this.colDate.setCellValueFactory((Callback)new PropertyValueFactory("invoiceDate"));
        this.colInvoiceAmount.setCellValueFactory((Callback)new PropertyValueFactory("invoiceAmount"));
        this.colNewOutstanding.setCellValueFactory((Callback)new PropertyValueFactory("balance"));
        this.colPaidAmount.setCellFactory((Callback)confirmCellFactory);
        this.colPaidAmount.setCellValueFactory(features -> new ReadOnlyObjectWrapper(features.getValue()));
        this.amount.textProperty().addListener((observable, oldValue, newValue) -> this.autoApply());
        this.paymentType.setOnAction(e -> this.autoApply());
        this.voidReceipt.setOnAction(e -> {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.setTitle("Void Receipt");
            alert.setHeaderText("Voiding the receipt results in a change in financial position");
            alert.setContentText("Please select a reason for voiding the receipt");
            ButtonType buttonTypeOne = new ButtonType("Wrong Entry");
            ButtonType buttonTypeTwo = new ButtonType("Bounced Cheque");
            alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeOne, buttonTypeTwo, new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE)});
            Optional result = alert.showAndWait();
            if (result.get() == buttonTypeOne) {
                this.voidReceipt(0);
            } else if (result.get() == buttonTypeTwo) {
                this.voidReceipt(1);
            }
        });
        this.myCustomer.setOnAction(e -> {
            this.customerBalance.setText("Bal: " + ((Customer)this.myCustomer.getValue()).getBalanceString());
            this.loadCustomerInvoices();
        });
        this.customerBalance.setOnAction(e -> new Config().loadCustomerPNLFilter("customerstatement", new Gson().toJson(this.myCustomer.getValue()), "Customer Statement", this.user));
        this.chooseCustomer.setOnAction(e -> {
            try {
                Gson gson = new Gson();
                String response = new Config().getObjectFromSelection("customer", gson.toJson((Object)this.myCustomer.getItems()), this.getUser());
                this.myCustomer.setValue(gson.fromJson(response, Customer.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.save.setOnAction(e -> this.save());
        this.deleteReceipt.setOnAction(e -> {
            String rNumber = this.receiptNumber.getText().trim();
            if (!rNumber.equals(null) && !rNumber.equals("")) {
                JsonResponses jr = new CustomerReceipt().deleteReceipt(this.receiptNumber.getText().trim(), this.getUser());
                if (jr.isStatus()) {
                    Stage stage = (Stage)this.deleteReceipt.getScene().getWindow();
                    stage.close();
                } else {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            } else {
                Stage stage = (Stage)this.deleteReceipt.getScene().getWindow();
                stage.close();
            }
        });
        this.postReceipt.setOnAction(e -> {
            block6: {
                if (this.save()) {
                    try {
                        String tReceiptNo = this.receiptNumber.getText().trim();
                        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                        alert.setTitle("Confirm Post");
                        alert.setHeaderText("Posting the customer receipt results in a change in the financial position. ");
                        alert.setContentText("Are you sure you want to post customer receipt number " + tReceiptNo + "?");
                        Optional result = alert.showAndWait();
                        if (result.get() != ButtonType.OK) break block6;
                        try {
                            JsonResponses jr = new CustomerReceipt().postReceipt(tReceiptNo, this.getUser());
                            if (jr.isStatus()) {
                                GeneralListController.publicNotificationPane.setText(jr.getMessage());
                                GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                                GeneralListController.publicNotificationPane.show();
                                Stage stage = (Stage)this.postReceipt.getScene().getWindow();
                                stage.close();
                                break block6;
                            }
                            this.notificationPane.setText(jr.getMessage());
                            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                            this.notificationPane.show();
                        }
                        catch (Exception t) {
                            this.notificationPane.setText("We encountered an error while posting the customer invoice. Please try again later");
                            this.notificationPane.setGraphic((Node)Config.getBanIcon());
                            this.notificationPane.show();
                            t.printStackTrace();
                        }
                    }
                    catch (Exception r) {
                        this.notificationPane.setText("We encountered an error while posting the customer invoice. Please try again later");
                        this.notificationPane.setGraphic((Node)Config.getBanIcon());
                        this.notificationPane.show();
                    }
                }
            }
        });
        this.amount.addEventFilter(KeyEvent.KEY_TYPED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (!event.getCharacter().matches("[0123456789.]")) {
                    event.consume();
                }
            }
        });
    }

    private void voidReceipt(int bouncedCheque) {
        String tReceiptNo = this.receiptNumber.getText().trim();
        JsonResponses jr = new CustomerReceipt().voidReceipt(tReceiptNo, this.getUser(), bouncedCheque);
        if (jr.isStatus()) {
            GeneralListController.publicNotificationPane.setText(jr.getMessage());
            GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
            GeneralListController.publicNotificationPane.show();
            Stage stage = (Stage)this.postReceipt.getScene().getWindow();
            stage.close();
        } else {
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
        }
    }

    public boolean save() {
        boolean error = false;
        String message = "";
        String tReceiptNo = "";
        NumberSeries nb = new NumberSeries(8, this.getUser());
        try {
            tReceiptNo = this.receiptNumber.getText().trim();
        }
        catch (Exception e) {
            tReceiptNo = "";
        }
        boolean newReceipt = false;
        if (tReceiptNo.equals("")) {
            tReceiptNo = nb.getNextNumber();
            newReceipt = true;
        }
        String tCustomer = "";
        try {
            tCustomer = ((Customer)this.myCustomer.getValue()).getCustomerNumber();
            if (tCustomer.equals(null) || tCustomer.trim().equals("")) {
                tCustomer = "";
            }
        }
        catch (Exception p) {
            tCustomer = "";
        }
        int tBank = 0;
        try {
            tBank = ((Bank)this.bank.getValue()).getCode();
        }
        catch (Exception e) {
            tBank = 0;
        }
        int tPaymentMethod = 0;
        try {
            tPaymentMethod = ((PaymentMethod)this.paymentMethod.getValue()).getCode();
        }
        catch (Exception e) {
            tPaymentMethod = 0;
        }
        String tPaymentRef = this.externalRefNo.getText().trim();
        String tPaymentDate = "";
        try {
            tPaymentDate = ((LocalDate)this.paymentDate.getValue()).toString();
        }
        catch (Exception r) {
            tPaymentDate = "";
        }
        double tAmount = 0.0;
        try {
            tAmount = Double.parseDouble(this.amount.getText().trim());
        }
        catch (Exception y) {
            tAmount = 0.0;
            error = true;
            message = "Please enter a valid amount";
        }
        int tPaymentType = 0;
        try {
            tPaymentType = ((PaymentTypes)this.paymentType.getValue()).getId();
            if (tPaymentType < 1) {
                throw new Exception();
            }
        }
        catch (Exception y) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the withholding tax";
        }
        if (error) {
            this.notificationPane.setText(message);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
            return false;
        }
        try {
            Gson gson = new Gson();
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("receiptNo", tReceiptNo);
            params.put("customerNo", tCustomer);
            params.put("bankCode", tBank);
            params.put("paymentMethod", tPaymentMethod);
            params.put("paymentRef", tPaymentRef);
            params.put("paymentDate", tPaymentDate);
            params.put("amount", tAmount);
            params.put("paymentType", tPaymentType);
            params.put("withholdingVAT", this.vatWitholding.getText().replace(",", ""));
            params.put("withholdingIncome", this.incomeWithholding.getText().replace(",", ""));
            params.put("lines", gson.toJson((Object)this.allLines.getItems()));
            String response = Config.loadDataFromPhp("mastercreate?type=customerreceipt", params, this.getUser());
            System.out.println(response);
            JsonResponses jr = (JsonResponses)gson.fromJson(response, JsonResponses.class);
            if (newReceipt) {
                nb.updateLastUsed(tReceiptNo);
                this.receiptNumber.setText(jr.getOverLoad1());
            }
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
            return jr.isStatus();
        }
        catch (Exception e) {
            this.notificationPane.setText("We encountered an error while saving the receipt. Please try again");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
            return false;
        }
    }

    public void loadCustomerInvoices() {
        try {
            String customerNo = ((Customer)this.myCustomer.getValue()).getCustomerNumber();
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("customerNo", customerNo);
            String response = Config.loadDataFromPhp("masterfetch?type=outstanding_invoices", params, this.getUser());
            System.out.println("Response" + response);
            ObservableList lines = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, CustomerReceiptLines[].class)));
            this.myLines = FXCollections.observableArrayList((Collection)lines.stream().filter(v -> v.getBalanceDouble() > 0.0).collect(Collectors.toList()));
            this.allLines.setItems(this.myLines);
            this.autoApply();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadReceiptLines() {
        this.allLines.setItems(new CustomerReceiptLines().getLines(this.receiptNumber.getText().trim(), this.getUser()));
    }

    public void autoApply() {
        try {
            double paidAmount = 0.0;
            try {
                paidAmount = Double.parseDouble(this.amount.getText().trim());
                try {
                    PaymentTypes selectedType = (PaymentTypes)this.paymentType.getValue();
                    int taxRate = 16;
                    if (selectedType.getWithholdingVatPercentage() > 0.0) {
                        paidAmount = paidAmount * (double)(100 + taxRate) / (100.0 + ((double)taxRate - selectedType.getWithholdingVatPercentage()));
                    }
                    double whtIncome = selectedType.getWithholdingTaxPercentage() * paidAmount / 100.0;
                    double whtVAT = selectedType.getWithholdingVatPercentage() * (paidAmount / (double)(100 + taxRate));
                    this.incomeWithholding.setText(Config.formatNumber(whtIncome));
                    this.vatWitholding.setText(Config.formatNumber(whtVAT));
                }
                catch (Exception selectedType) {}
            }
            catch (Exception selectedType) {
                // empty catch block
            }
            ObservableList returnedLines = FXCollections.observableArrayList();
            double mBalance = paidAmount;
            for (CustomerReceiptLines currentLine : this.myLines) {
                double amountToApply = 0.0;
                double tBalance = currentLine.getBalanceDouble() + currentLine.getAmountToApplyDouble();
                amountToApply = !currentLine.isManualApplication() ? ((amountToApply = Math.min(tBalance, mBalance)) < 0.0 ? 0.0 : amountToApply) : currentLine.getAmountToApplyDouble();
                mBalance -= amountToApply;
                currentLine.setAmountToApply(amountToApply);
                currentLine.setBalance(tBalance - amountToApply);
                returnedLines.add((Object)currentLine);
            }
            this.unUppliedAmount.setText(Config.formatNumber(mBalance));
            if (mBalance > 0.0) {
                CustomerReceiptLines entry = new CustomerReceiptLines();
                entry.setInvoiceDate(Config.localDateToString((LocalDate)this.paymentDate.getValue()));
                entry.setInvoiceNo("Advance Payment");
                entry.setInvoiceAmount(0.0);
                entry.setAmountToApply(mBalance);
                returnedLines.add((Object)entry);
            }
            this.allLines.setItems(returnedLines);
            this.allLines.refresh();
        }
        catch (Exception u) {
            u.printStackTrace();
        }
    }

    private void loadCustomers() {
        final Node original = this.chooseCustomer.getGraphic();
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> CustomerReceiptController.this.chooseCustomer.setGraphic((Node)Config.getLoader()));
                ObservableList<Customer> allCustomers = new Customer().getAllCustomers(CustomerReceiptController.this.user);
                allCustomers.sort(Comparator.comparing(Customer::getCustomerName));
                Platform.runLater(() -> {
                    CustomerReceiptController.this.myCustomer.setItems(allCustomers);
                    CustomerReceiptController.this.chooseCustomer.setGraphic(original);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }
}

