/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.DashboardData;
import classes.User;
import com.jfoenix.controls.JFXButton;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import org.controlsfx.control.MaskerPane;

public class DashboardController
implements Initializable {
    private User user;
    @FXML
    private VBox root;
    @FXML
    private JFXButton totalEmployees;
    @FXML
    private Label totalEmployeesLabel;
    @FXML
    private JFXButton totalLeave;
    @FXML
    private Label totalLeaveLabel;
    @FXML
    private JFXButton loansTotal;
    @FXML
    private Label totalLoanLabel;
    @FXML
    private JFXButton advancesTotal;
    @FXML
    private Label totalAdvancesLabel;
    @FXML
    private MaskerPane maskerPane;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.loadDashboardData(user);
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    public void loadDashboardData(final User user) {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> DashboardController.this.maskerPane.setVisible(true));
                Platform.runLater(() -> {
                    DashboardData data = new DashboardData().getDashboardData(user);
                    try {
                        DashboardController.this.totalEmployeesLabel.setText(Config.formatNumber(data.getTotalEmployees()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        DashboardController.this.totalLeaveLabel.setText(Config.formatNumber(data.getTotalLeave()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        DashboardController.this.totalLoanLabel.setText(Config.formatNumber(data.getTotalLoans()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        DashboardController.this.totalAdvancesLabel.setText(Config.formatNumber(data.getTotalAdvances()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                Platform.runLater(() -> DashboardController.this.maskerPane.setVisible(false));
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
        Thread thread1 = new Thread((Runnable)task1);
        thread1.setDaemon(true);
        thread1.start();
    }
}

