/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.Department;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;

public class DepartmentController
implements Initializable {
    private User user;
    @FXML
    private HBox holder;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private Label code;
    @FXML
    private TextField name;
    @FXML
    private Button save;
    private Department department;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
        this.code.setText(department.getCode() + "");
        this.name.setText(department.getDepartmentName());
    }

    public void initialize(URL location, ResourceBundle resources) {
        new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        this.save.setOnAction(e -> {
            boolean error = false;
            int tCode = 0;
            String tName = "";
            String message = "";
            try {
                try {
                    tCode = Integer.valueOf(this.code.getText().trim());
                }
                catch (Exception x) {
                    tCode = 0;
                }
                try {
                    tName = this.name.getText().trim();
                    if (tName.length() < 4) {
                        throw new Exception();
                    }
                }
                catch (Exception n) {
                    error = true;
                    message = "Please enter a valid name at least 4 characters";
                }
                if (error) {
                    this.notificationPane.setText(message);
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                } else {
                    String url = "mastercreate";
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    if (tCode > 0) {
                        url = "masterupdate";
                        params.put("code", tCode);
                    }
                    params.put("departmentName", tName);
                    String response = Config.loadDataFromPhp(url + "?type=departments", params, this.getUser());
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        GeneralListController.publicNotificationPane.setText(jr.getMessage());
                        GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                        GeneralListController.publicNotificationPane.show();
                        ((Stage)this.save.getScene().getWindow()).close();
                    } else {
                        this.notificationPane.setText(jr.getMessage());
                        this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                        this.notificationPane.show();
                    }
                }
            }
            catch (Exception y) {
                this.notificationPane.setText("We encountered an error while processing your request");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
    }
}

