/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.Department;
import classes.Employee;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class DepartmentsController
implements Initializable {
    private User user;
    @FXML
    Label departmentLabel;
    @FXML
    private JFXButton addDepartment;
    @FXML
    NotificationPane notificationPane;
    @FXML
    StackPane holder;
    @FXML
    private JFXButton delete;
    @FXML
    private JFXButton refresh;
    @FXML
    private JFXButton allDepartmentsReport;
    @FXML
    private TableView<Department> allDepartments;
    @FXML
    private TableColumn departmentCode;
    @FXML
    private TableColumn departmentName;
    @FXML
    private TableColumn hod;
    @FXML
    private MaskerPane masker1;
    @FXML
    private TableView<Employee> employeesInDepartment;
    @FXML
    private TableColumn employeeNo;
    @FXML
    private TableColumn employeeName;
    @FXML
    private TableColumn employeePhone;
    @FXML
    private MaskerPane masker2;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.loadDepartments();
        this.loadEmployeesInDepartment();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane.setContent((Node)this.holder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.addDepartment.setOnAction(e -> {
            TextInputDialog alert = new TextInputDialog("Department Name");
            alert.setHeaderText(null);
            alert.setTitle("Add Department");
            alert.setContentText("Add a New Department");
            Optional result = alert.showAndWait();
            result.ifPresent(name -> this.addDepartment((String)name));
        });
        this.departmentCode.setCellValueFactory((Callback)new PropertyValueFactory("code"));
        this.departmentName.setCellValueFactory((Callback)new PropertyValueFactory("departmentName"));
        this.hod.setCellValueFactory((Callback)new PropertyValueFactory("hod"));
        this.employeeNo.setCellValueFactory((Callback)new PropertyValueFactory("employeeNumber"));
        this.employeeName.setCellValueFactory((Callback)new PropertyValueFactory("fullName"));
        this.employeePhone.setCellValueFactory((Callback)new PropertyValueFactory("phoneNumber"));
        this.allDepartments.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            if (newSelection != null) {
                this.loadEmployeesInDepartment();
            }
        });
        this.refresh.setOnAction(e -> this.loadDepartments());
    }

    public void loadDepartments() {
        this.masker1.setVisible(true);
        this.allDepartments.setItems(new Department().getAllDepartments(this.getUser()));
        this.masker1.setVisible(false);
    }

    public void addDepartment(String t) {
        this.notificationPane.setText("Adding Department. Please wait....");
        this.notificationPane.setGraphic((Node)new ProgressIndicator());
        this.notificationPane.show();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("departmentName", t);
            String response = Config.loadDataFromPhp("mastercreate?type=department", params, this.getUser());
            Gson g = new Gson();
            JsonResponses js = (JsonResponses)g.fromJson(response, JsonResponses.class);
            if (js.isStatus()) {
                this.loadDepartments();
                this.notificationPane.setText(js.getMessage());
                this.notificationPane.setGraphic((Node)Config.getCheckIcon());
                this.notificationPane.show();
            } else {
                this.notificationPane.setText(js.getMessage());
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
        }
        catch (Exception u) {
            this.notificationPane.setText("We experienced an error while adding the department. Please try again later. ");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
    }

    public void loadEmployeesInDepartment() {
        Platform.runLater(() -> {
            this.masker2.setVisible(true);
            LinkedHashMap<String, Object> filters = new LinkedHashMap<String, Object>();
            Department department = new Department();
            try {
                department = (Department)this.allDepartments.getSelectionModel().getSelectedItem();
                department.getCode();
            }
            catch (Exception y) {
                try {
                    department = (Department)this.allDepartments.getItems().get(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                filters.put("department", department.getCode());
                this.departmentLabel.setText("Employees In The " + department.getDepartmentName() + " Department");
                this.employeesInDepartment.setItems(new Employee().getAllEmployees(filters, this.getUser()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.masker2.setVisible(false);
        });
    }
}

