/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Account;
import classes.Bank;
import classes.Config;
import classes.DirectIncome;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class DirectIncomeController
implements Initializable {
    private User user;
    private DirectIncome income;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox notificationHolder;
    @FXML
    private Label voucherNo;
    @FXML
    private DatePicker incomeDate;
    @FXML
    private TextField description;
    @FXML
    private ComboBox<Account> glAccount;
    @FXML
    private ComboBox<Bank> bank;
    @FXML
    private TextField amount;
    @FXML
    private TextField externalDocNumber;
    @FXML
    private Button cancel;
    @FXML
    private Button save;
    @FXML
    private Button post;
    @FXML
    private Button reverse;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public DirectIncome getIncome() {
        return this.income;
    }

    public void setIncome(DirectIncome income) {
        this.income = income;
        try {
            this.voucherNo.setText(income.getVoucherNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.incomeDate.setValue((Object)Config.stringToLocalDate(income.getVoucherDate()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.description.setText(income.getDescription());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.glAccount.setValue((Object)income.getGlAccount());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bank.setValue((Object)income.getBank());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.amount.setText(income.getAmount() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (income.isPosted()) {
            this.reverse.setDisable(false);
            this.incomeDate.setDisable(false);
            this.description.setDisable(false);
            this.glAccount.setDisable(false);
            this.bank.setDisable(false);
            this.amount.setDisable(false);
            this.save.setDisable(false);
            this.post.setDisable(false);
        }
        if (income.isReversed()) {
            this.reverse.setDisable(true);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.notificationHolder);
        this.incomeDate.setValue((Object)Config.getCurrentLocaldate());
        Platform.runLater(() -> this.glAccount.setItems(Account.getAccounts(this.getUser())));
        Platform.runLater(() -> this.bank.setItems(Bank.getAllBanks(this.getUser())));
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.incomeDate, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.description, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.glAccount, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.bank, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.amount, Validator.createEmptyValidator((String)"Required"));
        this.amount = new Config().setDoubleTextField(this.amount);
        this.save.setOnAction(e -> this.save());
        this.post.setOnAction(e -> {
            if (this.save() && this.post()) {
                GeneralListController.publicNotificationPane.setText(this.notificationPane.getText());
                GeneralListController.publicNotificationPane.setGraphic(this.notificationPane.getGraphic());
                GeneralListController.publicNotificationPane.show();
                Stage stage = (Stage)this.post.getScene().getWindow();
                stage.close();
            }
        });
        this.reverse.setOnAction(e -> {
            if (this.reverse()) {
                GeneralListController.publicNotificationPane.setText(this.notificationPane.getText());
                GeneralListController.publicNotificationPane.setGraphic(this.notificationPane.getGraphic());
                GeneralListController.publicNotificationPane.show();
                Stage stage = (Stage)this.post.getScene().getWindow();
                stage.close();
            }
        });
    }

    public boolean save() {
        String tVoucherNo = "";
        String tIncomeDate = "";
        String tDescription = "";
        String tGLAccount = "";
        String tExternalDocNumber = "";
        int bankCode = 0;
        double tAmount = 0.0;
        boolean error = false;
        boolean newVoucher = false;
        String message = "";
        NumberSeries ns = new NumberSeries(34, this.getUser());
        try {
            tVoucherNo = this.voucherNo.getText().trim();
            if (tVoucherNo.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception y) {
            tVoucherNo = ns.getNextNumber();
            newVoucher = true;
        }
        try {
            tIncomeDate = Config.localDateToString((LocalDate)this.incomeDate.getValue());
        }
        catch (Exception y) {
            error = true;
            message = "Please select a valid date";
        }
        try {
            tDescription = this.description.getText().trim();
            if (tDescription.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception r) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter the income description";
        }
        try {
            tGLAccount = ((Account)this.glAccount.getValue()).getAccountNumber();
            if (tGLAccount.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception y) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the income G/L Account";
        }
        try {
            bankCode = ((Bank)this.bank.getValue()).getCode();
        }
        catch (Exception y) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the bank receiving the income";
        }
        try {
            tAmount = Double.parseDouble(this.amount.getText().trim());
        }
        catch (Exception y) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter a valid amount for income";
        }
        try {
            tExternalDocNumber = this.externalDocNumber.getText().trim();
        }
        catch (Exception u) {
            tExternalDocNumber = "";
        }
        if (error) {
            this.notificationPane.setText(message);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        } else {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("voucherNo", tVoucherNo);
                params.put("incomeDate", tIncomeDate);
                params.put("description", tDescription);
                params.put("gLAccount", tGLAccount);
                params.put("bankCode", bankCode);
                params.put("amount", tAmount);
                params.put("externalDocNumber", tExternalDocNumber);
                String response = Config.loadDataFromPhp("mastercreate?type=directincome", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                if (jr.isStatus() && newVoucher) {
                    ns.updateLastUsed(tVoucherNo);
                    this.voucherNo.setText(tVoucherNo);
                }
                return jr.isStatus();
            }
            catch (Exception y) {
                this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
        return false;
    }

    public boolean post() {
        try {
            String tVoucherNo = this.voucherNo.getText().trim();
            if (tVoucherNo.length() > 0) {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("voucherNo", tVoucherNo);
                String response = Config.loadDataFromPhp("masterpost?type=directincome", params, this.getUser());
                System.out.println(response);
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                return jr.isStatus();
            }
            this.notificationPane.setText("The income voucher has not been created");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
        catch (Exception y) {
            this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
            y.printStackTrace();
        }
        return false;
    }

    public boolean reverse() {
        try {
            String tVoucherNo = this.voucherNo.getText().trim();
            if (tVoucherNo.length() > 0) {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("voucherNo", tVoucherNo);
                String response = Config.loadDataFromPhp("masterpost?type=reversedirectincome", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                return jr.isStatus();
            }
            this.notificationPane.setText("The income voucher has not been created");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
        catch (Exception y) {
            this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
        return false;
    }
}

