/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.DriverConductor;
import classes.JsonResponses;
import classes.Member;
import classes.NumberSeries;
import classes.User;
import classes.Vehicle;
import com.google.gson.Gson;
import controllers.BadgeApplicationController;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class DriverConductorController
implements Initializable {
    private User user;
    private DriverConductor driverConductor;
    @FXML
    private TextField nhifNumber;
    @FXML
    private TextField nssfNumber;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private HBox notificationHolder;
    @FXML
    private Label employeeNo;
    @FXML
    private TextField employeeName;
    @FXML
    private TextField employeeId;
    @FXML
    private TextField employeePhone;
    @FXML
    private TextField employeeEmail;
    @FXML
    private ComboBox<String> position;
    @FXML
    private TextField licenseNo;
    @FXML
    private ComboBox<Member> employer;
    @FXML
    private Button chooseEmployer;
    @FXML
    private ComboBox<Vehicle> vehicle;
    @FXML
    private DatePicker issuedOn;
    @FXML
    private ImageView employeePhoto;
    @FXML
    private CheckBox badgeReceived;
    @FXML
    private CheckBox badgeIssued;
    @FXML
    private DatePicker expiryDate;
    @FXML
    private Button cancel;
    @FXML
    private Button save;
    @FXML
    private Button apply;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public DriverConductor getDriverConductor() {
        return this.driverConductor;
    }

    public void setDriverConductor(DriverConductor driverConductor) {
        this.driverConductor = driverConductor;
        try {
            this.employeeNo.setText(driverConductor.getEmployeeNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.employeeName.setText(driverConductor.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.employeeId.setText(driverConductor.getIdNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.employeePhone.setText(driverConductor.getPhoneNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.employeeEmail.setText(driverConductor.getEmail());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.position.setValue((Object)driverConductor.getPosition());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.licenseNo.setText(driverConductor.getLicenseNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.employer.setValue((Object)driverConductor.getEmployer());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.vehicle.setValue((Object)driverConductor.getVehicle());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.issuedOn.setValue((Object)Config.stringToLocalDate(driverConductor.getIssuedOn()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.badgeReceived.setSelected(driverConductor.isBadgeReceived());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.badgeIssued.setSelected(driverConductor.isBadgeIssued());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.expiryDate.setValue((Object)Config.stringToLocalDate(driverConductor.getExpiry()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.nhifNumber.setText(driverConductor.getNhifNumber());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.nssfNumber.setText(driverConductor.getNssfNumber());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.issuedOn.setValue((Object)Config.getCurrentLocaldate());
        LocalDate issuedSelected = (LocalDate)this.issuedOn.getValue();
        this.expiryDate.setValue((Object)issuedSelected.plusYears(1L));
        this.issuedOn.setOnAction(e -> {
            LocalDate issuedSelected1 = (LocalDate)this.issuedOn.getValue();
            this.expiryDate.setValue((Object)issuedSelected1.plusYears(1L));
        });
        this.badgeIssued.setDisable(true);
        this.badgeReceived.setDisable(true);
        this.employer.setItems(new Member().getAllMembers(this.getUser()));
        ObservableList allPositions = FXCollections.observableArrayList();
        allPositions.add((Object)"Driver");
        allPositions.add((Object)"Conductor");
        this.position.setItems(allPositions);
        this.employer.setOnAction(e -> {
            String memberNo = ((Member)this.employer.getValue()).getMemberNumber();
            ObservableList<Vehicle> myVehicles = new Vehicle().getMemberVehicles(memberNo, this.getUser());
            this.vehicle.setItems(myVehicles);
        });
        this.chooseEmployer.setOnAction(e -> {
            try {
                Member m = new Member().getMemberFromSelection(this.getUser());
                String memberNo = m.getMemberNumber();
                this.employer.setValue((Object)m);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        this.save.setOnAction(e -> this.save());
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
        this.apply.setOnAction(e -> {
            if (this.save()) {
                try {
                    FXMLLoader loader = new FXMLLoader();
                    VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/badgeapplication.fxml").openStream());
                    Scene scene = new Scene((Parent)itemPane, 902.0, 494.0);
                    final Stage stage = new Stage();
                    scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                        public void handle(KeyEvent t) {
                            KeyCode key = t.getCode();
                            if (key == KeyCode.ESCAPE) {
                                stage.close();
                            }
                        }
                    });
                    stage.setScene(scene);
                    BadgeApplicationController controller = (BadgeApplicationController)loader.getController();
                    String tApplicationNo = this.employeeNo.getText().trim();
                    DriverConductor employee = new DriverConductor(tApplicationNo, this.getUser());
                    controller.setDriverConductor(employee);
                    stage.setTitle("New Badge Application");
                    stage.setResizable(false);
                    try {
                        stage.initModality(Modality.APPLICATION_MODAL);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    stage.showAndWait();
                    Stage stage2 = (Stage)this.apply.getScene().getWindow();
                    stage2.close();
                }
                catch (Exception p) {
                    p.printStackTrace();
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setTitle("An error occurred");
                    alert.setHeaderText("An error occurred while loading your badge application exit screen. Please contact support");
                    alert.showAndWait();
                }
            }
        });
        this.notificationPane.setContent((Node)this.notificationHolder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.notificationPane.getStyleClass().add((Object)"dark");
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.employeeName, Validator.createEmptyValidator((String)"Employee Name is required"));
        vs.registerValidator((Control)this.employeeId, Validator.createEmptyValidator((String)"Employee Id No is required"));
        vs.registerValidator((Control)this.employeePhone, Validator.createEmptyValidator((String)"Employee Phone No is required"));
        vs.registerValidator(this.position, Validator.createEmptyValidator((String)"Employee Position is required"));
        vs.registerValidator(this.employer, Validator.createEmptyValidator((String)"Employer is required"));
        vs.registerValidator(this.vehicle, Validator.createEmptyValidator((String)"Vehicle is required"));
    }

    public boolean save() {
        String tEmployeeNo = "";
        String tEmployeeName = "";
        String tEmployeeId = "";
        String tEmployeePhone = "";
        String tEmployeeEmail = this.employeeEmail.getText().trim();
        String tEmployeePosition = "";
        String tEmployeeLicenseNo = this.licenseNo.getText().trim();
        String tEmployeeEmployer = "";
        String tEmployeeVehicle = "";
        String tEmployeeIssuedOn = "";
        String tEmployeeExpiry = "";
        String tEmployeePhoto = "";
        String tNhifNumber = "";
        String tNssfNumber = "";
        boolean tBadgeReceived = this.badgeReceived.isSelected();
        boolean tBadgeIssued = this.badgeIssued.isSelected();
        boolean error = false;
        boolean newEmployee = false;
        String message = "";
        NumberSeries ns = new NumberSeries(19, this.getUser());
        try {
            tEmployeeNo = this.employeeNo.getText().trim();
            if (tEmployeeNo.equals(null) || tEmployeeNo.equals("") || tEmployeeNo.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            tEmployeeNo = ns.getNextNumber();
            newEmployee = true;
        }
        try {
            tEmployeeIssuedOn = Config.localDateToString((LocalDate)this.issuedOn.getValue());
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select a valid date of issue";
        }
        try {
            tEmployeeExpiry = Config.localDateToString((LocalDate)this.expiryDate.getValue());
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select a valid date of expiry";
        }
        try {
            tEmployeeName = this.employeeName.getText().trim();
            if (tEmployeeName.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter a valid employee name";
        }
        try {
            tEmployeeId = this.employeeId.getText().trim();
            if (tEmployeeId.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter a valid employee Id Number";
        }
        try {
            tEmployeePhone = this.employeePhone.getText().trim();
            if (tEmployeePhone.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter a valid employee Phone Number";
        }
        try {
            tEmployeePosition = (String)this.position.getValue();
            if (tEmployeePosition.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the position the employee will be serving";
        }
        try {
            tEmployeeEmployer = ((Member)this.employer.getValue()).getMemberNumber();
            if (tEmployeeEmployer.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the person's employer";
        }
        try {
            tEmployeeVehicle = ((Vehicle)this.vehicle.getValue()).getRegNo();
            if (tEmployeeVehicle.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the vehicle ";
        }
        try {
            tNhifNumber = this.nhifNumber.getText().trim();
        }
        catch (Exception t) {
            // empty catch block
        }
        try {
            tNssfNumber = this.nssfNumber.getText().trim();
        }
        catch (Exception t) {
            // empty catch block
        }
        if (!error) {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("employeeNo", tEmployeeNo);
                params.put("employeeName", tEmployeeName);
                params.put("employeeId", tEmployeeId);
                params.put("employeePhone", tEmployeePhone);
                params.put("employeeEmail", tEmployeeEmail);
                params.put("employeePosition", tEmployeePosition);
                params.put("licenseNo", tEmployeeLicenseNo);
                params.put("employer", tEmployeeEmployer);
                params.put("vehicle", tEmployeeVehicle);
                params.put("issuedOn", tEmployeeIssuedOn);
                params.put("expiryDate", tEmployeeExpiry);
                params.put("photo", tEmployeePhoto);
                params.put("badgeReceived", tBadgeReceived ? 1 : 0);
                params.put("badgeIssued", tBadgeIssued ? 1 : 0);
                params.put("nhifNumber", tNhifNumber);
                params.put("nssfNumber", tNssfNumber);
                String response = Config.loadDataFromPhp("mastercreate?type=driverconductor", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                if (jr.isStatus()) {
                    if (newEmployee) {
                        this.employeeNo.setText(tEmployeeNo);
                        ns.updateLastUsed(tEmployeeNo);
                    }
                    return true;
                }
            }
            catch (Exception t) {
                this.notificationPane.setText("We experienced an error while processing your request");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        } else {
            this.notificationPane.setText(message);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        }
        return false;
    }
}

