/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.Capital;
import classes.User;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import java.net.URL;
import java.time.LocalDate;
import java.util.Collection;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.control.textfield.TextFields;

public class EditCapitalController
implements Initializable {
    private User user;
    @FXML
    private AnchorPane root;
    @FXML
    private AnchorPane holder;
    @FXML
    private JFXComboBox<Bank> editBankName;
    @FXML
    private JFXComboBox editInvestment;
    @FXML
    private TextField editAmount;
    @FXML
    private DatePicker editInvestmentDatePicker;
    @FXML
    private JFXButton editPost;
    @FXML
    private JFXButton editReset;
    @FXML
    private NotificationPane notificationPane;
    private Capital capital;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Capital getCapital() {
        return this.capital;
    }

    public void setCapital(Capital iCapital) {
        this.capital = iCapital;
        this.editBankName.setItems(Bank.getAllBanks(this.getUser()));
        this.editBankName.setEditable(true);
        TextFields.bindAutoCompletion((TextField)this.editBankName.getEditor(), (Collection)this.editBankName.getItems());
        String date = iCapital.getInvestmentDate();
        LocalDate localDate = LocalDate.parse(date);
        this.editInvestmentDatePicker.setValue((Object)localDate);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.editInvestment.getItems().removeAll((Collection)this.editInvestment.getItems());
        this.editInvestment.getItems().addAll(new Object[]{"Direct equity", "Equity mutual funds", "Debt mutual funds", "Real estate", "Bank fixed deposit", "Gold", "NIC Bank", "National Pension System", "Public provident fund", "Saving scheme", "Taxable bonds", "Stocks and Shares", "Bonds"});
        this.editInvestment.getSelectionModel().select((Object)"Direct equity");
    }
}

