/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Account;
import classes.ChartOfAccountCategories;
import classes.ChartOfAccountTypes;
import classes.ChartOfAccountsGroups;
import classes.ChartOfAccountsSubCategories;
import classes.Config;
import classes.Currency;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import controllers.ChartOfAccountsController;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class EditGLAccount
implements Initializable {
    private User user;
    public Account glAccount;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox notificationPaneHolder;
    @FXML
    private TextField accountNumber;
    @FXML
    private ComboBox<ChartOfAccountTypes> accountType;
    @FXML
    private ComboBox<ChartOfAccountCategories> accountCategory;
    @FXML
    private ComboBox<ChartOfAccountsSubCategories> accountSubCategory;
    @FXML
    private ComboBox<ChartOfAccountsGroups> accountGroup;
    @FXML
    private TextField accountName;
    @FXML
    private ComboBox<Currency> accountCurrency;
    @FXML
    private Button addAccount;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Account getGlAccount() {
        return this.glAccount;
    }

    public void setGlAccount(Account glAccount) {
        this.glAccount = glAccount;
        this.accountName.setText(glAccount.getAccountName());
        this.accountNumber.setText(glAccount.getAccountNumber());
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.accountNumber.setEditable(false);
        this.accountNumber.setDisable(true);
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.notificationPaneHolder);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.accountNumber, Validator.createEmptyValidator((String)"required"));
        vs.registerValidator((Control)this.accountName, Validator.createEmptyValidator((String)"required"));
        this.addAccount.setOnAction(e -> {
            try {
                this.notificationPane.hide();
                String myAccountNumber = this.accountNumber.getText().trim();
                String myAccountName = this.accountName.getText().trim();
                Boolean error = false;
                String message = "";
                if (myAccountNumber.equals("") || myAccountNumber.equals(null)) {
                    error = true;
                    message = "Please indicate the account number.";
                }
                if (myAccountName.equals("") || myAccountName.equals(null)) {
                    error = true;
                    message = message + (message.length() < 1 ? "\n" : "");
                    message = message + "Please indicate the account name";
                }
                if (!error.booleanValue()) {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("accountNumber", myAccountNumber);
                    params.put("accountName", myAccountName);
                    String response = Config.loadDataFromPhp("masterupdate?type=glaccount", params, this.getUser());
                    Gson g = new Gson();
                    JsonResponses response2 = (JsonResponses)g.fromJson(response, JsonResponses.class);
                    if (response2.isStatus()) {
                        ChartOfAccountsController.publicNotificationPane.setGraphic((Node)Config.getCheckIcon());
                        ChartOfAccountsController.publicNotificationPane.setText(response2.getMessage());
                        ChartOfAccountsController.publicNotificationPane.show();
                        this.accountName.setText("");
                        this.accountNumber.setText("");
                        Stage stage = (Stage)this.addAccount.getScene().getWindow();
                        stage.close();
                    } else {
                        this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                        this.notificationPane.setText(response2.getMessage());
                        this.notificationPane.show();
                    }
                } else {
                    this.notificationPane.setText(message);
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
            }
            catch (Exception y) {
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.setText("We experienced an error while trying to add the chart of accounts. Please try again.");
                this.notificationPane.show();
            }
        });
    }
}

