/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.NextofKin;
import classes.User;
import com.google.gson.Gson;
import controllers.NextOfKinController;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class EditKinController
implements Initializable {
    private User user;
    private NextofKin kin;
    @FXML
    private VBox root;
    @FXML
    private TextField name;
    @FXML
    private TextField age;
    @FXML
    private TextField address;
    @FXML
    private ComboBox<String> relationship;
    @FXML
    private TextField percentage;
    @FXML
    private Button updateKin;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public NextofKin getKin() {
        return this.kin;
    }

    public void setKin(NextofKin kin) {
        this.kin = kin;
        this.name.setText(kin.getName());
        this.age.setText(kin.getAge() + "");
        this.percentage.setText(kin.getPercentage() + "");
        this.address.setText(kin.getAddress());
        this.relationship.setValue((Object)kin.getRelationship());
    }

    public void initialize(URL location, ResourceBundle resources) {
        String response1 = Config.loadDataFromPhp("masterfetch?type=nextofkinrelationships", new LinkedHashMap<String, Object>(), this.getUser());
        this.relationship.setItems(FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response1, String[].class))));
        this.updateKin.setOnAction(e -> {
            try {
                String tName = this.name.getText().trim();
                String tAge = this.age.getText().trim();
                String tRelationship = (String)this.relationship.getValue();
                String tAddress = this.address.getText().trim();
                String tPercentage = this.percentage.getText().trim();
                int tId = this.getKin().getId();
                double nAge = 0.0;
                double nAllocation = 0.0;
                String message = "";
                boolean error = false;
                if (tName.length() < 1) {
                    error = true;
                    message = "Please enter the next of kin name";
                }
                try {
                    if (tRelationship.length() < 1) {
                        throw new Exception();
                    }
                }
                catch (Exception y) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please select the relationship";
                }
                if (tAge.length() > 0) {
                    try {
                        nAge = Double.parseDouble(tAge);
                    }
                    catch (Exception y) {
                        error = true;
                        message = message + (message.length() > 0 ? "\n" : "");
                        message = message + "Please enter a valid next of kin age";
                    }
                }
                try {
                    nAllocation = Double.parseDouble(tPercentage);
                }
                catch (Exception y) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please enter a valid Percentage";
                }
                if (error) {
                    NextOfKinController.publicNotificationPane.setText(message);
                    NextOfKinController.publicNotificationPane.setGraphic((Node)Config.getTimesIcon());
                    NextOfKinController.publicNotificationPane.show();
                } else {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("name", tName);
                    params.put("age", nAge);
                    params.put("relationship", tRelationship);
                    params.put("address", tAddress);
                    params.put("percentage", nAllocation);
                    params.put("id", tId);
                    String response = Config.loadDataFromPhp("mastercreate?type=updatenextofkin", params, this.getUser());
                    System.out.println(response);
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    NextOfKinController.publicNotificationPane.setText(jr.getMessage());
                    NextOfKinController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                    NextOfKinController.publicNotificationPane.show();
                }
            }
            catch (Exception r) {
                r.printStackTrace();
                NextOfKinController.publicNotificationPane.setText("We encountered an error while processing your request. Please try again");
                NextOfKinController.publicNotificationPane.setGraphic((Node)Config.getBanIcon());
                NextOfKinController.publicNotificationPane.show();
            }
            Stage stage = (Stage)this.updateKin.getScene().getWindow();
            stage.close();
        });
    }
}

