/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.NumberSeries;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import controllers.NumberSeriesController;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.stage.Stage;

public class EditNumberSeries
implements Initializable {
    private NumberSeries ns;
    @FXML
    private Label header;
    @FXML
    private JFXTextField numberSeriesName;
    @FXML
    private JFXTextField prefix;
    @FXML
    private JFXTextField numberlength;
    @FXML
    private JFXTextField lastNumberUsed;
    @FXML
    private JFXButton cancel;
    @FXML
    private JFXButton save;

    public NumberSeries getNs() {
        return this.ns;
    }

    public void setNs(NumberSeries ns) {
        this.ns = ns;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
        this.numberlength.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                EditNumberSeries.this.numberlength.setStyle("-fx-border-width:0px; -fx-border-color:null;");
                EditNumberSeries.this.numberlength.setTooltip(null);
                if (!newValue.matches("\\d*")) {
                    EditNumberSeries.this.numberlength.setText(newValue.replaceAll("[^\\d]", ""));
                }
            }
        });
        this.numberSeriesName.textProperty().addListener((observable, oldValue, newValue) -> {
            this.numberSeriesName.setStyle("-fx-border-width:0px; -fx-border-color:null;");
            this.numberSeriesName.setTooltip(null);
        });
        this.lastNumberUsed.textProperty().addListener((observable, oldValue, newValue) -> {
            this.lastNumberUsed.setStyle("-fx-border-width:0px; -fx-border-color:null;");
            this.lastNumberUsed.setTooltip(null);
        });
        this.save.setOnAction(e -> {
            System.out.print(this.ns.getCode() + "");
            Boolean error = false;
            String mName = this.numberSeriesName.getText().trim();
            String mPrefix = this.prefix.getText().trim().toUpperCase();
            String mNumberLength = this.numberlength.getText().trim();
            String mLastNumberUsed = this.lastNumberUsed.getText().trim();
            if (mName.length() < 1) {
                this.numberSeriesName.setStyle("-fx-border-width:2px; -fx-border-color:#b71c1c;");
                this.numberSeriesName.setTooltip(new Tooltip("Please give a name"));
                error = true;
            }
            if (mNumberLength.length() < 1) {
                this.numberlength.setStyle("-fx-border-width:2px; -fx-border-color:#b71c1c;");
                this.numberlength.setTooltip(new Tooltip("Please the number length for data consistency"));
                error = true;
            }
            try {
                int length = Integer.parseInt(mNumberLength);
                if (mPrefix.length() > length) {
                    this.numberlength.setStyle("-fx-border-width:2px; -fx-border-color:#b71c1c;");
                    this.numberlength.setTooltip(new Tooltip("Number length must be greater than the length of the prefix"));
                    error = true;
                }
            }
            catch (Exception t) {
                this.numberlength.setStyle("-fx-border-width:2px; -fx-border-color:#b71c1c;");
                this.numberlength.setTooltip(new Tooltip("Please the number length for data consistency"));
                error = true;
            }
            if (!(mLastNumberUsed.equalsIgnoreCase("") || mLastNumberUsed.toLowerCase().contains(mPrefix.toLowerCase()) || mPrefix.equalsIgnoreCase(""))) {
                this.lastNumberUsed.setStyle("-fx-border-width:2px; -fx-border-color:#b71c1c;");
                this.lastNumberUsed.setTooltip(new Tooltip("Last Number used must have the prefix specified"));
                error = true;
            }
            if (!(this.ns.getName().equalsIgnoreCase(mName) && this.ns.getPrefix().equalsIgnoreCase(mPrefix) && this.ns.getLastNumberUsed().equalsIgnoreCase(mLastNumberUsed) && this.ns.getLength() != Integer.parseInt(mNumberLength))) {
                // empty if block
            }
            if (!error.booleanValue()) {
                if (this.ns.getName().equalsIgnoreCase(mName) && this.ns.getPrefix().equalsIgnoreCase(mPrefix) && this.ns.getLastNumberUsed().equalsIgnoreCase(mLastNumberUsed) && this.ns.getLength() == Integer.parseInt(mNumberLength)) {
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setTitle("No changes made.");
                    alert.setHeaderText("You have not made any changes to the number series");
                    alert.showAndWait();
                } else {
                    if (mLastNumberUsed.equalsIgnoreCase("")) {
                        mLastNumberUsed = mPrefix;
                        while (mLastNumberUsed.length() < Integer.parseInt(mNumberLength)) {
                            mLastNumberUsed = mLastNumberUsed + "0";
                        }
                        this.lastNumberUsed.setText(mLastNumberUsed);
                    }
                    try {
                        Alert alert;
                        int myLength = Integer.parseInt(mNumberLength);
                        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                        params.put("name", mName);
                        params.put("prefix", mPrefix);
                        params.put("length", myLength);
                        params.put("lastNumber", mLastNumberUsed);
                        params.put("code", this.ns.getCode());
                        String response = Config.loadDataFromPhp("masterupdate?type=numberseries", params, this.ns.getUser());
                        Gson g = new Gson();
                        JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                        if (jr.isStatus()) {
                            alert = new Alert(Alert.AlertType.INFORMATION);
                            alert.setTitle("Number Series successfully updated");
                            alert.setHeaderText("Number series were successfully updated.");
                            try {
                                Stage stage = (Stage)this.cancel.getScene().getWindow();
                                stage.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                NumberSeriesController.myTable.setItems(new NumberSeries().getAllNumberSeries(this.ns.getUser()));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        } else {
                            throw new Exception();
                        }
                        alert.showAndWait();
                    }
                    catch (Exception t) {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Updating number series failed");
                        alert.setHeaderText("We have experienced an error while updating the number series");
                        alert.showAndWait();
                    }
                }
            }
        });
        this.numberSeriesName.setText(this.ns.getName());
        this.prefix.setText(this.ns.getPrefix());
        this.numberlength.setText(this.ns.getLength() + "");
        this.lastNumberUsed.setText(this.ns.getLastNumberUsed());
    }

    public EditNumberSeries(NumberSeries ns1) {
        this.ns = ns1;
    }
}

