/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.PurchaseLines;
import classes.ShopItem;
import classes.User;
import com.google.gson.Gson;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;

public class EditPurchaseLineController
implements Initializable {
    private String documentType;
    private User user;
    private PurchaseLines line;
    private ObservableList<ShopItem> items;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;
    @FXML
    private Label docNo;
    @FXML
    private Label lineId;
    @FXML
    private ComboBox<ShopItem> product;
    @FXML
    private Button searchItem;
    @FXML
    private TextField unitPrice;
    @FXML
    private TextField quantity;
    @FXML
    private Button cancel;
    @FXML
    private Button save;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public PurchaseLines getLine() {
        return this.line;
    }

    public void setLine(PurchaseLines line) {
        this.line = line;
        this.docNo.setText(line.getDocumentNumber());
        this.lineId.setText(line.getLineId() + "");
        this.quantity.setText(line.getQuantity() + "");
        this.unitPrice.setText(line.getUnitPrice() + "");
        ObservableList selectedItems = FXCollections.observableArrayList((Collection)this.items.stream().filter(v -> v.getCode().equalsIgnoreCase(line.getItemNo())).collect(Collectors.toList()));
        try {
            this.product.setValue(selectedItems.get(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
        if (!Config.ERP_MODE && documentType.equalsIgnoreCase("purchaseInvoice")) {
            this.searchItem.setDisable(true);
            this.product.setDisable(true);
        }
    }

    public ObservableList<ShopItem> getItems() {
        return this.items;
    }

    public void setItems(ObservableList<ShopItem> items) {
        this.items = items;
        this.product.setItems(items);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        this.searchItem.setOnAction(e -> {
            try {
                Gson gson = new Gson();
                String response = new Config().getObjectFromSelection("shopitem", gson.toJson((Object)this.product.getItems()), this.getUser());
                this.product.setValue(gson.fromJson(response, ShopItem.class));
                this.unitPrice.setText(((ShopItem)this.product.getValue()).getBuyingPrice() + "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.quantity.requestFocus();
        this.cancel.setOnAction(e -> ((Stage)this.cancel.getScene().getWindow()).close());
        this.save.setOnAction(e -> {
            try {
                PurchaseLines line = this.getLine();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("headerNo", line.getDocumentNumber());
                params.put("itemType", line.getItemType());
                params.put("documentType", this.documentType);
                params.put("lineId", line.getLineId());
                params.put("quantity", Double.parseDouble(this.quantity.getText().trim()));
                params.put("unitPrice", Double.parseDouble(this.unitPrice.getText().trim()));
                params.put("itemNo", ((ShopItem)this.product.getValue()).getCode());
                String response = Config.loadDataFromPhp("masterupdate?type=purchaseline", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    ((Stage)this.cancel.getScene().getWindow()).close();
                } else {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
            catch (Exception y) {
                this.notificationPane.setText("We encountered an error while processing your request");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
    }
}

