/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.Department;
import classes.Employee;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.Region;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.GeneralListController;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import sun.misc.BASE64Decoder;

public class EmployeeCardController
implements Initializable {
    private boolean payroll = false;
    private User user;
    private Employee employee;
    String imagePath = "";
    @FXML
    private VBox root;
    @FXML
    private VBox holder;
    @FXML
    private TextField firstName;
    @FXML
    private TextField lastName;
    @FXML
    private TextField phoneNumber;
    @FXML
    private DatePicker dateOfBirth;
    @FXML
    private ComboBox<String> gender;
    @FXML
    private CheckBox entitledToLeave;
    @FXML
    private TextField middleName;
    @FXML
    private TextField payrollNumber;
    @FXML
    private TextField emailAddress;
    @FXML
    private TextField idNumber;
    @FXML
    private TextField goodConduct;
    @FXML
    private DatePicker employmentDate;
    @FXML
    private CheckBox disabled;
    @FXML
    private ImageView profilePhoto;
    @FXML
    private HBox disabilityDescriptionHbox;
    @FXML
    private TextArea disabilityDescription;
    @FXML
    private TextField kraPin;
    @FXML
    private TextField nssfNumber;
    @FXML
    private TextField nhifNumber;
    @FXML
    private ComboBox<Department> department;
    @FXML
    private ComboBox<Region> region;
    @FXML
    private CheckBox hod;
    @FXML
    private TextField jobTitle;
    @FXML
    private JFXButton addEmployee;
    @FXML
    private JFXButton reset;
    @FXML
    private TextField bank;
    @FXML
    private TextField bankBranch;
    @FXML
    private TextField bankAccountNo;
    @FXML
    private TextField basicSalary;
    @FXML
    private CheckBox paysPaye;
    @FXML
    private CheckBox paysNHIF;
    @FXML
    private CheckBox paysNSSF;
    @FXML
    private CheckBox suspendPay;
    @FXML
    private CheckBox paysNITA;
    @FXML
    private CheckBox deductHousingLevy;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private TextField employeeNo;
    @FXML
    private ComboBox<String> employmentStatus;
    @FXML
    private Hyperlink previousYearBalance;
    @FXML
    private Hyperlink currentYearAllocated;
    @FXML
    private Hyperlink currentYearTaken;
    @FXML
    private Hyperlink totalLeaveBalance;
    @FXML
    private TabPane tabpane;
    @FXML
    private Tab bioDataTab;
    @FXML
    private Tab employmentDetailsTab;
    @FXML
    private Tab leaveDetailsTab;
    @FXML
    private Tab paymentDetailsTab;
    @FXML
    private Button searchRegion;

    public boolean isPayroll() {
        return this.payroll;
    }

    public void setPayroll(boolean payroll) {
        this.payroll = payroll;
        if (payroll) {
            this.tabpane.getTabs().add((Object)this.paymentDetailsTab);
        }
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        Platform.runLater(() -> {
            this.department.setItems(new Department().getAllDepartments(this.getUser()));
            this.region.setItems(new Region().getAllRegions(user));
            this.employmentStatus.setItems(new Config().getEnumText("employee", "employment_terms", this.getUser()));
        });
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
        this.employeeNo.setText(employee.getEmployeeNumber());
        this.firstName.setText(employee.getFirstName());
        this.middleName.setText(employee.getMidddleName());
        this.lastName.setText(employee.getLastName());
        this.payrollNumber.setText(employee.getPayrollNumber());
        this.phoneNumber.setText(employee.getPhoneNumber());
        this.emailAddress.setText(employee.getEmail());
        this.employmentStatus.setValue((Object)employee.getStatus());
        try {
            LocalDate localDate = Config.stringToLocalDate(employee.getDateOfBirth());
            this.dateOfBirth.setValue((Object)localDate);
        }
        catch (Exception localDate) {
            // empty catch block
        }
        try {
            LocalDate employDate = Config.stringToLocalDate(employee.getEmploymentDate());
            this.employmentDate.setValue((Object)employDate);
        }
        catch (Exception employDate) {
            // empty catch block
        }
        try {
            this.gender.setValue((Object)employee.getGender());
        }
        catch (Exception employDate) {
            // empty catch block
        }
        this.goodConduct.setText(employee.getGoodConduct());
        this.idNumber.setText(employee.getIdNumber() + "");
        this.kraPin.setText(employee.getKraPin());
        this.disabilityDescription.setText(employee.getDisabilityDescription());
        this.disabled.setSelected(employee.isDisabled());
        this.disabilityDescriptionHbox.setDisable(!employee.isDisabled());
        this.nssfNumber.setText(employee.getNssfNo());
        this.nhifNumber.setText(employee.getNhifNo());
        this.jobTitle.setText(employee.getJobTitle());
        this.hod.setSelected(employee.isHod());
        this.department.setValue((Object)employee.getDepartment());
        this.region.setValue((Object)employee.getRegion());
        this.bank.setText(employee.getBank());
        this.bankBranch.setText(employee.getBankBranch());
        this.bankAccountNo.setText(employee.getBankAccountNumber());
        this.basicSalary.setText(employee.getBasicSalary() + "");
        try {
            this.entitledToLeave.setSelected(employee.isEntitledToLeave());
        }
        catch (Exception employDate) {
            // empty catch block
        }
        try {
            this.paysPaye.setSelected(employee.isPaysPAYE());
        }
        catch (Exception employDate) {
            // empty catch block
        }
        try {
            this.paysNHIF.setSelected(employee.isPaysNHIF());
        }
        catch (Exception employDate) {
            // empty catch block
        }
        try {
            this.paysNSSF.setSelected(employee.isPaysNSSF());
        }
        catch (Exception employDate) {
            // empty catch block
        }
        try {
            this.paysNITA.setSelected(employee.isPaysNITA());
        }
        catch (Exception employDate) {
            // empty catch block
        }
        try {
            this.deductHousingLevy.setSelected(employee.isDeductHousingLevy());
        }
        catch (Exception employDate) {
            // empty catch block
        }
        try {
            this.suspendPay.setSelected(employee.isSuspendPay());
        }
        catch (Exception employDate) {
            // empty catch block
        }
        if (employee.isExited()) {
            this.addEmployee.setDisable(employee.isExited());
        } else if (this.isPayroll()) {
            this.addEmployee.setDisable(false);
        }
        this.addEmployee.setText("Update Details");
        try {
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] imageByte = decoder.decodeBuffer(employee.getPhotoBlob());
            ByteArrayInputStream bis = new ByteArrayInputStream(imageByte);
            Image image = new Image((InputStream)bis);
            this.profilePhoto.setImage(image);
            bis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.searchRegion.setOnAction(e -> {
            try {
                String response = new Config().getObjectFromSelection("region", new Gson().toJson((Object)this.region.getItems()), this.getUser());
                this.region.setValue(new Gson().fromJson(response, Region.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.tabpane.getTabs().remove((Object)this.paymentDetailsTab);
        String path = System.getProperty("user.dir");
        path = path.replace("\\", "/");
        this.imagePath = path + "/holder.png";
        this.disabilityDescriptionHbox.setDisable(true);
        ValidationSupport validationSupport = new ValidationSupport();
        validationSupport.registerValidator((Control)this.firstName, Validator.createEmptyValidator((String)"First name is required"));
        validationSupport.registerValidator((Control)this.lastName, Validator.createEmptyValidator((String)"Last name is required"));
        validationSupport.registerValidator((Control)this.idNumber, Validator.createEmptyValidator((String)"Id number is required"));
        validationSupport.registerValidator((Control)this.phoneNumber, Validator.createEmptyValidator((String)"Phone number is required"));
        validationSupport.registerValidator(this.gender, Validator.createEmptyValidator((String)"Gender is required"));
        this.notificationPane.setContent((Node)this.holder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.reset.setOnAction(e -> {
            Stage stage = (Stage)this.reset.getScene().getWindow();
            stage.close();
        });
        ObservableList genderOptions = FXCollections.observableArrayList();
        genderOptions.add((Object)"Male");
        genderOptions.add((Object)"Female");
        this.gender.setItems(genderOptions);
        this.gender.getSelectionModel().select(0);
        this.addEmployee.setOnAction(e -> {
            LocalDate ldate;
            String fName = "";
            String lName = "";
            String mName = "";
            String tidNumber = "";
            String tphoneNumber = "";
            String tPayrollN = "";
            String email = "";
            String dob = "";
            String tEmploymentDate = "";
            String tGender = "";
            boolean tEntitledToLeave = this.entitledToLeave.isSelected();
            String tdisabilityDescription = "";
            String tKra = "";
            String tNssf = "";
            String tNhif = "";
            int tDepartment = 0;
            int tRegionCode = 0;
            String tJobTitle = "";
            String tBank = "";
            String tBankBranch = "";
            String tBankAccountNo = "";
            String tgood = "";
            double tBasicSalary = 0.0;
            String employmentTerms = "";
            boolean tHod = this.hod.isSelected();
            boolean error = false;
            String message = "";
            try {
                fName = this.firstName.getText().trim();
                if (fName.equals("")) {
                    throw new Exception();
                }
            }
            catch (Exception y) {
                error = true;
                message = "Please input the employee first name. ";
            }
            try {
                lName = this.lastName.getText().trim();
                if (lName.equals("")) {
                    throw new Exception();
                }
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() == 0 ? "" : "\n");
                message = message + "Please input the employee last name. ";
            }
            try {
                tidNumber = this.idNumber.getText().trim();
                if (tidNumber.equals("")) {
                    throw new Exception();
                }
                try {
                    Integer.parseInt(tidNumber);
                }
                catch (Exception y) {
                    error = true;
                    message = message + (message.length() == 0 ? "" : "\n");
                    message = message + "Please input a valid id number. ";
                }
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() == 0 ? "" : "\n");
                message = message + "Please input a valid id number. ";
            }
            try {
                tphoneNumber = this.phoneNumber.getText().trim();
                if (tphoneNumber.equals("")) {
                    throw new Exception();
                }
                if (tphoneNumber.length() < 10 || tphoneNumber.length() > 13) {
                    throw new Exception();
                }
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() == 0 ? "" : "\n");
                message = message + "Please input a valid phone number. ";
            }
            try {
                mName = this.middleName.getText().trim();
            }
            catch (Exception t) {
                mName = "";
            }
            try {
                tPayrollN = this.payrollNumber.getText().trim();
            }
            catch (Exception t) {
                tPayrollN = "";
            }
            try {
                email = this.emailAddress.getText().trim();
            }
            catch (Exception t) {
                email = "";
            }
            try {
                tgood = this.goodConduct.getText().trim();
            }
            catch (Exception t) {
                tgood = "";
            }
            try {
                employmentTerms = ((String)this.employmentStatus.getValue()).trim();
            }
            catch (Exception ignored) {
                employmentTerms = "";
            }
            try {
                tdisabilityDescription = this.disabilityDescription.getText().trim();
            }
            catch (Exception t) {
                tdisabilityDescription = "";
            }
            try {
                tKra = this.kraPin.getText().trim();
            }
            catch (Exception t) {
                tKra = "";
            }
            try {
                tNhif = this.nhifNumber.getText().trim();
            }
            catch (Exception t) {
                tNhif = "";
            }
            try {
                tNssf = this.nssfNumber.getText().trim();
            }
            catch (Exception t) {
                tNssf = "";
            }
            try {
                tJobTitle = this.jobTitle.getText().trim();
            }
            catch (Exception t) {
                tJobTitle = "";
            }
            try {
                tDepartment = ((Department)this.department.getValue()).getCode();
            }
            catch (Exception t) {
                tDepartment = 0;
            }
            try {
                tRegionCode = ((Region)this.region.getValue()).getId();
            }
            catch (Exception t) {
                tRegionCode = 0;
            }
            try {
                tGender = ((String)this.gender.getValue()).trim();
                if (tGender.equals("")) {
                    throw new Exception();
                }
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() == 0 ? "" : "\n");
                message = message + "Please select the employee gender. ";
            }
            try {
                try {
                    ldate = (LocalDate)this.dateOfBirth.getValue();
                    if (!ldate.equals(null)) {
                        dob = Config.localDateToString(ldate);
                    }
                }
                catch (NullPointerException r) {
                    dob = "0000-00-00";
                }
            }
            catch (Exception t) {
                dob = "0000-00-00";
            }
            try {
                try {
                    ldate = (LocalDate)this.employmentDate.getValue();
                    tEmploymentDate = Config.localDateToString(ldate);
                }
                catch (NullPointerException r) {
                    tEmploymentDate = "0000-00-00";
                }
            }
            catch (Exception t) {
                tEmploymentDate = "0000-00-00";
            }
            try {
                tBank = this.bank.getText().trim();
            }
            catch (Exception t) {
                // empty catch block
            }
            try {
                tBankBranch = this.bankBranch.getText().trim();
            }
            catch (Exception t) {
                // empty catch block
            }
            try {
                tBankAccountNo = this.bankAccountNo.getText().trim();
            }
            catch (Exception t) {
                // empty catch block
            }
            try {
                tBasicSalary = Double.parseDouble(this.basicSalary.getText().trim());
            }
            catch (Exception t) {
                if (this.isPayroll()) {
                    error = true;
                    message = message + (message.length() == 0 ? "" : "\n");
                    message = message + "Please enter the employee basic salary ";
                }
                tBasicSalary = 0.0;
            }
            if (error) {
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.setText(message);
                this.notificationPane.show();
            } else {
                try {
                    String photoJson = "";
                    try {
                        ByteArrayOutputStream ba = Config.convertFileToJson(this.imagePath);
                        photoJson = StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])ba.toByteArray()));
                    }
                    catch (Exception y) {
                        photoJson = "";
                    }
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    String tEmployeeNo = "";
                    boolean newEmployee = false;
                    NumberSeries ns = new NumberSeries(5, this.getUser());
                    try {
                        tEmployeeNo = this.employeeNo.getText().trim();
                        if (tEmployeeNo.length() < 1) {
                            throw new Exception();
                        }
                    }
                    catch (Exception y) {
                        newEmployee = true;
                        tEmployeeNo = ns.getNextNumber();
                    }
                    params.put("employeeNumber", tEmployeeNo);
                    params.put("fName", fName);
                    params.put("lName", lName);
                    params.put("mName", mName);
                    params.put("idNumber", tidNumber);
                    params.put("phoneNumber", tphoneNumber);
                    params.put("payrollNumber", tPayrollN);
                    params.put("email", email);
                    params.put("goodConduct", tgood);
                    params.put("dob", dob);
                    params.put("gender", tGender);
                    params.put("disabled", this.disabled.isSelected() ? 1 : 0);
                    params.put("disabilityDescription", tdisabilityDescription);
                    params.put("kra", tKra);
                    params.put("nssf", tNssf);
                    params.put("nhif", tNhif);
                    params.put("department", tDepartment);
                    params.put("region", tRegionCode);
                    params.put("employmentTerms", employmentTerms);
                    params.put("jobTitle", tJobTitle);
                    params.put("hod", tHod ? 1 : 0);
                    params.put("photo", photoJson);
                    params.put("employmentDate", tEmploymentDate);
                    params.put("entitledToLeave", tEntitledToLeave ? 1 : 0);
                    params.put("bank", tBank);
                    params.put("bankBranch", tBankBranch);
                    params.put("bankAccount", tBankAccountNo);
                    params.put("basicSalary", tBasicSalary);
                    params.put("paysPAYE", this.paysPaye.isSelected() ? 1 : 0);
                    params.put("paysNHIF", this.paysNHIF.isSelected() ? 1 : 0);
                    params.put("paysNSSF", this.paysNSSF.isSelected() ? 1 : 0);
                    params.put("paysNITA", this.paysNITA.isSelected() ? 1 : 0);
                    params.put("deductHousingLevy", this.deductHousingLevy.isSelected() ? 1 : 0);
                    params.put("suspendPay", this.suspendPay.isSelected() ? 1 : 0);
                    String url = "mastercreate?type=employees";
                    if (!newEmployee) {
                        url = "masterupdate?type=employees";
                        if (this.isPayroll()) {
                            url = "masterupdate?type=payrollemployees";
                        }
                    }
                    System.out.println(url);
                    String response = Config.loadDataFromPhp(url, params, this.getUser());
                    System.out.println(response);
                    Gson g = new Gson();
                    JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        if (newEmployee) {
                            ns.updateLastUsed(tEmployeeNo);
                        }
                        Stage stage = (Stage)this.addEmployee.getScene().getWindow();
                        stage.close();
                        GeneralListController.publicNotificationPane.setText(jr.getMessage());
                        GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                        GeneralListController.publicNotificationPane.show();
                    } else {
                        this.notificationPane.setText(jr.getMessage());
                        this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                        this.notificationPane.show();
                    }
                }
                catch (Exception y) {
                    this.notificationPane.setText("We encountered an error while trying to save the employee. Please try again later");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                    y.printStackTrace();
                }
            }
        });
        this.disabled.setOnAction(e -> {
            if (this.disabled.isSelected()) {
                this.disabilityDescriptionHbox.setDisable(false);
            } else {
                this.disabilityDescriptionHbox.setDisable(true);
                this.disabilityDescription.setText("");
            }
        });
        this.employmentDate.setValue((Object)Config.getCurrentLocaldate());
        final ContextMenu imageOptions = new ContextMenu();
        MenuItem upload = new MenuItem("Upload");
        upload.setOnAction(e -> {
            FileChooser chooser = new FileChooser();
            chooser.setTitle("Select Item Picture");
            chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("All Images", new String[]{"*.jpg", "*.png"}), new FileChooser.ExtensionFilter("JPG", new String[]{"*.jpg"}), new FileChooser.ExtensionFilter("PNG", new String[]{"*.png"})});
            File file = chooser.showOpenDialog((Window)new Stage());
            if (file != null) {
                this.openFile(file);
            }
        });
        MenuItem reset = new MenuItem("Reset to Default");
        String myPath = path;
        reset.setOnAction(e -> {
            String fileLocation = myPath + "/holder.png";
            File imgFile = new File(fileLocation);
            this.openFile(imgFile);
        });
        imageOptions.getItems().addAll((Object[])new MenuItem[]{upload, reset});
        this.profilePhoto.setOnContextMenuRequested((EventHandler)new EventHandler<ContextMenuEvent>(){

            public void handle(ContextMenuEvent event) {
                imageOptions.show((Node)EmployeeCardController.this.profilePhoto, event.getScreenX(), event.getScreenY());
            }
        });
    }

    private void openFile(File file) {
        try {
            Image image = new Image(file.toURI().toString());
            this.profilePhoto.setImage(image);
            this.imagePath = file.getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

