/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.PaymentMethod;
import classes.User;
import com.google.gson.Gson;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;
import org.controlsfx.control.NotificationPane;

public class FinanceSetupController
implements Initializable {
    private User user;
    @FXML
    AnchorPane holder;
    @FXML
    NotificationPane notificationPane;
    @FXML
    private TableView<PaymentMethod> paymentMethods;
    @FXML
    private TableColumn paymethod;
    @FXML
    private TableColumn requiresTransactionRef;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.paymentMethods.setItems(new PaymentMethod().getAllPaymentMethods(this.getUser()));
        PaymentMethod pMethod = new PaymentMethod();
        pMethod.setCode(0);
        this.paymentMethods.getItems().add((Object)pMethod);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane.setContent((Node)this.holder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.notificationPane.setCloseButtonVisible(true);
        this.requiresTransactionRef.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<PaymentMethod, Boolean>, ObservableValue<Boolean>>(){

            public ObservableValue<Boolean> call(TableColumn.CellDataFeatures<PaymentMethod, Boolean> param) {
                final PaymentMethod paymentMethod = (PaymentMethod)param.getValue();
                SimpleBooleanProperty booleanProp = new SimpleBooleanProperty(paymentMethod.isRequiresRef());
                booleanProp.addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                        FinanceSetupController.this.updatePaymentMethod(paymentMethod.getCode(), paymentMethod.getPaymentMethod(), newValue);
                    }
                });
                return booleanProp;
            }
        });
        this.requiresTransactionRef.setCellFactory((Callback)new Callback<TableColumn<PaymentMethod, Boolean>, TableCell<PaymentMethod, Boolean>>(){

            public TableCell<PaymentMethod, Boolean> call(TableColumn<PaymentMethod, Boolean> p) {
                CheckBoxTableCell cell = new CheckBoxTableCell();
                cell.setAlignment(Pos.CENTER);
                return cell;
            }
        });
        this.paymethod.setCellValueFactory((Callback)new PropertyValueFactory("paymentMethod"));
        this.paymethod.setCellFactory(TextFieldTableCell.forTableColumn());
        this.paymethod.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<PaymentMethod, String>>(){

            public void handle(TableColumn.CellEditEvent<PaymentMethod, String> t) {
                PaymentMethod pl = (PaymentMethod)t.getTableView().getItems().get(t.getTablePosition().getRow());
                FinanceSetupController.this.updatePaymentMethod(pl.getCode(), (String)t.getNewValue(), pl.isRequiresRef());
            }
        });
    }

    public void updatePaymentMethod(int id, String paymentMethod, boolean requiresRef) {
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("code", id);
            params.put("description", paymentMethod);
            params.put("requiresRef", requiresRef ? 1 : 0);
            String response = Config.loadDataFromPhp("mastercreate?type=paymentmethods", params, this.getUser());
            System.out.println(response);
            Gson g = new Gson();
            JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                this.paymentMethods.setItems(new PaymentMethod().getAllPaymentMethods(this.getUser()));
                PaymentMethod pMethod = new PaymentMethod();
                pMethod.setCode(0);
                this.paymentMethods.getItems().add((Object)pMethod);
            }
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.notificationPane.setText("We encountered an error while processing your request. Kindly try again");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
    }
}

