/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.Floor;
import classes.JsonResponses;
import classes.Property;
import classes.User;
import com.google.gson.Gson;
import java.net.URL;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class FloorController
implements Initializable {
    private User user;
    private Property myProperty;
    @FXML
    private ComboBox<Property> property;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private StackPane holder;
    @FXML
    private TableView<Floor> allFloors;
    @FXML
    private TableColumn colFloorNo;
    @FXML
    private TableColumn colFloorName;
    @FXML
    private TableColumn colDelete;
    @FXML
    private MaskerPane masker;
    @FXML
    private TextField floorNo;
    @FXML
    private TextField floorName;
    @FXML
    private Button addFloor;
    public static TableView<Floor> publicFloors = new TableView();
    public static NotificationPane publicNotificationPane = new NotificationPane();

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        ObservableList<Property> allProperties = new Property().getAllProperties(user);
        allProperties.sort(Comparator.comparing(Property::getName));
        this.property.setItems(allProperties);
    }

    public Property getMyProperty() {
        return this.myProperty;
    }

    public void setMyProperty(Property myProperty) {
        this.myProperty = myProperty;
        this.property.setValue((Object)myProperty);
        this.loadFloors();
    }

    public void initialize(URL location, ResourceBundle resources) {
        publicFloors = this.allFloors;
        publicNotificationPane = this.notificationPane;
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.floorNo, Validator.createEmptyValidator((String)"Required"));
        this.property.setOnAction(e -> this.loadFloors());
        this.colFloorNo.setCellValueFactory((Callback)new PropertyValueFactory("floorNo"));
        this.colFloorName.setCellValueFactory((Callback)new PropertyValueFactory("floorName"));
        this.addFloor.setOnAction(e -> {
            try {
                String tFloorNo = this.floorNo.getText().trim();
                String tFloorName = this.floorName.getText().trim();
                if (tFloorNo.length() < 1) {
                    this.notificationPane.setText("Floor No is required");
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                } else {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("floorNo", tFloorNo);
                    params.put("floorName", tFloorName);
                    params.put("property", ((Property)this.property.getValue()).getPropertyCode());
                    new Config();
                    String response = Config.loadDataFromPhp("mastercreate?type=floor", params, this.getUser());
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                    if (jr.isStatus()) {
                        this.loadFloors();
                        this.floorName.setText("");
                        this.floorNo.setText("");
                    }
                }
            }
            catch (Exception y) {
                this.notificationPane.setText("We experienced an error while performing this action");
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
        });
        ContextMenu menu = new ContextMenu();
        MenuItem delFloor = new MenuItem("Delete Floor");
        delFloor.setGraphic((Node)Config.getDeleteIcon());
        menu.getItems().add((Object)delFloor);
        this.allFloors.setContextMenu(menu);
        delFloor.setOnAction(e -> {
            try {
                Floor entry = (Floor)this.allFloors.getSelectionModel().getSelectedItem();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("floorId", entry.getFloorId());
                String response = Config.loadDataFromPhp("masterdelete?type=floor", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    this.loadFloors();
                }
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
            }
            catch (Exception u) {
                this.notificationPane.setText("We encountered an error while deleting the floor");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
    }

    public void loadFloors() {
        try {
            Task<Void> task1 = new Task<Void>(){

                public Void call() {
                    Platform.runLater(() -> FloorController.this.masker.setVisible(true));
                    FloorController.this.allFloors.setItems(new Floor().getAllFloors(((Property)FloorController.this.property.getValue()).getPropertyCode(), FloorController.this.getUser()));
                    Platform.runLater(() -> FloorController.this.masker.setVisible(false));
                    return null;
                }
            };
            Thread backgroundThread = new Thread((Runnable)task1);
            backgroundThread.setDaemon(true);
            backgroundThread.start();
        }
        catch (Exception y) {
            this.notificationPane.setText("We experienced an error while loading the data");
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        }
    }
}

