/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.ChargeItem;
import classes.Config;
import classes.Employee;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.Project;
import classes.Region;
import classes.SalesHeader;
import classes.SalesLines;
import classes.User;
import com.google.gson.Gson;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;
import javafx.scene.web.HTMLEditor;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class ImprestVoucherController
implements Initializable {
    private User user;
    private SalesHeader imprest;
    @FXML
    private VBox root;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox notificationHolder;
    @FXML
    private Hyperlink imprestNo;
    @FXML
    private ComboBox<Region> region;
    @FXML
    private ComboBox<Project> project;
    @FXML
    private ComboBox<Employee> staff;
    @FXML
    private TextField purposeOfImprest;
    @FXML
    private DatePicker fromDate;
    @FXML
    private DatePicker toDate;
    @FXML
    private Hyperlink totalCost;
    @FXML
    private HTMLEditor activity;
    @FXML
    private HTMLEditor target;
    @FXML
    private ComboBox<ChargeItem> item;
    @FXML
    private TextField quantity;
    @FXML
    private TextField details;
    @FXML
    private Button addItem;
    @FXML
    private TableView<SalesLines> allItems;
    @FXML
    private TableColumn colItem;
    @FXML
    private TableColumn colUnitCost;
    @FXML
    private TableColumn colQuantity;
    @FXML
    private TableColumn colTotalCost;
    @FXML
    private TableColumn colDetails;
    @FXML
    private DatePicker postingDate;
    @FXML
    private Button cancel;
    @FXML
    private Button save;
    @FXML
    private Button post;
    @FXML
    private ComboBox<Bank> payingBank;
    @FXML
    private TextField externalRefNo;

    public User getUser() {
        return this.user;
    }

    public void setUser(final User user) {
        this.user = user;
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    ImprestVoucherController.this.notificationPane.setText("Loading Values, Please wait");
                    ImprestVoucherController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    ImprestVoucherController.this.notificationPane.show();
                });
                ObservableList<Employee> allEmployees = new Employee().getAllEmployees(user);
                ObservableList<ChargeItem> allItems = new ChargeItem().getChargeItems(4, user);
                ObservableList<Region> allRegions = new Region().getAllRegions(user);
                ObservableList<Bank> allBanks = Bank.getAllBanks(user);
                ObservableList<Project> allProjects = new Project().getAllProjects(user);
                Platform.runLater(() -> {
                    ImprestVoucherController.this.staff.setItems(allEmployees);
                    ImprestVoucherController.this.item.setItems(allItems);
                    ImprestVoucherController.this.region.setItems(allRegions);
                    ImprestVoucherController.this.notificationPane.hide();
                    ImprestVoucherController.this.payingBank.setItems(allBanks);
                    ImprestVoucherController.this.project.setItems(allProjects);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public SalesHeader getImprest() {
        return this.imprest;
    }

    public void setImprest(SalesHeader imprest) {
        this.imprest = imprest;
        this.imprestNo.setText(imprest.getDoc_no());
        try {
            this.region.setValue((Object)imprest.getCustomer().getRegion());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.purposeOfImprest.setText(imprest.getPurpose());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.postingDate.setValue((Object)Config.stringToLocalDate(imprest.getSales_date()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.fromDate.setValue((Object)Config.stringToLocalDate(imprest.getFromDate()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.toDate.setValue((Object)Config.stringToLocalDate(imprest.getToDate()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.activity.setHtmlText(imprest.getActivity());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.target.setHtmlText(imprest.getTarget());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.project.setValue((Object)imprest.getProject());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.payingBank.setValue((Object)imprest.getBank());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.externalRefNo.setText(imprest.getExternalRef());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadInvoiceLines();
        if (imprest.isPosted()) {
            this.save.setDisable(true);
            this.post.setDisable(true);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.postingDate, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.fromDate, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.toDate, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.region, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.staff, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.purposeOfImprest, Validator.createEmptyValidator((String)"Required"));
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.notificationHolder);
        this.save.setOnAction(e -> this.saveInvoice());
        ContextMenu menu = new ContextMenu();
        MenuItem delete = new MenuItem("Delete");
        delete.setGraphic((Node)Config.getDeleteIcon());
        delete.setOnAction(e -> {
            SalesLines line = (SalesLines)this.allItems.getSelectionModel().getSelectedItem();
        });
        menu.getItems().add((Object)delete);
        this.allItems.setContextMenu(menu);
        this.colItem.setCellValueFactory((Callback)new PropertyValueFactory("itemDescription"));
        this.colQuantity.setCellValueFactory((Callback)new PropertyValueFactory("quantityString"));
        this.colUnitCost.setCellValueFactory((Callback)new PropertyValueFactory("unitPriceString"));
        this.colTotalCost.setCellValueFactory((Callback)new PropertyValueFactory("totalAmountString"));
        this.colDetails.setCellValueFactory((Callback)new PropertyValueFactory("details"));
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
        this.addItem.setOnAction(e -> {
            this.notificationPane.hide();
            String itemNo = "";
            boolean error = false;
            String message = "";
            String tDescription = "";
            double mUnitPrice = 0.0;
            try {
                ChargeItem cI = (ChargeItem)this.item.getValue();
                itemNo = cI.getCode() + "";
                mUnitPrice = cI.getAmount();
                tDescription = cI.getName();
            }
            catch (Exception t) {
                error = true;
                message = message + "Please select an item";
            }
            String tQuantity = this.quantity.getText().trim();
            double mQuantity = 0.0;
            if (itemNo.isEmpty()) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter an item for the line";
            }
            if (tDescription.isEmpty()) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter a description for the line";
            }
            if (tQuantity.isEmpty()) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter quantity for the line";
            } else {
                try {
                    mQuantity = Double.parseDouble(tQuantity);
                    if (mQuantity <= 0.0) {
                        error = true;
                        message = message + (message.length() > 0 ? "\n" : "");
                        message = message + "Quantity cannot be less or equal to zero";
                    }
                }
                catch (Exception t) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please enter a valid quantity for the line";
                }
            }
            String tDetails = "";
            try {
                tDetails = this.details.getText().trim();
            }
            catch (Exception y) {
                tDetails = "";
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            } else if (this.saveInvoice()) {
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("invoiceNo", this.imprestNo.getText());
                    params.put("itemType", "Charge Items");
                    params.put("itemNo", itemNo);
                    params.put("description", tDescription);
                    params.put("unitPrice", mUnitPrice);
                    params.put("quantity", tQuantity);
                    params.put("uomRelationshipCode", "");
                    params.put("document_type", "imprest");
                    params.put("details", tDetails);
                    String response = Config.loadDataFromPhp("mastercreate?type=customerinvoiceline", params, this.getUser());
                    System.out.println(response);
                    Gson g = new Gson();
                    JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                    this.loadInvoiceLines();
                    if (jr.isStatus()) {
                        this.item.setValue(null);
                        this.quantity.setText("1");
                        this.details.setText("");
                    }
                }
                catch (Exception t) {
                    this.notificationPane.setText("We encountered an error while adding the invoice line. ");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
            }
        });
        this.post.setOnAction(e -> {
            block9: {
                String tInvoiceNo;
                boolean error = false;
                try {
                    if (this.getImprest().isPosted()) {
                        error = true;
                        Stage stage = (Stage)this.post.getScene().getWindow();
                        stage.close();
                        return;
                    }
                }
                catch (Exception stage) {
                    // empty catch block
                }
                if (this.saveInvoice() && !error && !(tInvoiceNo = this.imprestNo.getText().trim()).isEmpty()) {
                    try {
                        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                        alert.setTitle("Confirm Post");
                        alert.setHeaderText("Posting the imprest results in a change in the financial position. ");
                        alert.setContentText("Are you sure you want to post imprest number " + tInvoiceNo + "?");
                        Optional result = alert.showAndWait();
                        if (result.get() != ButtonType.OK) break block9;
                        try {
                            JsonResponses jr = new SalesHeader().postDocument(tInvoiceNo, "", this.getUser());
                            if (jr.isStatus()) {
                                Stage stage = (Stage)this.post.getScene().getWindow();
                                stage.close();
                                break block9;
                            }
                            this.notificationPane.setText(jr.getMessage());
                            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                            this.notificationPane.show();
                        }
                        catch (Exception t) {
                            this.notificationPane.setText("We encountered an error while posting the customer invoice. Please try again later");
                            this.notificationPane.setGraphic((Node)Config.getBanIcon());
                            this.notificationPane.show();
                            t.printStackTrace();
                        }
                    }
                    catch (Exception r) {
                        this.notificationPane.setText("We encountered an error while posting the imprest. Please try again later");
                        this.notificationPane.setGraphic((Node)Config.getBanIcon());
                        this.notificationPane.show();
                    }
                }
            }
        });
    }

    public boolean saveInvoice() {
        boolean isNew = false;
        String tInvoiceNo = this.imprestNo.getText().trim();
        String tInvoiceDate = "";
        String tRegion = "";
        String tProjectCode = "";
        String tSalesRep = "";
        String tCustomerNo = "";
        String tStaff = "";
        String tPurpose = "";
        String tFromDate = "";
        String tToDate = "";
        String tActivity = "";
        String tTarget = "";
        String tBankCode = "";
        String tExternalRef = "";
        NumberSeries nb = new NumberSeries(7, this.getUser());
        try {
            tInvoiceDate = Config.localDateToString((LocalDate)this.postingDate.getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tInvoiceNo.isEmpty()) {
            tInvoiceNo = nb.getNextNumber();
            isNew = true;
        }
        try {
            tProjectCode = ((Project)this.project.getValue()).getProjectId();
        }
        catch (Exception u) {
            tProjectCode = "";
        }
        try {
            tRegion = ((Region)this.region.getValue()).getId() + "";
        }
        catch (Exception u) {
            tRegion = "";
        }
        try {
            tStaff = ((Employee)this.staff.getValue()).getEmployeeNumber().trim();
        }
        catch (Exception u) {
            tStaff = "";
        }
        try {
            tPurpose = this.purposeOfImprest.getText().trim();
        }
        catch (Exception u) {
            tPurpose = "";
        }
        try {
            tFromDate = Config.localDateToString((LocalDate)this.fromDate.getValue());
        }
        catch (Exception i) {
            tFromDate = "";
        }
        try {
            tToDate = Config.localDateToString((LocalDate)this.toDate.getValue());
        }
        catch (Exception i) {
            tToDate = "";
        }
        try {
            tActivity = this.activity.getHtmlText().trim();
        }
        catch (Exception i) {
            tActivity = "";
        }
        try {
            tTarget = this.target.getHtmlText().trim();
        }
        catch (Exception i) {
            tTarget = "";
        }
        try {
            tBankCode = ((Bank)this.payingBank.getValue()).getCode() + "";
        }
        catch (Exception u) {
            tBankCode = "";
        }
        try {
            tExternalRef = this.externalRefNo.getText().trim();
        }
        catch (Exception t) {
            tExternalRef = "";
        }
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("invoiceNo", tInvoiceNo);
        params.put("customer", tCustomerNo);
        params.put("invoiceDate", tInvoiceDate);
        params.put("shopLocationCode", 0);
        params.put("projectCode", tProjectCode);
        params.put("region", tRegion);
        params.put("salesRep", tSalesRep);
        params.put("document_type", "imprest");
        params.put("staff", tStaff);
        params.put("purpose", tPurpose);
        params.put("fromDate", tFromDate);
        params.put("toDate", tToDate);
        params.put("activity", tActivity);
        params.put("target", tTarget);
        params.put("bankCode", tBankCode);
        params.put("externalRef", tExternalRef);
        String response = Config.loadDataFromPhp("mastercreate?type=customerinvoice", params, this.getUser());
        Gson g = new Gson();
        JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
        if (jr.isStatus() && isNew) {
            this.imprestNo.setText(tInvoiceNo);
            nb.updateLastUsed(tInvoiceNo);
        }
        this.notificationPane.setText(jr.getMessage());
        this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
        this.notificationPane.show();
        return jr.isStatus();
    }

    public void loadInvoiceLines() {
        String tInvoiceNo = this.imprestNo.getText().trim();
        ObservableList<SalesLines> allLines = new SalesLines().getAllLines(tInvoiceNo, "", this.getUser());
        this.allItems.setItems(allLines);
        double tTotalExVAT = 0.0;
        double tTotalVAT = 0.0;
        double tTotal = 0.0;
        for (SalesLines cil : allLines) {
            tTotalExVAT += cil.getTotalExclVAT();
            tTotalVAT += cil.getTotalVAT();
            tTotal += cil.getTotalAmount();
        }
        this.totalCost.setText(Config.formatNumber(tTotal));
    }
}

