/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.InterestLine;
import classes.InterestVoucher;
import classes.JsonResponses;
import classes.Month;
import classes.NumberSeries;
import classes.User;
import classes.Year;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.control.NotificationPane;

public class InterestCardController
implements Initializable {
    private User user;
    private InterestVoucher voucher;
    @FXML
    NotificationPane notificationPane;
    @FXML
    private TableView<InterestLine> allEntries;
    @FXML
    private TableColumn loanNo;
    @FXML
    private TableColumn memberNo;
    @FXML
    private TableColumn memberName;
    @FXML
    private TableColumn loanProduct;
    @FXML
    private TableColumn amountIssued;
    @FXML
    private TableColumn loanBalance;
    @FXML
    private TableColumn interest;
    @FXML
    private JFXButton post;
    @FXML
    private JFXButton save;
    @FXML
    private JFXButton delete;
    @FXML
    private Label voucherNo;
    @FXML
    private Label createdOn;
    @FXML
    private ComboBox<Month> month;
    @FXML
    private ComboBox<Year> year;
    @FXML
    private Label voucherTotal;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public InterestVoucher getVoucher() {
        return this.voucher;
    }

    public void setVoucher(InterestVoucher voucher) {
        this.voucher = voucher;
        this.voucherNo.setText(voucher.getVoucherNo());
        this.createdOn.setText(voucher.getCreatedOn());
        this.month.setValue((Object)voucher.getMonth());
        this.year.setValue((Object)voucher.getYear());
        this.voucherTotal.setText(voucher.getTotalInterestString());
        this.loadLines();
        if (voucher.isPosted()) {
            this.delete.setDisable(true);
            this.save.setDisable(true);
            this.post.setDisable(true);
            this.month.setDisable(true);
            this.year.setDisable(true);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.loanNo.setCellValueFactory((Callback)new PropertyValueFactory("loanNo"));
        this.memberNo.setCellValueFactory((Callback)new PropertyValueFactory("memberNo"));
        this.memberName.setCellValueFactory((Callback)new PropertyValueFactory("memberName"));
        this.loanProduct.setCellValueFactory((Callback)new PropertyValueFactory("loanProduct"));
        this.amountIssued.setCellValueFactory((Callback)new PropertyValueFactory("amountIssued"));
        this.loanBalance.setCellValueFactory((Callback)new PropertyValueFactory("loanBalance"));
        this.interest.setCellValueFactory((Callback)new PropertyValueFactory("interestString"));
        this.save.setOnAction(e -> this.save());
        this.month.setItems(new Month().getAllMonths());
        this.year.setItems(new Year().getAllYears(this.getUser()));
        this.notificationPane.setContent(this.allEntries);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.delete.setOnAction(e -> {
            try {
                String tVoucherNo = this.voucherNo.getText().trim();
                if (tVoucherNo.equals(null) || tVoucherNo.equals("")) {
                    Stage stage = (Stage)this.delete.getScene().getWindow();
                    stage.close();
                }
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("voucherNo", tVoucherNo);
                Gson g = new Gson();
                String response2 = Config.loadDataFromPhp("masterdelete?type=interestvoucher", params, this.getUser());
                JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                if (myResponse.isStatus()) {
                    Stage stage = (Stage)this.delete.getScene().getWindow();
                    stage.close();
                }
                this.notificationPane.setText(myResponse.getMessage());
                this.notificationPane.setGraphic((Node)myResponse.getIconFromStatus());
                this.notificationPane.show();
            }
            catch (NullPointerException t) {
                Stage stage = (Stage)this.delete.getScene().getWindow();
                stage.close();
            }
            catch (Exception t) {
                this.notificationPane.setText("We encountered an error while deleting the interest voucher. Please try again later");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
        this.post.setOnAction(e -> {
            if (this.save()) {
                try {
                    String tVoucherNo = this.voucherNo.getText().trim();
                    if (tVoucherNo.equals(null) || tVoucherNo.equals("")) {
                        Stage stage = (Stage)this.delete.getScene().getWindow();
                        stage.close();
                    }
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("voucherNo", tVoucherNo);
                    Gson g = new Gson();
                    String response2 = Config.loadDataFromPhp("masterpost?type=interestvoucher", params, this.getUser());
                    JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                    if (myResponse.isStatus()) {
                        Stage stage = (Stage)this.delete.getScene().getWindow();
                        stage.close();
                    }
                    this.notificationPane.setText(myResponse.getMessage());
                    this.notificationPane.setGraphic((Node)myResponse.getIconFromStatus());
                    this.notificationPane.show();
                }
                catch (NullPointerException t) {
                    Stage stage = (Stage)this.delete.getScene().getWindow();
                    stage.close();
                }
                catch (Exception t) {
                    this.notificationPane.setText("We encountered an error while posting the interest voucher. Please try again later");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
            }
        });
    }

    public boolean save() {
        int tMonthCode = 0;
        int tYear = 0;
        boolean error = false;
        String message = "";
        try {
            tMonthCode = ((Month)this.month.getValue()).getCode();
        }
        catch (Exception y) {
            error = true;
            message = "Please select the month";
        }
        try {
            tYear = ((Year)this.year.getValue()).getYear();
        }
        catch (Exception y) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the year";
        }
        if (error) {
            this.notificationPane.setText(message);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        } else {
            try {
                String tVoucherNo = "";
                NumberSeries ns = new NumberSeries(13, this.getUser());
                boolean newVoucher = false;
                try {
                    tVoucherNo = this.voucherNo.getText().trim();
                    if (tVoucherNo.equals("") || tVoucherNo.equals(null)) {
                        throw new Exception();
                    }
                }
                catch (Exception t) {
                    tVoucherNo = ns.getNextNumber();
                    newVoucher = true;
                }
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("voucherNo", tVoucherNo);
                params.put("month", tMonthCode);
                params.put("year", tYear);
                String response = Config.loadDataFromPhp("mastercreate?type=interestvoucher", params, this.getUser());
                System.out.println(response);
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                if (jr.isStatus()) {
                    if (newVoucher) {
                        this.createdOn.setText(jr.getOverLoad1());
                        this.voucherNo.setText(tVoucherNo);
                        ns.updateLastUsed(tVoucherNo);
                    }
                    this.loadLines();
                }
                return jr.isStatus();
            }
            catch (Exception t) {
                this.notificationPane.setText("We encountered an error while processing your request. Please try again. ");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
        return false;
    }

    public void loadLines() {
        String tVoucherNo = this.voucherNo.getText().trim();
        if (!tVoucherNo.equals("")) {
            ObservableList<InterestLine> allLines = new InterestLine().getAllLines(tVoucherNo, this.getUser());
            this.allEntries.setItems(allLines);
            double total = 0.0;
            for (InterestLine line : allLines) {
                try {
                    total += line.getInterest();
                }
                catch (Exception exception) {}
            }
            this.voucherTotal.setText(Config.formatNumber(total));
        }
    }
}

