/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.InterestVoucher;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.InterestCardController;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class InterestVouchersController
implements Initializable {
    private User user;
    private boolean posted;
    @FXML
    private VBox root;
    @FXML
    private JFXButton createVoucher;
    @FXML
    private JFXButton editVoucher;
    @FXML
    private JFXButton refresh;
    @FXML
    private JFXButton viewVoucher;
    @FXML
    private JFXButton delete;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private StackPane stackpane;
    @FXML
    private TableView<InterestVoucher> allVouchers;
    @FXML
    private TableColumn voucherNo;
    @FXML
    private TableColumn period;
    @FXML
    private TableColumn createdOn;
    @FXML
    private TableColumn totalInterest;
    @FXML
    private TableColumn noOfLoans;
    @FXML
    private MaskerPane maskerPane;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public boolean isPosted() {
        return this.posted;
    }

    public void setPosted(boolean posted) {
        this.posted = posted;
        this.delete.setDisable(posted);
        this.createVoucher.setDisable(posted);
        this.loadItems();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane.setContent((Node)this.stackpane);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.voucherNo.setCellValueFactory((Callback)new PropertyValueFactory("voucherNo"));
        this.period.setCellValueFactory((Callback)new PropertyValueFactory("period"));
        this.createdOn.setCellValueFactory((Callback)new PropertyValueFactory("createdOn"));
        this.totalInterest.setCellValueFactory((Callback)new PropertyValueFactory("totalInterestString"));
        this.noOfLoans.setCellValueFactory((Callback)new PropertyValueFactory("noOfLoans"));
        this.refresh.setOnAction(e -> this.loadItems());
        this.viewVoucher.setOnAction(e -> {
            try {
                InterestVoucher voucher = (InterestVoucher)this.allVouchers.getSelectionModel().getSelectedItem();
                LinkedHashMap<String, Object> dataVariables = new LinkedHashMap<String, Object>();
                dataVariables.put("voucherNo", voucher.getVoucherNo());
                LinkedHashMap<String, Object> reportVariables = new LinkedHashMap<String, Object>();
                new Config().getReport("View Interest Voucher", "masterfetch?type=interestline", dataVariables, "interest.jasper", reportVariables, this.getUser());
            }
            catch (NullPointerException voucher) {
            }
            catch (Exception y) {
                this.notificationPane.setText("We encountered an error while processing your request. Please try again later.");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
        this.delete.setOnAction(e -> {
            try {
                InterestVoucher voucher = (InterestVoucher)this.allVouchers.getSelectionModel().getSelectedItem();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("voucherNo", voucher.getVoucherNo());
                Gson g = new Gson();
                String response2 = Config.loadDataFromPhp("masterdelete?type=interestvoucher", params, this.getUser());
                JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                if (myResponse.isStatus()) {
                    this.loadItems();
                }
                this.notificationPane.setText(myResponse.getMessage());
                this.notificationPane.setGraphic((Node)myResponse.getIconFromStatus());
                this.notificationPane.show();
            }
            catch (NullPointerException voucher) {
            }
            catch (Exception t) {
                this.notificationPane.setText("We encountered an error while deleting the interest voucher. Please try again later");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
        this.createVoucher.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/interestCard.fxml").openStream());
                InterestCardController controller = (InterestCardController)loader.getController();
                controller.setUser(this.getUser());
                Scene scene = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(scene);
                stage.setResizable(false);
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.setTitle("Create Interest Voucher");
                stage.show();
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                InterestVouchersController.this.loadItems();
                            }
                        });
                    }
                });
            }
            catch (Exception j) {
                j.printStackTrace();
            }
        });
        this.allVouchers.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    InterestVoucher rowData = (InterestVoucher)row.getItem();
                    InterestVoucher voucher = (InterestVoucher)this.allVouchers.getSelectionModel().getSelectedItem();
                    if (!voucher.equals(null)) {
                        this.editVoucher(voucher);
                    }
                }
            });
            return row;
        });
        this.editVoucher.setOnAction(r -> {
            try {
                InterestVoucher xm = (InterestVoucher)this.allVouchers.getSelectionModel().getSelectedItem();
                if (!xm.equals(null) && !xm.getVoucherNo().equals("")) {
                    this.editVoucher(xm);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
    }

    public void loadItems() {
        Platform.runLater(() -> {
            this.maskerPane.setVisible(true);
            ObservableList<InterestVoucher> myVouchers = new InterestVoucher().getAllVouchers(this.isPosted(), this.getUser());
            this.allVouchers.setItems(myVouchers);
            this.maskerPane.setVisible(false);
        });
    }

    public void editVoucher(InterestVoucher voucher) {
        try {
            FXMLLoader loader = new FXMLLoader();
            AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/interestCard.fxml").openStream());
            Scene scene = new Scene((Parent)itemPane, 1065.0, 668.0);
            final Stage stage = new Stage();
            scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(scene);
            InterestCardController controller = (InterestCardController)loader.getController();
            controller.setVoucher(voucher);
            stage.setTitle("Edit Interest Voucher");
            stage.setResizable(false);
            try {
                stage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            InterestVouchersController.this.loadItems();
                        }
                    });
                }
            });
            stage.showAndWait();
        }
        catch (Exception p) {
            p.printStackTrace();
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while loading your edit interest voucher screen. Please contact support");
            alert.showAndWait();
        }
    }
}

