/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Account;
import classes.Bank;
import classes.Config;
import classes.Customer;
import classes.FixedAssets;
import classes.Investment;
import classes.Journal;
import classes.JournalLines;
import classes.JsonResponses;
import classes.Loan;
import classes.Member;
import classes.NumberSeries;
import classes.ShopItem;
import classes.TransactionTypes;
import classes.User;
import classes.Vehicle;
import classes.Vendor;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.GeneralListController;
import java.io.File;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class JournalCardController
implements Initializable {
    private User user;
    private Journal journal;
    @FXML
    private Label journalNo;
    @FXML
    private DatePicker journalDate;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private TitledPane journalLines;
    @FXML
    private ComboBox<String> accountType;
    @FXML
    private ComboBox account;
    @FXML
    private Button search;
    @FXML
    private Button uploadEntries;
    @FXML
    private ComboBox<TransactionTypes> transactionType;
    @FXML
    private TextField externalDocNo;
    @FXML
    private TextField description;
    @FXML
    private TextField amount;
    @FXML
    private JFXButton addLine;
    @FXML
    private TableView<JournalLines> allLines;
    @FXML
    private TableColumn colAccountType;
    @FXML
    private TableColumn colAccountNo;
    @FXML
    private TableColumn colAccountName;
    @FXML
    private TableColumn colTransactionType;
    @FXML
    private TableColumn colExternalDocNo;
    @FXML
    private TableColumn colDescription;
    @FXML
    private TableColumn colRemove;
    @FXML
    private TableColumn colDebit;
    @FXML
    private TableColumn colCredit;
    @FXML
    private JFXButton cancel;
    @FXML
    private JFXButton post;
    @FXML
    private JFXButton save;
    @FXML
    private JFXButton reverse;
    @FXML
    private Label totalAmount;
    public static Label totalAmountPublic = new Label();
    public static TableView<JournalLines> publicLines = new TableView();
    public static NotificationPane publicNotificationPane = new NotificationPane();

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Journal getJournal() {
        return this.journal;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
        this.journalNo.setText(journal.getJournalNo());
        try {
            this.journalDate.setValue((Object)Config.stringToLocalDate(journal.getTransactionDate()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (journal.isPosted()) {
            this.addLine.setDisable(true);
            this.post.setDisable(true);
            this.save.setDisable(true);
            this.reverse.setDisable(false);
            this.allLines.setDisable(true);
        }
        if (journal.isReversed()) {
            this.reverse.setDisable(true);
            this.allLines.setDisable(true);
        }
        this.loadLines();
    }

    public void initialize(URL location, ResourceBundle resources) {
        totalAmountPublic = this.totalAmount;
        publicLines = this.allLines;
        publicNotificationPane = this.notificationPane;
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.journalLines);
        new ValidationSupport().registerValidator((Control)this.journalDate, Validator.createEmptyValidator((String)"Required"));
        new ValidationSupport().registerValidator((Control)this.description, Validator.createEmptyValidator((String)"Required"));
        new ValidationSupport().registerValidator((Control)this.amount, Validator.createEmptyValidator((String)"Required"));
        new ValidationSupport().registerValidator(this.accountType, Validator.createEmptyValidator((String)"Required"));
        new ValidationSupport().registerValidator((Control)this.account, Validator.createEmptyValidator((String)"Required"));
        new ValidationSupport().registerValidator((Control)this.amount, Validator.createEmptyValidator((String)"Required"));
        this.amount = new Config().setDoubleTextField(this.amount);
        this.colAccountType.setCellValueFactory((Callback)new PropertyValueFactory("accountType"));
        this.colAccountNo.setCellValueFactory((Callback)new PropertyValueFactory("accountNo"));
        this.colAccountName.setCellValueFactory((Callback)new PropertyValueFactory("accountName"));
        this.colTransactionType.setCellValueFactory((Callback)new PropertyValueFactory("transactionType"));
        this.colExternalDocNo.setCellValueFactory((Callback)new PropertyValueFactory("externalDocNo"));
        this.colDescription.setCellValueFactory((Callback)new PropertyValueFactory("description"));
        this.colRemove.setCellValueFactory((Callback)new PropertyValueFactory("remove"));
        this.colDebit.setCellValueFactory((Callback)new PropertyValueFactory("debit"));
        this.colCredit.setCellValueFactory((Callback)new PropertyValueFactory("credit"));
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
        this.save.setOnAction(e -> this.save());
        this.post.setOnAction(e -> this.post());
        this.addLine.setOnAction(e -> this.addLine());
        this.reverse.setOnAction(e -> this.reverse());
        Platform.runLater(() -> {
            String response = Config.loadDataFromPhp("masterfetch?type=journalaccounttypes", new LinkedHashMap<String, Object>(), this.getUser());
            this.accountType.setItems(FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, String[].class))));
        });
        this.accountType.setOnAction(e -> {
            Task<Void> task1 = new Task<Void>(){

                public Void call() {
                    Platform.runLater(() -> {
                        JournalCardController.this.notificationPane.setText("Loading Values, Please wait");
                        JournalCardController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                        JournalCardController.this.notificationPane.show();
                    });
                    try {
                        String tAccountType = (String)JournalCardController.this.accountType.getValue();
                        JournalCardController.this.transactionType.setItems(new TransactionTypes().getTransactionTypesPerAccountType(tAccountType, JournalCardController.this.getUser()));
                        switch (tAccountType) {
                            case "bank": {
                                JournalCardController.this.account.setItems(Bank.getAllBanks(JournalCardController.this.getUser()));
                                Platform.runLater(() -> JournalCardController.this.notificationPane.hide());
                                return null;
                            }
                            case "customer": {
                                JournalCardController.this.account.setItems(new Customer().getAllCustomers(JournalCardController.this.getUser()));
                                Platform.runLater(() -> JournalCardController.this.notificationPane.hide());
                                return null;
                            }
                            case "vendor": {
                                JournalCardController.this.account.setItems(new Vendor().getAllVendors(JournalCardController.this.getUser()));
                                Platform.runLater(() -> JournalCardController.this.notificationPane.hide());
                                return null;
                            }
                            case "member": {
                                JournalCardController.this.account.setItems(new Member().getAllMembers(JournalCardController.this.getUser()));
                                Platform.runLater(() -> JournalCardController.this.notificationPane.hide());
                                return null;
                            }
                            case "vehicle": {
                                JournalCardController.this.account.setItems(new Vehicle().getAllVehicles(JournalCardController.this.getUser()));
                                Platform.runLater(() -> JournalCardController.this.notificationPane.hide());
                                return null;
                            }
                            case "glaccount": {
                                JournalCardController.this.account.setItems(Account.getAccounts(JournalCardController.this.getUser()));
                                Platform.runLater(() -> JournalCardController.this.notificationPane.hide());
                                return null;
                            }
                            case "loan": {
                                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                                params.put("issued", 1);
                                JournalCardController.this.account.setItems(new Loan().getAllLoans(params, JournalCardController.this.getUser()));
                                Platform.runLater(() -> JournalCardController.this.notificationPane.hide());
                                return null;
                            }
                            case "investment": {
                                JournalCardController.this.account.setItems(new Investment().getAllInvestments(JournalCardController.this.getUser()));
                                Platform.runLater(() -> JournalCardController.this.notificationPane.hide());
                                return null;
                            }
                            case "fixedasset": {
                                JournalCardController.this.account.setItems(new FixedAssets().getAllAssets(JournalCardController.this.getUser()));
                                Platform.runLater(() -> JournalCardController.this.notificationPane.hide());
                                return null;
                            }
                            case "item": {
                                JournalCardController.this.account.setItems(new ShopItem().getAllItems(JournalCardController.this.getUser()));
                                Platform.runLater(() -> JournalCardController.this.notificationPane.hide());
                                return null;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Platform.runLater(() -> JournalCardController.this.notificationPane.hide());
                    return null;
                }
            };
            Thread backgroundThread = new Thread((Runnable)task1);
            backgroundThread.setDaemon(true);
            backgroundThread.start();
            Thread thread1 = new Thread((Runnable)task1);
            thread1.setDaemon(true);
            thread1.start();
        });
        this.search.setOnAction(e -> {
            try {
                String tAccountType = (String)this.accountType.getValue();
                if (tAccountType.length() < 1) {
                    return;
                }
                String options = new Gson().toJson((Object)this.account.getItems());
                String mySelection = new Config().getObjectFromSelection(tAccountType, options, this.getUser());
                if (mySelection.trim().length() < 1) {
                    return;
                }
                switch (tAccountType) {
                    case "bank": {
                        this.account.setValue(new Gson().fromJson(mySelection, Bank.class));
                        return;
                    }
                    case "customer": {
                        this.account.setValue(new Gson().fromJson(mySelection, Customer.class));
                        return;
                    }
                    case "vendor": {
                        this.account.setValue(new Gson().fromJson(mySelection, Vendor.class));
                        return;
                    }
                    case "member": {
                        this.account.setValue(new Gson().fromJson(mySelection, Member.class));
                        return;
                    }
                    case "vehicle": {
                        this.account.setValue(new Gson().fromJson(mySelection, Vehicle.class));
                        return;
                    }
                    case "glaccount": {
                        this.account.setValue(new Gson().fromJson(mySelection, Account.class));
                        return;
                    }
                    case "loan": {
                        this.account.setValue(new Gson().fromJson(mySelection, Loan.class));
                        return;
                    }
                    case "investment": {
                        this.account.setValue(new Gson().fromJson(mySelection, Investment.class));
                        return;
                    }
                    case "fixedasset": {
                        this.account.setValue(new Gson().fromJson(mySelection, FixedAssets.class));
                        return;
                    }
                    case "item": {
                        this.account.setValue(new Gson().fromJson(mySelection, ShopItem.class));
                        return;
                    }
                }
            }
            catch (NullPointerException t) {
                this.notificationPane.setText("Please select an account type");
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
            catch (Exception t) {
                t.printStackTrace();
                this.notificationPane.setText("We encountered an error while processing your request. Please try again");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
        this.uploadEntries.setOnAction(e -> {
            if (this.save()) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FileChooser chooser = new FileChooser();
                        chooser.setTitle("Select Excel to Import Entries From");
                        chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Excel Files", new String[]{"*.xlsx", "*.csv"})});
                        try {
                            File file = chooser.showOpenDialog((Window)new Stage());
                            if (file != null) {
                                XSSFWorkbook wb = new XSSFWorkbook(file);
                                final XSSFSheet ws = wb.getSheetAt(0);
                                Task<Void> task1 = new Task<Void>(){

                                    public Void call() {
                                        int noOfRecords = ws.getPhysicalNumberOfRows();
                                        Platform.runLater(() -> {});
                                        for (int b = 1; b < noOfRecords; ++b) {
                                            int c = b;
                                            this.updateProgress(c + 1, noOfRecords);
                                            Platform.runLater(() -> {});
                                            XSSFRow myRow = ws.getRow(b);
                                            try {
                                                Cell myCell;
                                                String tAccountType = "";
                                                String tAccountNo = "";
                                                String tTransactionType = "";
                                                String tExternalDocNo = "";
                                                String tDescription = "";
                                                String tMemberNo = "";
                                                String tVehicle = "";
                                                double tAmount = 0.0;
                                                double tLocation = 0.0;
                                                double tQuantity = 0.0;
                                                try {
                                                    myCell = myRow.getCell(0);
                                                    tAccountType = myCell.toString();
                                                }
                                                catch (Exception t) {
                                                    tAccountType = "";
                                                }
                                                try {
                                                    myCell = myRow.getCell(1);
                                                    String tAccountNoDetails = myCell.toString().trim();
                                                    try {
                                                        Double.parseDouble(tAccountNoDetails);
                                                        tAccountNo = Config.formatNumber(myCell.getNumericCellValue()).replace(",", "");
                                                    }
                                                    catch (Exception u) {
                                                        tAccountNo = tAccountNoDetails;
                                                    }
                                                }
                                                catch (Exception myCell2) {
                                                    // empty catch block
                                                }
                                                try {
                                                    myCell = myRow.getCell(3);
                                                    String tTransTypeDetails = myCell.toString().trim();
                                                    try {
                                                        Double.parseDouble(tTransTypeDetails);
                                                        tTransactionType = Config.formatNumber(myCell.getNumericCellValue()).replace(",", "");
                                                    }
                                                    catch (Exception u) {
                                                        tTransactionType = tTransTypeDetails;
                                                    }
                                                }
                                                catch (Exception myCell3) {
                                                    // empty catch block
                                                }
                                                try {
                                                    myCell = myRow.getCell(4);
                                                    String tExternalDetails = myCell.toString().trim();
                                                    try {
                                                        Double.parseDouble(tExternalDetails);
                                                        tExternalDocNo = Config.formatNumber(myCell.getNumericCellValue()).replace(",", "");
                                                    }
                                                    catch (Exception u) {
                                                        tExternalDocNo = tExternalDetails;
                                                    }
                                                }
                                                catch (Exception myCell4) {
                                                    // empty catch block
                                                }
                                                try {
                                                    myCell = myRow.getCell(5);
                                                    tDescription = myCell.toString();
                                                }
                                                catch (Exception t) {
                                                    tDescription = "";
                                                }
                                                try {
                                                    myCell = myRow.getCell(6);
                                                    tAmount = myCell.getNumericCellValue();
                                                }
                                                catch (Exception t) {
                                                    tAmount = 0.0;
                                                }
                                                try {
                                                    myCell = myRow.getCell(7);
                                                    tMemberNo = myCell.toString();
                                                }
                                                catch (Exception t) {
                                                    tMemberNo = "";
                                                }
                                                try {
                                                    myCell = myRow.getCell(8);
                                                    tVehicle = myCell.toString();
                                                }
                                                catch (Exception t) {
                                                    tVehicle = "";
                                                }
                                                try {
                                                    myCell = myRow.getCell(9);
                                                    tQuantity = myCell.getNumericCellValue();
                                                }
                                                catch (Exception t) {
                                                    tQuantity = 0.0;
                                                }
                                                try {
                                                    myCell = myRow.getCell(10);
                                                    tLocation = myCell.getNumericCellValue();
                                                }
                                                catch (Exception t) {
                                                    tLocation = 0.0;
                                                }
                                                LinkedHashMap<String, Object> params2 = new LinkedHashMap<String, Object>();
                                                params2.put("journalNo", JournalCardController.this.journalNo.getText().trim());
                                                params2.put("accountType", tAccountType);
                                                params2.put("accountNo", tAccountNo);
                                                params2.put("transactionType", tTransactionType);
                                                params2.put("externalDoc", tExternalDocNo);
                                                params2.put("description", tDescription);
                                                params2.put("amount", tAmount);
                                                params2.put("memberNo", tMemberNo);
                                                params2.put("vehicle", tVehicle);
                                                params2.put("quantity", tQuantity);
                                                params2.put("location", tLocation);
                                                String response2 = Config.loadDataFromPhp("mastercreate?type=journalline", params2, JournalCardController.this.getUser());
                                                System.out.println(response2);
                                                continue;
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                        JournalCardController.this.loadLines();
                                        return null;
                                    }
                                };
                                Thread backgroundThread = new Thread((Runnable)task1);
                                backgroundThread.setDaemon(true);
                                backgroundThread.start();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        });
    }

    public boolean save() {
        try {
            String tJournalNo = this.journalNo.getText().trim();
            String tDate = "";
            boolean newJournal = false;
            NumberSeries ns = new NumberSeries(45, this.getUser());
            if (tJournalNo.length() < 1) {
                newJournal = true;
                tJournalNo = ns.getNextNumber();
            }
            try {
                tDate = Config.localDateToString((LocalDate)this.journalDate.getValue());
            }
            catch (Exception t) {
                tDate = "";
            }
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("journalNo", tJournalNo);
            params.put("date", tDate);
            String response = Config.loadDataFromPhp("mastercreate?type=journal", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            if (jr.isStatus() && newJournal) {
                this.journalNo.setText(tJournalNo);
                ns.updateLastUsed(tJournalNo);
            }
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
            return jr.isStatus();
        }
        catch (Exception r) {
            this.notificationPane.setText("We encountered an error while processing your request. Please try again.");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
            return false;
        }
    }

    public void addLine() {
        if (this.save()) {
            String tJournalNo = this.journalNo.getText().trim();
            String tAccountType = "";
            String accountNo = "";
            String tTransactionType = "";
            String tExternalDoc = "";
            String tDescription = "";
            double tAmount = 0.0;
            boolean error = false;
            String message = "";
            try {
                block29: {
                    tAccountType = ((String)this.accountType.getValue()).trim();
                    if (tAccountType.length() > 0) {
                        try {
                            if (tAccountType.equalsIgnoreCase("bank")) {
                                Bank bank = (Bank)this.account.getValue();
                                accountNo = bank.getCode() + "";
                                break block29;
                            }
                            if (tAccountType.equalsIgnoreCase("customer")) {
                                Customer customer = (Customer)this.account.getValue();
                                accountNo = customer.getCustomerNumber();
                                break block29;
                            }
                            if (tAccountType.equalsIgnoreCase("vendor")) {
                                Vendor vendor = (Vendor)this.account.getValue();
                                accountNo = vendor.getVendorNumber();
                                break block29;
                            }
                            if (tAccountType.equalsIgnoreCase("member")) {
                                Member member = (Member)this.account.getValue();
                                accountNo = member.getMemberNumber();
                                break block29;
                            }
                            if (tAccountType.equalsIgnoreCase("vehicle")) {
                                Vehicle vehicle = (Vehicle)this.account.getValue();
                                accountNo = vehicle.getRegNo();
                                break block29;
                            }
                            if (tAccountType.equalsIgnoreCase("glaccount")) {
                                Account glAccount = (Account)this.account.getValue();
                                accountNo = glAccount.getAccountNumber();
                                break block29;
                            }
                            if (tAccountType.equalsIgnoreCase("loan")) {
                                Loan loan = (Loan)this.account.getValue();
                                accountNo = loan.getLoanNumber();
                                break block29;
                            }
                            if (tAccountType.equalsIgnoreCase("investment")) {
                                Investment investment = (Investment)this.account.getValue();
                                accountNo = investment.getInvestmentNo();
                                break block29;
                            }
                            if (tAccountType.equalsIgnoreCase("fixedasset")) {
                                FixedAssets fixedAssets = (FixedAssets)this.account.getValue();
                                accountNo = fixedAssets.getAssetNo();
                                break block29;
                            }
                            if (tAccountType.equalsIgnoreCase("item")) {
                                ShopItem shopItem = (ShopItem)this.account.getValue();
                                accountNo = shopItem.getCode();
                                break block29;
                            }
                            error = true;
                            message = "Unknown account type";
                        }
                        catch (Exception y) {
                            error = true;
                            message = "Please select an account to add a line";
                        }
                    } else {
                        error = true;
                        message = "Please select the account type";
                    }
                }
                try {
                    tTransactionType = ((TransactionTypes)this.transactionType.getValue()).getTransactionTypeCode();
                }
                catch (Exception t) {
                    tTransactionType = "";
                }
                try {
                    tExternalDoc = this.externalDocNo.getText().trim();
                }
                catch (Exception t) {
                    tExternalDoc = "";
                }
                try {
                    tDescription = this.description.getText().trim();
                    if (tDescription.length() < 1) {
                        throw new Exception();
                    }
                }
                catch (Exception t) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please enter some description";
                }
                try {
                    tAmount = Double.parseDouble(this.amount.getText().trim());
                }
                catch (Exception t) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please enter a valid value for amount";
                }
            }
            catch (Exception t) {
                error = true;
                message = "Please select an account type to add a line";
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            } else {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("journalNo", tJournalNo);
                params.put("accountType", tAccountType);
                params.put("accountNo", accountNo);
                params.put("transactionType", tTransactionType);
                params.put("externalDoc", tExternalDoc);
                params.put("description", tDescription);
                params.put("amount", tAmount);
                String response = Config.loadDataFromPhp("mastercreate?type=journalline", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    this.loadLines();
                    this.description.setText("");
                    this.amount.setText("");
                }
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
            }
        }
    }

    public void post() {
        if (this.save()) {
            boolean error = false;
            String message = "";
            try {
                String string = Config.localDateToString((LocalDate)this.journalDate.getValue());
            }
            catch (Exception t) {
                error = true;
                message = "Please enter a valid value for date";
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            } else {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("journalNo", this.journalNo.getText().trim());
                String response = Config.loadDataFromPhp("masterpost?type=journal", params, this.getUser());
                System.out.println(response);
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    GeneralListController.publicNotificationPane.setText(jr.getMessage());
                    GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                    GeneralListController.publicNotificationPane.show();
                    Stage stage = (Stage)this.post.getScene().getWindow();
                    stage.close();
                } else {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
        }
    }

    public void reverse() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("journalNo", this.journalNo.getText().trim());
        String response = Config.loadDataFromPhp("masterpost?type=reversejournal", params, this.getUser());
        JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
        if (jr.isStatus()) {
            GeneralListController.publicNotificationPane.setText(jr.getMessage());
            GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
            GeneralListController.publicNotificationPane.show();
            Stage stage = (Stage)this.post.getScene().getWindow();
            stage.close();
        } else {
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
        }
    }

    public void loadLines() {
        try {
            ObservableList<JournalLines> myLines = new JournalLines().loadLines(this.journalNo.getText().trim(), this.getUser());
            this.allLines.setItems(myLines);
            double tTotalAmount = 0.0;
            for (JournalLines line : myLines) {
                tTotalAmount += line.getAmount();
            }
            double finalTTotalAmount = tTotalAmount;
            Platform.runLater(() -> this.totalAmount.setText(Config.formatNumber(finalTTotalAmount)));
        }
        catch (Exception y) {
            this.notificationPane.setText("We encountered an error while loading the journal lines");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
    }
}

