/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.Employee;
import classes.JsonResponses;
import classes.LeaveBalance;
import classes.User;
import com.google.gson.Gson;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class LeaveAllocation
implements Initializable {
    private User user;
    @FXML
    private TableColumn employeeNo;
    @FXML
    private TableColumn employeeName;
    @FXML
    private TableColumn leaveBalances;
    @FXML
    private MaskerPane maskerPane;
    @FXML
    private VBox vbLeaveAllocation;
    @FXML
    private VBox vbHolder;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private Button btnRefresh;
    @FXML
    private ComboBox<Employee> cbEmployee;
    @FXML
    private TextField tfNoOfDays;
    @FXML
    private Button btnAddDay;
    @FXML
    private TableView<LeaveBalance> tvLeaveBalance;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        Platform.runLater(() -> {
            this.cbEmployee.setItems(new Employee().getAllEmployees(this.getUser()));
            this.employeeNo.setCellValueFactory((Callback)new PropertyValueFactory("employeeNo"));
            this.employeeName.setCellValueFactory((Callback)new PropertyValueFactory("employee"));
            this.leaveBalances.setCellValueFactory((Callback)new PropertyValueFactory("balance"));
            this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.vbHolder);
            Config.setInputTypeNum(new TextField[]{this.tfNoOfDays});
            this.vbHolder.prefWidthProperty().bind((ObservableValue)this.vbLeaveAllocation.widthProperty().multiply(0.91));
            this.vbHolder.prefHeightProperty().bind((ObservableValue)this.vbLeaveAllocation.heightProperty().multiply(0.89));
            this.tvLeaveBalance.prefWidthProperty().bind((ObservableValue)this.vbHolder.widthProperty());
            this.refreshData(this.getUser());
        });
    }

    @FXML
    void addDay(ActionEvent event) {
        Employee employee = null;
        String noOfDays = "";
        String errorMessage = "";
        boolean error = false;
        try {
            employee = (Employee)this.cbEmployee.getValue();
            if (employee == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage + "Select a valid employee";
        }
        try {
            noOfDays = this.tfNoOfDays.getText().trim();
            if (noOfDays.equals("")) {
                throw new Exception();
            }
            int days = Integer.parseInt(noOfDays);
            if (days <= 0) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage + "Select a valid employee";
        }
        if (error) {
            this.notificationPane.setText(errorMessage);
            this.notificationPane.show();
        } else {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("employee", employee.getEmployeeNumber());
            params.put("noOfDays", noOfDays);
            String response = Config.loadDataFromPhp("mastercreate?type=leavebalance", params, this.getUser());
            System.out.println(response);
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.show();
            if (jr.isStatus()) {
                this.refreshData(this.getUser());
            }
        }
    }

    @FXML
    void refresh(ActionEvent event) {
        this.refreshData(this.getUser());
    }

    private void refreshData(User user) {
        this.maskerPane.setVisible(true);
        String response = Config.loadDataFromPhp("masterfetch?type=leavebalances", new LinkedHashMap<String, Object>(), user);
        Object[] myBalance = (LeaveBalance[])new Gson().fromJson(response, LeaveBalance[].class);
        this.tvLeaveBalance.setItems(FXCollections.observableArrayList((Object[])myBalance));
        this.tfNoOfDays.setText("");
        this.maskerPane.setVisible(false);
    }
}

