/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.Employee;
import classes.JsonResponses;
import classes.LeaveApplication;
import classes.LeaveType;
import classes.NumberSeries;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class LeaveApplicationForm
implements Initializable {
    private User user;
    @FXML
    private Button searchEmployee;
    @FXML
    private Button searchReliever;
    @FXML
    private Label labelId;
    @FXML
    private ComboBox<Employee> cbEmployee;
    @FXML
    private ComboBox<Employee> cbReliever;
    @FXML
    private ComboBox<LeaveType> cbLeaveType;
    @FXML
    private TextField tfPhoneNo;
    @FXML
    private DatePicker dpStartDate;
    @FXML
    private DatePicker dpReturnDate;
    @FXML
    private TextField tfNoOfDays;
    @FXML
    private Button btnCancel;
    @FXML
    private Button btnSave;
    @FXML
    private Button btnPost;
    @FXML
    private Button btnReverse;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox vbLeaveApplication;
    @FXML
    private HBox hbHolder;
    private LeaveApplication leaveApplication;

    public User getUser() {
        return this.user;
    }

    public void setUser(final User user) {
        this.user = user;
        Task task = new Task(){

            public Void call() {
                Platform.runLater(() -> {
                    LeaveApplicationForm.this.notificationPane.setText("Loading data, Please wait...");
                    LeaveApplicationForm.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    LeaveApplicationForm.this.notificationPane.show();
                });
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("exited", 0);
                ObservableList<Employee> allEmployees = new Employee().getAllEmployees(params, user);
                LeaveApplicationForm.this.cbEmployee.setItems(allEmployees);
                LeaveApplicationForm.this.cbReliever.setItems(allEmployees);
                LeaveApplicationForm.this.cbLeaveType.setItems(FXCollections.observableArrayList(LeaveType.getAllTypes(user)));
                Platform.runLater(() -> LeaveApplicationForm.this.notificationPane.hide());
                return null;
            }
        };
        Thread thread = new Thread((Runnable)task);
        thread.start();
        if (this.leaveApplication == null) {
            this.dpStartDate.setValue((Object)LocalDate.now());
            this.dpReturnDate.setValue((Object)LocalDate.now());
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.hbHolder);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.tfNoOfDays, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.cbEmployee, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.cbLeaveType, Validator.createEmptyValidator((String)"Required"));
        Config.setInputTypeNum(new TextField[]{this.tfPhoneNo, this.tfNoOfDays});
        this.dpReturnDate.setDisable(true);
        this.searchEmployee.setOnAction(e -> {
            try {
                String tEmployee = new Config().getObjectFromSelection("employee", this.getUser());
                Employee selectedEmployee = (Employee)new Gson().fromJson(tEmployee, Employee.class);
                selectedEmployee.getEmployeeNumber();
                this.cbEmployee.setValue((Object)selectedEmployee);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.searchReliever.setOnAction(e -> {
            try {
                String tEmployee = new Config().getObjectFromSelection("employee", this.getUser());
                Employee selectedEmployee = (Employee)new Gson().fromJson(tEmployee, Employee.class);
                selectedEmployee.getEmployeeNumber();
                this.cbReliever.setValue((Object)selectedEmployee);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.btnSave.setOnAction(event -> this.save());
        this.dpStartDate.setOnAction(e -> {
            try {
                LocalDate selectedDate = (LocalDate)this.dpStartDate.getValue();
                int days = Integer.parseInt(this.tfNoOfDays.getText().trim());
                LocalDate returnDate = selectedDate.plusDays(days);
                this.dpReturnDate.setValue((Object)returnDate);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.tfNoOfDays.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.equals("")) {
                try {
                    LeaveType leaveType = (LeaveType)this.cbLeaveType.getValue();
                    assert (leaveType != null);
                    int days = Integer.parseInt(newValue);
                    if (days > leaveType.getMaxDays()) {
                        this.tfNoOfDays.setText(oldValue == null ? "" : oldValue);
                    }
                    LocalDate localDate = (LocalDate)this.dpStartDate.getValue();
                    assert (localDate != null);
                    LocalDate returnDate = localDate.plusDays(days);
                    this.dpReturnDate.setValue((Object)returnDate);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @FXML
    void cancel(ActionEvent event) {
        this.close();
    }

    private void close() {
        Stage stage = (Stage)this.vbLeaveApplication.getScene().getWindow();
        stage.fireEvent(new Event(WindowEvent.WINDOW_CLOSE_REQUEST));
    }

    @FXML
    void post(ActionEvent event) {
        if (this.save()) {
            String id = this.labelId.getText();
            Employee e = (Employee)this.cbEmployee.getValue();
            String leaveDays = this.tfNoOfDays.getText();
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("id", id);
            params.put("employee", e.getEmployeeNumber());
            params.put("leaveDays", leaveDays);
            String response = Config.loadDataFromPhp("masterpost?type=leaveapplications", params, this.getUser());
            System.out.println(response);
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.show();
            if (jr.isStatus()) {
                GeneralListController.publicNotificationPane.setText(jr.getMessage());
                GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                GeneralListController.publicNotificationPane.show();
                this.close();
            }
        }
    }

    @FXML
    void reverse(ActionEvent event) {
        String id = this.labelId.getText();
        Employee e = (Employee)this.cbEmployee.getValue();
        String leaveDays = this.tfNoOfDays.getText();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("id", id);
        params.put("employee", e.getEmployeeNumber());
        params.put("leaveDays", leaveDays);
        String response = Config.loadDataFromPhp("masterpost?type=reverseleaveapplications", params, this.getUser());
        System.out.println(response);
        JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
        this.notificationPane.setText(jr.getMessage());
        this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
        this.notificationPane.show();
        if (jr.isStatus()) {
            GeneralListController.publicNotificationPane.setText(jr.getMessage());
            GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
            GeneralListController.publicNotificationPane.show();
            this.close();
        }
    }

    private boolean save() {
        String days = "";
        String phoneNo = "";
        String errorMessage = "";
        String startDate = "";
        String returnDate = "";
        String id = "";
        Employee employee = null;
        Employee reliever = null;
        LeaveType leaveType = null;
        NumberSeries ns = new NumberSeries(48, this.getUser());
        boolean error = false;
        try {
            employee = (Employee)this.cbEmployee.getValue();
            if (employee == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage + "Select a valid employee";
        }
        try {
            reliever = (Employee)this.cbReliever.getValue();
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage.concat(errorMessage.equals("") ? "Select a valid reliever" : "\nSelect a valid reliever");
        }
        try {
            leaveType = (LeaveType)this.cbLeaveType.getValue();
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage.concat(errorMessage.equals("") ? "Select a valid leave type" : "\nSelect a valid leave type");
        }
        try {
            days = this.tfNoOfDays.getText().trim();
            if (days.equals("")) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage.concat(errorMessage.equals("") ? "Enter valid no of days" : "\nEnter valid no of days");
        }
        try {
            days = this.tfNoOfDays.getText().trim();
            int d = Integer.parseInt(days);
            assert (leaveType != null);
            if (d < leaveType.getMinDays()) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage.concat(errorMessage.equals("") ? "Minimum number of days not reached" : "\nMinimum number of days not reached");
        }
        try {
            phoneNo = phoneNo + this.tfPhoneNo.getText().trim();
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage.concat(errorMessage.equals("") ? "Enter a valid phone number" : "\nEnter a valid phone number");
        }
        try {
            startDate = Config.localDateToString((LocalDate)this.dpStartDate.getValue());
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage.concat(errorMessage.equals("") ? "Select a valid start date" : "\nSelect a valid start date");
        }
        try {
            returnDate = Config.localDateToString((LocalDate)this.dpReturnDate.getValue());
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage.concat(errorMessage.equals("") ? "Select a valid return date" : "\nSelect a return start date");
        }
        try {
            assert (employee != null);
            assert (reliever != null);
            if (employee.getEmployeeNumber().equals(reliever.getEmployeeNumber())) {
                error = true;
                errorMessage = errorMessage.concat(errorMessage.equals("") ? "Select a different reliever" : "\nSelect a different reliever");
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            assert (leaveType != null);
            assert (employee != null);
            String e = leaveType.getGender();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (error) {
            this.notificationPane.setText(errorMessage);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        } else {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                id = !this.labelId.getText().trim().equals("") ? this.labelId.getText().trim() : ns.getNextNumber();
                params.put("id", id);
                params.put("employee", employee.getEmployeeNumber());
                params.put("leaveType", leaveType.getNo());
                params.put("startDate", startDate);
                params.put("noOfDays", days);
                params.put("returnDate", returnDate);
                params.put("leavePhone", phoneNo);
                params.put("reliever", reliever == null ? "" : reliever.getEmployeeNumber());
                String url = this.labelId.getText().trim().equals("") ? "mastercreate" : "masterupdate";
                String response = Config.loadDataFromPhp(url + "?type=leaveapplications", params, this.getUser());
                System.out.println(response);
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                if (jr.isStatus()) {
                    if (this.labelId.getText().trim().equals("")) {
                        ns.updateLastUsed(id);
                    }
                    this.labelId.setText(id);
                }
                return jr.isStatus();
            }
            catch (Exception ignored) {
                this.notificationPane.setText("We encountered an error while processing your request");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
        return false;
    }

    public void setLeaveApplication(LeaveApplication leaveApplication) {
        this.leaveApplication = leaveApplication;
        this.labelId.setText(leaveApplication.getId());
        this.cbEmployee.getSelectionModel().select((Object)leaveApplication.getEmployee());
        ObservableList<Employee> employees = new Employee().getAllEmployees(this.getUser());
        this.cbLeaveType.getSelectionModel().select((Object)leaveApplication.getLeaveType());
        this.tfPhoneNo.setText(leaveApplication.getLeavePhone());
        this.btnPost.setDisable(leaveApplication.isPosted());
        this.btnSave.setDisable(leaveApplication.isPosted());
        this.tfNoOfDays.setDisable(leaveApplication.isPosted());
        this.tfPhoneNo.setDisable(leaveApplication.isPosted());
        this.cbLeaveType.setDisable(leaveApplication.isPosted());
        this.cbEmployee.setDisable(leaveApplication.isPosted());
        this.cbReliever.setDisable(leaveApplication.isPosted());
        this.dpStartDate.setDisable(leaveApplication.isPosted());
        this.dpStartDate.setValue((Object)Config.stringToLocalDate(leaveApplication.getStartDate()));
        this.tfNoOfDays.setText(leaveApplication.getNoOfDays() + "");
        this.dpReturnDate.setValue((Object)Config.stringToLocalDate(leaveApplication.getReturnDate()));
        if (leaveApplication.isPosted() && !leaveApplication.isReversed()) {
            this.btnReverse.setDisable(false);
        }
        if (!leaveApplication.isPosted()) {
            this.btnSave.setDisable(true);
        }
    }
}

