/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.Employee;
import classes.LeaveLedgerEntries;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;

public class LeaveLedgerEntriesController
implements Initializable {
    private User user;
    List<LeaveLedgerEntries> myEntries = FXCollections.observableArrayList();
    @FXML
    private Label leaveBalance;
    @FXML
    private JFXButton clear;
    @FXML
    private ComboBox<Employee> employee;
    @FXML
    private TableView<LeaveLedgerEntries> leaveEntries;
    @FXML
    private TableColumn colId;
    @FXML
    private TableColumn colDocNo;
    @FXML
    private TableColumn colLeaveType;
    @FXML
    private TableColumn colDescription;
    @FXML
    private TableColumn colStartDate;
    @FXML
    private TableColumn colEndDate;
    @FXML
    private TableColumn colNoOfDays;
    @FXML
    private MaskerPane masker;
    @FXML
    private Button searchEmployee;
    @FXML
    private JFXTextField search;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.employee.setItems(new Employee().getAllEmployees(user));
    }

    public void setMyEmployee(Employee myEmployee) {
        this.employee.setValue((Object)myEmployee);
        this.loadEntries();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.employee.setOnAction(e -> this.loadEntries());
        this.colId.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        this.colDocNo.setCellValueFactory((Callback)new PropertyValueFactory("documentNumber"));
        this.colLeaveType.setCellValueFactory((Callback)new PropertyValueFactory("leaveType"));
        this.colDescription.setCellValueFactory((Callback)new PropertyValueFactory("description"));
        this.colStartDate.setCellValueFactory((Callback)new PropertyValueFactory("startDate"));
        this.colEndDate.setCellValueFactory((Callback)new PropertyValueFactory("endDate"));
        this.colNoOfDays.setCellValueFactory((Callback)new PropertyValueFactory("noOfDays"));
        this.searchEmployee.setOnAction(e -> {
            try {
                String response = new Config().getObjectFromSelection("employee", this.getUser());
                this.employee.setValue(new Gson().fromJson(response, Employee.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.search.textProperty().addListener((observable, oldValue, newValue) -> {
            ObservableList afterSearch = FXCollections.observableArrayList();
            String searchString = newValue.toLowerCase();
            for (int b = 0; b < this.myEntries.size(); ++b) {
                try {
                    Gson g = new Gson();
                    String current = g.toJson((Object)this.myEntries.get(b));
                    current = current.toLowerCase();
                    if (!current.contains(searchString)) continue;
                    afterSearch.add((Object)this.myEntries.get(b));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.leaveEntries.getItems().removeAll((Collection)this.leaveEntries.getItems());
            this.leaveEntries.setItems(afterSearch);
            this.leaveBalance.setText(this.total() + "");
        });
        this.clear.setOnAction(e -> this.search.setText(""));
    }

    private void loadEntries() {
        try {
            Task<Void> task1 = new Task<Void>(){

                public Void call() {
                    Platform.runLater(() -> {
                        Platform.runLater(() -> LeaveLedgerEntriesController.this.masker.setVisible(true));
                        ObservableList<LeaveLedgerEntries> allEntries = new LeaveLedgerEntries().getLeaveLedgerEntries(((Employee)LeaveLedgerEntriesController.this.employee.getValue()).getEmployeeNumber(), LeaveLedgerEntriesController.this.getUser());
                        LeaveLedgerEntriesController.this.myEntries = allEntries;
                        LeaveLedgerEntriesController.this.leaveEntries.setItems(allEntries);
                        LeaveLedgerEntriesController.this.leaveBalance.setText("" + LeaveLedgerEntriesController.this.total());
                        Platform.runLater(() -> LeaveLedgerEntriesController.this.masker.setVisible(false));
                    });
                    return null;
                }
            };
            Thread backgroundThread = new Thread((Runnable)task1);
            backgroundThread.setDaemon(true);
            backgroundThread.start();
            Thread backgroundThread1 = new Thread((Runnable)task1);
            backgroundThread1.setDaemon(true);
            backgroundThread1.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Double total() {
        double total = 0.0;
        for (int i = 0; i < this.leaveEntries.getItems().size(); ++i) {
            total += Double.parseDouble(String.valueOf(this.colNoOfDays.getCellData(i)));
        }
        return total;
    }
}

