/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.LoanProduct;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.LoanProductController;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.controlsfx.control.NotificationPane;

public class LoanProductsController
implements Initializable {
    private User user;
    @FXML
    NotificationPane notificationPane;
    @FXML
    private TableView<LoanProduct> allproducts;
    @FXML
    private TableColumn productCode;
    @FXML
    private TableColumn productName;
    @FXML
    private TableColumn minimumAmount;
    @FXML
    private TableColumn maximumAmount;
    @FXML
    private TableColumn minimumInstalments;
    @FXML
    private TableColumn maximumInstalments;
    @FXML
    private TableColumn interestRate;
    @FXML
    private TableColumn noOfLoansIssued;
    @FXML
    private JFXButton addProduct;
    @FXML
    private JFXButton editProduct;
    @FXML
    private JFXButton deleteProduct;
    @FXML
    private JFXButton refresh;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.loadLoanProducts();
        this.refresh.setOnAction(r -> this.loadLoanProducts());
        this.notificationPane.setContent(this.allproducts);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.productCode.setCellValueFactory((Callback)new PropertyValueFactory("loanProductCode"));
        this.productName.setCellValueFactory((Callback)new PropertyValueFactory("loanProductName"));
        this.minimumAmount.setCellValueFactory((Callback)new PropertyValueFactory("formatedMinimumAmount"));
        this.maximumAmount.setCellValueFactory((Callback)new PropertyValueFactory("formatedMaximumAmount"));
        this.minimumInstalments.setCellValueFactory((Callback)new PropertyValueFactory("loanMinimumInstallments"));
        this.maximumInstalments.setCellValueFactory((Callback)new PropertyValueFactory("loanMaximumInstallments"));
        this.interestRate.setCellValueFactory((Callback)new PropertyValueFactory("loanInterestRate"));
        this.noOfLoansIssued.setCellValueFactory((Callback)new PropertyValueFactory("usedInLoans"));
        this.addProduct.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/loanproduct.fxml").openStream());
                LoanProductController controller = (LoanProductController)loader.getController();
                controller.setUser(this.getUser());
                Scene scene = new Scene((Parent)itemPane);
                Stage stage = new Stage();
                stage.setScene(scene);
                stage.setResizable(false);
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.setTitle("Add Loan Product");
                stage.show();
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                LoanProductsController.this.loadLoanProducts();
                            }
                        });
                    }
                });
            }
            catch (Exception j) {
                j.printStackTrace();
            }
        });
        this.deleteProduct.setOnAction(e -> {
            try {
                String loanProduct = ((LoanProduct)this.allproducts.getSelectionModel().getSelectedItem()).getLoanProductCode();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("loanProductCode", loanProduct);
                String response = Config.loadDataFromPhp("masterdelete?type=loanproduct", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                if (jr.isStatus()) {
                    this.loadLoanProducts();
                }
            }
            catch (NullPointerException loanProduct) {
            }
            catch (Exception y) {
                this.notificationPane.setText("We encountered an error while deleting the loan product. Please try again later.");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
        this.allproducts.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    LoanProduct rowData = (LoanProduct)row.getItem();
                    LoanProduct product = (LoanProduct)this.allproducts.getSelectionModel().getSelectedItem();
                    if (!product.equals(null)) {
                        this.editLoanProduct(product);
                    }
                }
            });
            return row;
        });
        this.editProduct.setOnAction(r -> {
            try {
                LoanProduct xm = (LoanProduct)this.allproducts.getSelectionModel().getSelectedItem();
                if (!xm.equals(null) && !xm.getLoanProductCode().equals("")) {
                    this.editLoanProduct(xm);
                }
            }
            catch (NullPointerException xm) {
            }
            catch (Exception t) {
                this.notificationPane.setText("We encountered an error while processing our request. Please try again later.");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
    }

    public void loadLoanProducts() {
        Platform.runLater(() -> this.allproducts.setItems(new LoanProduct().getAllLoanProducts(this.getUser())));
    }

    public void editLoanProduct(LoanProduct product) {
        try {
            FXMLLoader loader = new FXMLLoader();
            AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/loanproduct.fxml").openStream());
            Scene editMember = new Scene((Parent)itemPane, 781.0, 409.0);
            final Stage stage = new Stage();
            editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(editMember);
            LoanProductController controller = (LoanProductController)loader.getController();
            controller.setUser(this.getUser());
            controller.setLoanProduct(product);
            stage.setTitle("Edit Loan Product");
            stage.setResizable(false);
            try {
                stage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            LoanProductsController.this.loadLoanProducts();
                        }
                    });
                }
            });
            stage.showAndWait();
        }
        catch (Exception p) {
            p.printStackTrace();
            this.notificationPane.setText("An error occurred while loading your edit loan product screen. Please contact support");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
    }
}

