/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.Guarantor;
import classes.JsonResponses;
import classes.Loan;
import classes.LoanSetups;
import classes.Member;
import classes.NumberSeries;
import classes.RecoverLoan;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class LoanRecoveryController
implements Initializable {
    private User user;
    private RecoverLoan recoverLoan;
    private Loan myLoan;
    private double myContributions = 0.0;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private HBox notificationHolder;
    @FXML
    private Label recoveryNo;
    @FXML
    private DatePicker recoveryDate;
    @FXML
    private ComboBox<Member> member;
    @FXML
    private Button chooseMember;
    @FXML
    private ComboBox<Loan> loan;
    @FXML
    private Label oustandingAmount;
    @FXML
    private TextField balancingCharge;
    @FXML
    private Label totalAmount;
    @FXML
    private Label totalContributions;
    @FXML
    private TextField contributionsToRecover;
    @FXML
    private TableView<Guarantor> allGuarantors;
    @FXML
    private TableColumn memberNo;
    @FXML
    private TableColumn memberName;
    @FXML
    private TableColumn guaranteeingAmount;
    @FXML
    private TableColumn amountToRecover;
    @FXML
    private Button cancel;
    @FXML
    private Button reverse;
    @FXML
    private Button save;
    @FXML
    private Button post;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public RecoverLoan getRecoverLoan() {
        return this.recoverLoan;
    }

    public void setRecoverLoan(RecoverLoan recoverLoan) {
        this.recoverLoan = recoverLoan;
        try {
            this.recoveryNo.setText(recoverLoan.getRecoveryNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.member.setValue((Object)recoverLoan.getMember());
            Member myMember = (Member)this.member.getValue();
            ObservableList<Loan> myLoans = new Loan().getAllLoans(true, myMember.getMemberNumber(), this.getUser());
            this.loan.setItems(myLoans);
            this.getMemberContributionsBalance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.recoveryDate.setValue((Object)Config.stringToLocalDate(recoverLoan.getRecoveryDate()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.loan.setValue((Object)recoverLoan.getLoan());
            this.getLoanBalance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.balancingCharge.setText(recoverLoan.getBalancingCharge() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.contributionsToRecover.setText(recoverLoan.getAmountFromContributions() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (recoverLoan.isPosted()) {
            this.save.setDisable(true);
            this.post.setDisable(true);
            this.reverse.setDisable(false);
        }
        if (recoverLoan.isReversed()) {
            this.save.setDisable(true);
            this.post.setDisable(true);
            this.reverse.setDisable(true);
        }
    }

    public Loan getMyLoan() {
        return this.myLoan;
    }

    public void setMyLoan(Loan myLoan) {
        this.myLoan = myLoan;
        try {
            this.member.setValue((Object)myLoan.getMember());
            Member myMember = (Member)this.member.getValue();
            ObservableList<Loan> myLoans = new Loan().getAllLoans(true, myMember.getMemberNumber(), this.getUser());
            this.loan.setItems(myLoans);
            this.getMemberContributionsBalance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.loan.setValue((Object)myLoan);
            this.getLoanBalance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.recoveryDate.setValue((Object)Config.getCurrentLocaldate());
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    LoanRecoveryController.this.notificationPane.setText("Loading values. Please wait....");
                    LoanRecoveryController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    LoanRecoveryController.this.notificationPane.show();
                });
                ObservableList<Member> allMembers = new Member().getAllMembers(LoanRecoveryController.this.getUser());
                LoanRecoveryController.this.member.setItems(allMembers);
                Platform.runLater(() -> LoanRecoveryController.this.notificationPane.hide());
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
        Thread thread1 = new Thread((Runnable)task1);
        thread1.setDaemon(true);
        thread1.start();
        double tBalancingCharge = new LoanSetups().populate(this.getUser()).getBalancingCharge();
        this.balancingCharge.setText(tBalancingCharge + "");
        this.member.setOnAction(e -> {
            Member myMember = (Member)this.member.getValue();
            ObservableList<Loan> myLoans = new Loan().getAllLoans(true, myMember.getMemberNumber(), this.getUser());
            this.loan.setItems(myLoans);
            this.getMemberContributionsBalance();
            this.save();
        });
        this.loan.setOnAction(e -> this.getLoanBalance());
        this.save.setOnAction(e -> this.save());
        this.post.setOnAction(e -> {
            if (this.post()) {
                GeneralListController.publicNotificationPane.setText(this.notificationPane.getText());
                GeneralListController.publicNotificationPane.setGraphic(this.notificationPane.getGraphic());
                GeneralListController.publicNotificationPane.show();
                Stage stage = (Stage)this.post.getScene().getWindow();
                stage.close();
            }
        });
        this.reverse.setOnAction(e -> {
            if (this.reverse()) {
                GeneralListController.publicNotificationPane.setText(this.notificationPane.getText());
                GeneralListController.publicNotificationPane.setGraphic(this.notificationPane.getGraphic());
                GeneralListController.publicNotificationPane.show();
                Stage stage = (Stage)this.post.getScene().getWindow();
                stage.close();
            }
        });
        this.notificationPane.setContent((Node)this.notificationHolder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.notificationPane.getStyleClass().add((Object)"dark");
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator(this.member, Validator.createEmptyValidator((String)"Member is required"));
        vs.registerValidator(this.loan, Validator.createEmptyValidator((String)"Loan is required"));
        this.chooseMember.setOnAction(e -> {
            try {
                Member m = new Member().getMemberFromSelection(this.getUser());
                String mNo = m.getMemberNumber();
                if (!mNo.equals("") && !mNo.equals(null)) {
                    this.member.setValue((Object)m);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
    }

    public void getLoanBalance() {
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            String tLoanNo = ((Loan)this.loan.getValue()).getLoanNumber();
            params.put("loanNo", tLoanNo);
            String response = Config.loadDataFromPhp("masterfetch?type=loansbalance", params, this.getUser());
            Double[] myValues = (Double[])new Gson().fromJson(response, Double[].class);
            double balance = myValues[0];
            this.oustandingAmount.setText(Config.formatNumber(balance));
            String tBalancingCharge = this.balancingCharge.getText().trim();
            Double mBalancingCharge = Double.parseDouble(tBalancingCharge);
            double myTotalAmount = balance + mBalancingCharge;
            this.totalAmount.setText(Config.formatNumber(myTotalAmount));
            if (this.myContributions > myTotalAmount) {
                this.contributionsToRecover.setText(myTotalAmount + "");
            } else {
                this.contributionsToRecover.setText(this.myContributions + "");
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void getMemberContributionsBalance() {
        String memberNo = "";
        try {
            memberNo = ((Member)this.member.getValue()).getMemberNumber();
        }
        catch (Exception t) {
            memberNo = "";
        }
        if (!memberNo.equals(null) && !memberNo.equals("")) {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("memberNo", memberNo);
                params.put("transactionType", "202");
                String response = Config.loadDataFromPhp("masterfetch?type=memberaccountbalance", params, this.getUser());
                Double[] myValues = (Double[])new Gson().fromJson(response, Double[].class);
                double tBalance = myValues[0];
                this.totalContributions.setText(Config.formatNumber(tBalance));
                this.myContributions = tBalance;
            }
            catch (NullPointerException params) {
            }
            catch (Exception t) {
                this.notificationPane.setText("We could not be able to compute the member balance");
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
        }
    }

    public boolean save() {
        String tRecoveryNo = "";
        String tMemberNo = "";
        String tLoanNo = "";
        String tRecoveryDate = "";
        double tBalancingCharge = 0.0;
        double tContributionsToRecover = 0.0;
        String message = "";
        boolean error = false;
        boolean newVoucher = false;
        NumberSeries ns = new NumberSeries(21, this.getUser());
        try {
            tRecoveryNo = this.recoveryNo.getText().trim();
            if (tRecoveryNo.equals(null) || tRecoveryNo.equals("") || tRecoveryNo.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            tRecoveryNo = ns.getNextNumber();
            newVoucher = true;
        }
        try {
            tRecoveryDate = Config.localDateToString((LocalDate)this.recoveryDate.getValue());
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select a valid recovery date";
        }
        try {
            tMemberNo = ((Member)this.member.getValue()).getMemberNumber();
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the member ";
        }
        try {
            tLoanNo = ((Loan)this.loan.getValue()).getLoanNumber();
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the loan to recover";
        }
        try {
            tBalancingCharge = Double.parseDouble(this.balancingCharge.getText().trim());
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter a valid amount for balancing charge";
        }
        try {
            tContributionsToRecover = Double.parseDouble(this.contributionsToRecover.getText().trim());
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter a valid amount for contributions to recover";
        }
        if (!error) {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("recoverNo", tRecoveryNo);
                params.put("memberNo", tMemberNo);
                params.put("loanNo", tLoanNo);
                params.put("recoveryDate", tRecoveryDate);
                params.put("balancingCharge", tBalancingCharge);
                params.put("contributionsToRecover", tContributionsToRecover);
                String response = Config.loadDataFromPhp("mastercreate?type=loanrecovery", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                if (jr.isStatus()) {
                    if (newVoucher) {
                        this.recoveryNo.setText(tRecoveryNo);
                        ns.updateLastUsed(tRecoveryNo);
                    }
                    return true;
                }
            }
            catch (Exception t) {
                this.notificationPane.setText("We experienced an error while processing your request");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        } else {
            this.notificationPane.setText(message);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        }
        return false;
    }

    public boolean post() {
        if (this.save()) {
            try {
                String tRecoveryNo = this.recoveryNo.getText().trim();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("recoveryNo", tRecoveryNo);
                String response = Config.loadDataFromPhp("masterpost?type=recoverloan", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                return jr.isStatus();
            }
            catch (Exception t) {
                this.notificationPane.setText("We encountered an error while processing your request.");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
        return false;
    }

    public boolean reverse() {
        try {
            String tRecoveryNo = this.recoveryNo.getText().trim();
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("recoveryNo", tRecoveryNo);
            String response = Config.loadDataFromPhp("masterpost?type=reverserecoverloan", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
            return jr.isStatus();
        }
        catch (Exception t) {
            this.notificationPane.setText("We encountered an error while processing your request.");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
            return false;
        }
    }
}

