/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.Config;
import classes.JsonResponses;
import classes.Loan;
import classes.LoanTopup;
import classes.Member;
import classes.NumberSeries;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class LoanTopupController
implements Initializable {
    private User user;
    private LoanTopup topup;
    @FXML
    private VBox vbHome;
    @FXML
    private VBox notificationHolder;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private Label labelTopupNumber;
    @FXML
    private DatePicker dpDate;
    @FXML
    private ComboBox<Member> cbMember;
    @FXML
    private Button btnSearch;
    @FXML
    private ComboBox<Loan> cbLoan;
    @FXML
    private Label labelBalance;
    @FXML
    private TextField tfAmount;
    @FXML
    private ComboBox<Bank> cbBank;
    @FXML
    private TextField tfCheque;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnSave;
    @FXML
    private Button btnPost;
    @FXML
    private Button btnReverse;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public LoanTopup getTopup() {
        return this.topup;
    }

    public void setTopup(LoanTopup topup) {
        this.topup = topup;
        try {
            this.labelTopupNumber.setText(topup.getNumber());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.dpDate.setValue((Object)Config.stringToLocalDate(topup.getDate()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.cbMember.setValue((Object)topup.getMember());
            this.generateLoans();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.cbLoan.setValue((Object)topup.getLoan());
            this.labelBalance.setText(Config.formatNumber(((Loan)this.cbLoan.getValue()).getLoanBalance()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.tfAmount.setText(topup.getTopUpAmount() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @FXML
    void deleteTopup(ActionEvent event) {
    }

    @FXML
    void postTopup(ActionEvent event) {
        if (this.save() && this.post()) {
            GeneralListController.publicNotificationPane.setText(this.notificationPane.getText());
            GeneralListController.publicNotificationPane.setGraphic(this.notificationPane.getGraphic());
            GeneralListController.publicNotificationPane.show();
            Stage stage = (Stage)this.btnPost.getScene().getWindow();
            stage.close();
        }
    }

    @FXML
    void reverseTopup(ActionEvent event) {
        if (this.reverse()) {
            GeneralListController.publicNotificationPane.setText(this.notificationPane.getText());
            GeneralListController.publicNotificationPane.setGraphic(this.notificationPane.getGraphic());
            GeneralListController.publicNotificationPane.show();
            Stage stage = (Stage)this.btnReverse.getScene().getWindow();
            stage.close();
        }
    }

    @FXML
    void saveTopup(ActionEvent event) {
        this.save();
    }

    @FXML
    void searchMember(ActionEvent event) {
        try {
            Member member = new Member().getMemberFromSelection(this.getUser());
            String memberNumber = member.getMemberNumber();
            this.cbMember.setValue((Object)member);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.dpDate.setValue((Object)Config.getCurrentLocaldate());
        this.cbMember.setItems(new Member().getAllMembers(this.getUser()));
        this.cbMember.setOnAction(e -> this.generateLoans());
        this.cbBank.setItems(Bank.getAllBanks(this.getUser()));
        this.cbLoan.setOnAction(e -> {
            Loan loan = (Loan)this.cbLoan.getValue();
            this.labelBalance.setText(Config.formatNumber(loan.getLoanBalance()));
        });
        this.tfAmount = new Config().setDoubleTextField(this.tfAmount);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.dpDate, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.tfAmount, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.cbBank, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.cbMember, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.cbLoan, Validator.createEmptyValidator((String)"Required"));
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.notificationHolder);
    }

    private boolean save() {
        String number = "";
        String date = "";
        double topUpAmount = 0.0;
        String member = "";
        String loan = "";
        int bank = 0;
        String cheque = "";
        boolean error = false;
        String message = "";
        boolean newTopUp = false;
        NumberSeries ns = new NumberSeries(35, this.getUser());
        try {
            number = this.labelTopupNumber.getText();
            if (number.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            newTopUp = true;
            number = ns.getNextNumber();
        }
        try {
            date = Config.localDateToString((LocalDate)this.dpDate.getValue());
        }
        catch (Exception e) {
            error = true;
            message = message + "Please enter a valid date";
        }
        try {
            member = ((Member)this.cbMember.getValue()).getMemberNumber();
            if (member.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select a member";
        }
        try {
            loan = ((Loan)this.cbLoan.getValue()).getLoanNumber();
            if (loan.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select a loan";
        }
        try {
            topUpAmount = Double.parseDouble(this.tfAmount.getText());
        }
        catch (Exception e) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Invalid Top up amount";
        }
        try {
            bank = ((Bank)this.cbBank.getValue()).getCode();
        }
        catch (Exception e) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select a valid bank";
        }
        try {
            cheque = this.tfCheque.getText();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (error) {
            System.out.println(message);
            this.notificationPane.setText(message);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        } else {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("topUpNo", number);
                params.put("date", date);
                params.put("memberNo", member);
                params.put("loan", loan);
                params.put("topUpAmount", topUpAmount);
                params.put("bank", bank);
                params.put("chequeNo", cheque);
                String response = Config.loadDataFromPhp("mastercreate?type=loantopup", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                if (jr.isStatus() && newTopUp) {
                    System.out.println("Am here");
                    ns.updateLastUsed(number);
                    this.labelTopupNumber.setText(number);
                }
                return jr.isStatus();
            }
            catch (Exception y) {
                this.notificationPane.setText("We encountered an error while processing your request. Please try again later.");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
        return false;
    }

    private boolean post() {
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("topUpNo", this.labelTopupNumber.getText());
            String response = Config.loadDataFromPhp("masterpost?type=loantopup", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
            return jr.isStatus();
        }
        catch (Exception e) {
            this.notificationPane.setText("We encountered an error while processing your request. Please try again");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
            return false;
        }
    }

    private boolean reverse() {
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("topUpNo", this.labelTopupNumber.getText().trim());
            String response = Config.loadDataFromPhp("masterpost?type=loantopup", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
            return jr.isStatus();
        }
        catch (Exception e) {
            this.notificationPane.setText("We encountered an error while processing your request. Please try again");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
            return false;
        }
    }

    public void generateLoans() {
        ObservableList<Loan> myLoans = new Loan().getAllLoans(true, ((Member)this.cbMember.getValue()).getMemberNumber(), this.getUser());
        this.cbLoan.setItems(myLoans);
    }
}

