/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.ChargeItem;
import classes.Config;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.PurchaseHeader;
import classes.PurchaseLines;
import classes.ShopItem;
import classes.ShopLocation;
import classes.User;
import classes.Vendor;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import java.net.URL;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class LpoController
implements Initializable {
    private User user;
    PurchaseHeader invoice;
    @FXML
    NotificationPane notificationPane;
    @FXML
    VBox holder;
    @FXML
    DatePicker invoiceDate;
    @FXML
    private ComboBox<Vendor> vendor;
    @FXML
    private Hyperlink invoiceNo;
    @FXML
    private ComboBox<String> type;
    @FXML
    private ComboBox item;
    @FXML
    private Button searchItem;
    @FXML
    private TextField description;
    @FXML
    private TextField quantity;
    @FXML
    private TextField unitPrice;
    @FXML
    private JFXButton addLine;
    @FXML
    private TableView<PurchaseLines> invoiceLines;
    @FXML
    private TableColumn colType;
    @FXML
    private TableColumn colItemNo;
    @FXML
    private TableColumn colDelete;
    @FXML
    private TableColumn colDescription;
    @FXML
    private TableColumn colQuantity;
    @FXML
    private TableColumn colUnitPrice;
    @FXML
    private TableColumn colTotalAmount;
    @FXML
    private JFXButton postInvoice;
    @FXML
    private JFXButton generateReport;
    @FXML
    private JFXButton deleteInvoice;
    @FXML
    private JFXButton saveInvoice;
    @FXML
    private Hyperlink totalExVAT;
    @FXML
    private Hyperlink totalVAT;
    @FXML
    private Hyperlink totalAmount;
    @FXML
    private ComboBox<ShopLocation> shopLocation;
    @FXML
    private Button search;
    public static TableView<PurchaseLines> publicLines = new TableView();
    public static Hyperlink pTotalExVAT = new Hyperlink();
    public static Hyperlink pTotalVAT = new Hyperlink();
    public static Hyperlink pTotalAmount = new Hyperlink();

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    LpoController.this.notificationPane.setText("Loading Values. Please wait");
                    LpoController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    LpoController.this.notificationPane.show();
                });
                ObservableList<Vendor> allVendors = new Vendor().getAllVendors(LpoController.this.getUser());
                ObservableList<ShopItem> allChargeItems = new ShopItem().getAllItems(LpoController.this.getUser());
                allChargeItems.sort(Comparator.comparing(ShopItem::getName));
                ObservableList<ShopLocation> allLocations = new ShopLocation().getAllLocations(LpoController.this.getUser());
                allLocations.sort(Comparator.comparing(ShopLocation::getName));
                Platform.runLater(() -> {
                    LpoController.this.vendor.setItems(allVendors);
                    LpoController.this.item.setItems(allChargeItems);
                    LpoController.this.shopLocation.setItems(allLocations);
                    LpoController.this.notificationPane.hide();
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public PurchaseHeader getInvoice() {
        return this.invoice;
    }

    public void setInvoice(PurchaseHeader invoice) {
        this.invoice = invoice;
        try {
            this.vendor.setValue((Object)invoice.getVendor());
            try {
                this.invoiceDate.setValue((Object)Config.stringToLocalDate(invoice.getInvoiceDate()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.shopLocation.setValue((Object)invoice.getLocation());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (invoice.isPosted()) {
                this.postInvoice.setDisable(true);
                this.saveInvoice.setDisable(true);
                this.deleteInvoice.setText("Cancel");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.invoiceNo.setText(invoice.getDocumentNo());
        this.loadInvoiceLines();
    }

    public void initialize(URL location, ResourceBundle resources) {
        publicLines = this.invoiceLines;
        pTotalExVAT = this.totalExVAT;
        pTotalVAT = this.totalVAT;
        pTotalAmount = this.totalAmount;
        this.notificationPane.setContent((Node)this.holder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.notificationPane.setCloseButtonVisible(true);
        this.type.getItems().add((Object)"Items");
        this.type.getItems().add((Object)"Services");
        this.type.setValue((Object)"Items");
        this.invoiceDate.setValue((Object)Config.getCurrentLocaldate());
        this.search.setOnAction(e -> {
            try {
                String response = new Config().getObjectFromSelection("vendor", this.getUser());
                this.vendor.setValue(new Gson().fromJson(response, Vendor.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.searchItem.setOnAction(e -> {
            try {
                Gson gson = new Gson();
                String response = new Config().getObjectFromSelection("shopitem", gson.toJson((Object)this.item.getItems()), this.getUser());
                this.item.setValue(gson.fromJson(response, ShopItem.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.type.setOnAction(e -> {
            String typeValue = (String)this.type.getValue();
            if (typeValue.equalsIgnoreCase("Services")) {
                Task<Void> task1 = new Task<Void>(){

                    public Void call() {
                        Platform.runLater(() -> {
                            LpoController.this.notificationPane.setText("Loading Services. Please wait");
                            LpoController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                            LpoController.this.notificationPane.show();
                        });
                        ObservableList<ChargeItem> allChargeItems = new ChargeItem().getChargeItems(2, LpoController.this.getUser());
                        allChargeItems.sort(Comparator.comparing(ChargeItem::getName));
                        Platform.runLater(() -> {
                            LpoController.this.item.setItems(allChargeItems);
                            LpoController.this.notificationPane.hide();
                        });
                        return null;
                    }
                };
                Thread backgroundThread = new Thread((Runnable)task1);
                backgroundThread.setDaemon(true);
                backgroundThread.start();
            } else if (typeValue.equalsIgnoreCase("Items")) {
                Task<Void> task1 = new Task<Void>(){

                    public Void call() {
                        Platform.runLater(() -> {
                            LpoController.this.notificationPane.setText("Loading Items. Please wait");
                            LpoController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                            LpoController.this.notificationPane.show();
                        });
                        ObservableList<ShopItem> allItems = new ShopItem().getAllItems(LpoController.this.getUser());
                        allItems.sort(Comparator.comparing(ShopItem::getName));
                        Platform.runLater(() -> {
                            LpoController.this.item.setItems(allItems);
                            LpoController.this.notificationPane.hide();
                        });
                        return null;
                    }
                };
                Thread backgroundThread = new Thread((Runnable)task1);
                backgroundThread.setDaemon(true);
                backgroundThread.start();
            }
        });
        this.item.setOnAction(e -> {
            try {
                String typeValue = (String)this.type.getValue();
                if (typeValue.equalsIgnoreCase("Services")) {
                    ChargeItem ci = (ChargeItem)this.item.getValue();
                    this.description.setText(ci.getName());
                } else if (typeValue.equalsIgnoreCase("Items")) {
                    ShopItem ci = (ShopItem)this.item.getValue();
                    this.description.setText(ci.getName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.quantity, Validator.createEmptyValidator((String)"Quantity is required"));
        vs.registerValidator((Control)this.unitPrice, Validator.createEmptyValidator((String)"Unit Price is required"));
        vs.registerValidator((Control)this.description, Validator.createEmptyValidator((String)"Description is required"));
        vs.registerValidator((Control)this.item, Validator.createEmptyValidator((String)"Item is required"));
        this.saveInvoice.setOnAction(e -> this.saveInvoice());
        this.colType.setCellValueFactory((Callback)new PropertyValueFactory("itemType"));
        this.colItemNo.setCellValueFactory((Callback)new PropertyValueFactory("itemNo"));
        this.colDescription.setCellValueFactory((Callback)new PropertyValueFactory("itemDescription"));
        this.colQuantity.setCellValueFactory((Callback)new PropertyValueFactory("quantityString"));
        this.colUnitPrice.setCellValueFactory((Callback)new PropertyValueFactory("unitPriceString"));
        this.colTotalAmount.setCellValueFactory((Callback)new PropertyValueFactory("totalAmountString"));
        this.colDelete.setCellValueFactory((Callback)new PropertyValueFactory("delete"));
        this.addLine.setOnAction(e -> {
            Object cI;
            this.notificationPane.hide();
            String tType = (String)this.type.getValue();
            String itemNo = "";
            String typeValue = (String)this.type.getValue();
            boolean error = false;
            String message = "";
            if (typeValue.equalsIgnoreCase("Services")) {
                try {
                    cI = (ChargeItem)this.item.getValue();
                    itemNo = ((ChargeItem)cI).getCode() + "";
                }
                catch (Exception t) {
                    error = true;
                    message = message + "Please an item";
                }
            } else if (typeValue.equalsIgnoreCase("Items")) {
                try {
                    cI = (ShopItem)this.item.getValue();
                    itemNo = ((ShopItem)cI).getCode() + "";
                }
                catch (Exception t) {
                    error = true;
                    message = message + "Please an item";
                }
            }
            String tDescription = this.description.getText().trim();
            String tUnitPrice = this.unitPrice.getText().trim();
            double mUnitPrice = 0.0;
            String tQuantity = this.quantity.getText().trim();
            double mQuantity = 0.0;
            if (tType.isEmpty()) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select line type";
            }
            if (itemNo.isEmpty()) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter an item for the line";
            }
            if (tDescription.isEmpty()) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter a description for the line";
            }
            if (tUnitPrice.isEmpty()) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter a unit price for the line";
            } else {
                try {
                    mUnitPrice = Double.parseDouble(tUnitPrice);
                    if (mUnitPrice <= 0.0) {
                        error = true;
                        message = message + (message.length() > 0 ? "\n" : "");
                        message = message + "Unit price cannot be less than or equal to 0";
                    }
                }
                catch (Exception t) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please enter a valid unit price for the line";
                }
            }
            if (tUnitPrice.isEmpty()) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter a unit price for the line";
            } else {
                try {
                    mQuantity = Double.parseDouble(tQuantity);
                    if (mQuantity <= 0.0) {
                        error = true;
                        message = message + (message.length() > 0 ? "\n" : "");
                        message = message + "Quantity cannot be less or equal to zero";
                    }
                }
                catch (Exception t) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please enter a valid quantity for the line";
                }
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            } else if (this.saveInvoice()) {
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("invoiceNo", this.invoiceNo.getText());
                    params.put("itemType", tType);
                    params.put("itemNo", itemNo);
                    params.put("description", tDescription);
                    params.put("unitPrice", tUnitPrice);
                    params.put("quantity", tQuantity);
                    String response = Config.loadDataFromPhp("mastercreate?type=vendorinvoicelines", params, this.getUser());
                    Gson g = new Gson();
                    JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                    this.loadInvoiceLines();
                    if (jr.isStatus()) {
                        this.description.setText("");
                        this.item.setValue(null);
                        this.unitPrice.setText("0.0");
                        this.quantity.setText("1");
                    }
                }
                catch (Exception t) {
                    this.notificationPane.setText("We encountered an error while adding the invoice line. ");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                    t.printStackTrace();
                }
            }
        });
        this.deleteInvoice.setOnAction(e -> {
            String tInvoiceNo = this.invoiceNo.getText().trim();
            if (!tInvoiceNo.isEmpty()) {
                JsonResponses jr = new PurchaseHeader().deleteInvoice(tInvoiceNo, this.getUser());
                if (jr.isStatus()) {
                    Stage stage = (Stage)this.deleteInvoice.getScene().getWindow();
                    stage.close();
                } else {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            } else {
                Stage stage = (Stage)this.deleteInvoice.getScene().getWindow();
                stage.close();
            }
        });
        this.generateReport.setOnAction(e -> {
            try {
                HashMap<String, Object> parameters2 = new HashMap<String, Object>();
                parameters2.put("saccoName", Config.saccoName);
                parameters2.put("companyAddress", Config.companyAddress);
                parameters2.put("invoiceNo", this.invoiceNo.getText().trim());
                parameters2.put("invoiceDate", Config.localDateToString((LocalDate)this.invoiceDate.getValue()));
                Vendor tVendor = (Vendor)this.vendor.getValue();
                parameters2.put("vendorPhone", tVendor.getVendorPhone());
                parameters2.put("vendorEmail", tVendor.getVendorEmail());
                parameters2.put("vendorName", tVendor.getFullName());
                parameters2.put("documentName", "LOCAL PURCHASE ORDER(L.P.O)");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("invoiceNo", this.invoiceNo.getText().trim());
                new Config().getReport("Local Purchase Order", "masterfetch?type=vendorinvoicelines", params, "purchasedocuments.jasper", parameters2, this.user);
            }
            catch (Exception r) {
                r.printStackTrace();
            }
        });
        this.postInvoice.setOnAction(e -> {
            String tInvoiceNo;
            boolean error = false;
            try {
                if (this.getInvoice().isPosted()) {
                    error = true;
                    Stage stage = (Stage)this.postInvoice.getScene().getWindow();
                    stage.close();
                    return;
                }
            }
            catch (Exception stage) {
                // empty catch block
            }
            if (!this.saveInvoice() || error || (tInvoiceNo = this.invoiceNo.getText().trim()).isEmpty()) return;
            try {
                Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                alert.setTitle("Confirm Post");
                alert.setHeaderText("Posting the Order will results in a change in the financial position. ");
                alert.setContentText("Are you sure you want to convert the L.P.O to purchase invoice ?");
                Optional result = alert.showAndWait();
                if (result.get() != ButtonType.OK) return;
            }
            catch (Exception r) {
                this.notificationPane.setText("We encountered an error while posting the customer invoice. Please try again later");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
    }

    public boolean saveInvoice() {
        boolean isNew = false;
        String tInvoiceNo = this.invoiceNo.getText().trim();
        NumberSeries nb = new NumberSeries(32, this.getUser());
        if (tInvoiceNo.isEmpty()) {
            tInvoiceNo = nb.getNextNumber();
            isNew = true;
        }
        String tvendorNo = "";
        String tInvoiceDate = "";
        int shopLocationCode = 0;
        try {
            tvendorNo = ((Vendor)this.vendor.getValue()).getVendorNumber();
            if (tvendorNo.isEmpty()) {
                tvendorNo = "";
            }
        }
        catch (Exception t) {
            tvendorNo = "";
        }
        try {
            tInvoiceDate = Config.localDateToString((LocalDate)this.invoiceDate.getValue());
        }
        catch (Exception t) {
            tInvoiceDate = "";
        }
        try {
            shopLocationCode = ((ShopLocation)this.shopLocation.getValue()).getId();
        }
        catch (Exception t) {
            shopLocationCode = 0;
        }
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("invoiceNo", tInvoiceNo);
        params.put("vendor", tvendorNo);
        params.put("invoiceDate", tInvoiceDate);
        params.put("shopLocationCode", shopLocationCode);
        params.put("projectCode", "");
        String response = Config.loadDataFromPhp("mastercreate?type=vendorinvoice", params, this.getUser());
        Gson g = new Gson();
        JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
        if (jr.isStatus() && isNew) {
            this.invoiceNo.setText(tInvoiceNo);
            nb.updateLastUsed(tInvoiceNo);
        }
        this.notificationPane.setText(jr.getMessage());
        this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
        this.notificationPane.show();
        return jr.isStatus();
    }

    public void loadInvoiceLines() {
        String tInvoiceNo = this.invoiceNo.getText().trim();
        ObservableList<PurchaseLines> allLines = new PurchaseLines().getAllLines(tInvoiceNo, this.getUser());
        this.invoiceLines.setItems(allLines);
        double tTotalExVAT = 0.0;
        double tTotalVAT = 0.0;
        double tTotal = 0.0;
        for (PurchaseLines vil : allLines) {
            tTotalExVAT += vil.getTotalExclVAT();
            tTotalVAT += vil.getTotalVAT();
            tTotal += vil.getTotalAmount();
        }
        this.totalVAT.setText(Config.formatNumber(tTotalVAT));
        this.totalExVAT.setText(Config.formatNumber(tTotalExVAT));
        this.totalAmount.setText(Config.formatNumber(tTotal));
    }
}

