/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.ManagementApproval;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.scene.web.HTMLEditor;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;

public class ManagementApprovalController
implements Initializable {
    private User user;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;
    @FXML
    private Label requestId;
    @FXML
    private Label requestedBy;
    @FXML
    private Label requestType;
    @FXML
    private Label requestDate;
    @FXML
    private HTMLEditor reason;
    @FXML
    private Label status;
    @FXML
    private Button reject;
    @FXML
    private Button approve;

    public void setApproval(ManagementApproval approval) {
        if (approval.getStatus().equalsIgnoreCase("Pending")) {
            this.approve.setDisable(false);
            this.reject.setDisable(false);
        }
        this.requestId.setText(approval.getId() + "");
        this.requestedBy.setText(approval.getUser());
        this.requestType.setText(approval.getRequestType());
        this.requestDate.setText(approval.getRequestDate());
        this.status.setText(approval.getStatus());
        this.reason.setHtmlText(approval.getRejectionReason());
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        this.reject.setOnAction(e -> {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("requestId", this.requestId.getText().trim());
            params.put("type", "ManagementApproval");
            params.put("status", "Rejected");
            String response = Config.loadDataFromPhp("masterupdate?type=management_approval", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                GeneralListController.publicNotificationPane.setText(jr.getMessage());
                GeneralListController.publicNotificationPane.show();
                Stage stage = (Stage)this.approve.getScene().getWindow();
                stage.close();
            } else {
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.show();
            }
        });
        this.approve.setOnAction(e -> {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("requestId", this.requestId.getText().trim());
            params.put("type", "ManagementApproval");
            params.put("status", "Approved");
            String response = Config.loadDataFromPhp("masterupdate?type=management_approval", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                GeneralListController.publicNotificationPane.setText(jr.getMessage());
                GeneralListController.publicNotificationPane.show();
                Stage stage = (Stage)this.approve.getScene().getWindow();
                stage.close();
            } else {
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.show();
            }
        });
    }
}

