/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.StandardFees;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import org.controlsfx.control.NotificationPane;

public class MemberSetupController
implements Initializable {
    private User user;
    @FXML
    AnchorPane holder;
    @FXML
    NotificationPane notificationPane;
    @FXML
    private Label inactiveLabel;
    @FXML
    private JFXButton editGeneral;
    @FXML
    private TableView<StandardFees> memberFees;
    @FXML
    private TableColumn feeDescription;
    @FXML
    private TableColumn feeAmount;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane.setContent((Node)this.holder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.notificationPane.setCloseButtonVisible(true);
        Platform.runLater(() -> this.memberFees.setItems(new StandardFees().getAllStandardFees(this.getUser())));
        this.feeDescription.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.feeAmount.setCellValueFactory((Callback)new PropertyValueFactory("amount"));
        this.feeAmount.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new DoubleStringConverter()));
        this.feeAmount.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<StandardFees, Double>>(){

            public void handle(TableColumn.CellEditEvent<StandardFees, Double> t) {
                StandardFees pl = (StandardFees)t.getTableView().getItems().get(t.getTablePosition().getRow());
                double amount = (Double)t.getNewValue();
                String url = "membersetupjoiningfee";
                if (pl.getCode() != 1) {
                    if (pl.getCode() == 2) {
                        url = "membersetupdailyfee";
                    } else if (pl.getCode() == 3) {
                        url = "membersetupmonthlyfee";
                    } else if (pl.getCode() == 4) {
                        url = "savingswithdrawalcharge";
                    }
                }
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("amount", amount);
                    String response = Config.loadDataFromPhp("masterupdate?type=" + url, params, MemberSetupController.this.getUser());
                    Gson g = new Gson();
                    JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        pl.setAmount(amount);
                    }
                    MemberSetupController.this.notificationPane.setText(jr.getMessage());
                    MemberSetupController.this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    MemberSetupController.this.notificationPane.show();
                }
                catch (Exception e) {
                    MemberSetupController.this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                    MemberSetupController.this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    MemberSetupController.this.notificationPane.show();
                    e.printStackTrace();
                }
            }
        });
    }

    public void loadMemberSetups() {
    }
}

