/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.MobillVoucherLine;
import classes.MobitillVoucher;
import classes.NumberSeries;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.chart.PieChart;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.Duration;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class MobitillCardController
implements Initializable {
    private User user;
    private MobitillVoucher voucher;
    ObservableList<MobillVoucherLine> toSearch = FXCollections.observableArrayList();
    @FXML
    ProgressBar progress;
    @FXML
    private VBox root;
    @FXML
    private Label voucherNo;
    @FXML
    private Label createdOn;
    @FXML
    private Hyperlink chooseFile;
    @FXML
    Label progressLabel;
    @FXML
    private VBox vbox1;
    @FXML
    private TextField search;
    @FXML
    private JFXButton clearFilter;
    @FXML
    private TableView<MobillVoucherLine> allEntries;
    @FXML
    private TableColumn colId;
    @FXML
    private TableColumn colDeviceName;
    @FXML
    private TableColumn colMode;
    @FXML
    private TableColumn colProductName;
    @FXML
    private TableColumn colQuantity;
    @FXML
    private TableColumn colTicketNo;
    @FXML
    private TableColumn colTimestamp;
    @FXML
    private TableColumn colTotal;
    @FXML
    private TableColumn colVehicleNo;
    @FXML
    private TableColumn colMemberNo;
    @FXML
    private TableColumn colMemberName;
    @FXML
    private TableColumn colLoanNo;
    @FXML
    private TableColumn colError;
    @FXML
    private VBox vbox2;
    @FXML
    private TableView<MobillVoucherLine.MobitillVoucherSummary> summary;
    @FXML
    private TableColumn colTransType;
    @FXML
    private TableColumn colTotalAmount;
    @FXML
    private TableColumn noOfTransactions;
    @FXML
    MaskerPane masker;
    @FXML
    private PieChart summaryPiechart;
    @FXML
    TabPane tab;
    @FXML
    NotificationPane notificationPane;
    @FXML
    private JFXButton postVoucher;
    @FXML
    private JFXButton deleteVoucherLines;
    @FXML
    private JFXButton reValidate;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public MobitillVoucher getVoucher() {
        return this.voucher;
    }

    public void setVoucher(MobitillVoucher voucher) {
        this.voucher = voucher;
        this.voucherNo.setText(voucher.getVoucherNo());
        this.createdOn.setText(voucher.getCreatedOn());
        this.loadLines();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.summaryPiechart.getData().stream().forEach(pieData -> pieData.getNode().addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            Bounds b1 = pieData.getNode().getBoundsInLocal();
            double newX = b1.getWidth() / 2.0 + b1.getMinX();
            double newY = b1.getHeight() / 2.0 + b1.getMinY();
            pieData.getNode().setTranslateX(0.0);
            pieData.getNode().setTranslateY(0.0);
            TranslateTransition tt = new TranslateTransition(Duration.millis((double)1500.0), pieData.getNode());
            tt.setByX(newX);
            tt.setByY(newY);
            tt.setAutoReverse(true);
            tt.setCycleCount(2);
            tt.play();
        }));
        this.deleteVoucherLines.setOnAction(e -> {
            try {
                String vNo = this.voucherNo.getText().trim();
                if (!vNo.equals("") && !vNo.equals(null)) {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("voucherNo", vNo);
                    String response = Config.loadDataFromPhp("masterdelete?type=mobitillvoucherlines", params, this.getUser());
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        this.loadLines();
                    }
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
            catch (NullPointerException vNo) {
            }
            catch (Exception y) {
                this.notificationPane.setText("We encountered an error while processing your request. Please try again");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
        this.chooseFile.setOnAction(e -> {
            block11: {
                FileChooser chooser = new FileChooser();
                chooser.setTitle("Select Excel to Import Mobitill entries from");
                chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Excel Files", new String[]{"*.csv"})});
                try {
                    File file = chooser.showOpenDialog((Window)new Stage());
                    NumberSeries ns = new NumberSeries(12, this.getUser());
                    boolean newVoucher = false;
                    if (file == null) break block11;
                    try {
                        String tVoucherNo = "";
                        try {
                            tVoucherNo = this.voucherNo.getText().trim();
                            if (tVoucherNo.equals("")) {
                                tVoucherNo = ns.getNextNumber();
                                newVoucher = true;
                            }
                        }
                        catch (Exception t) {
                            tVoucherNo = ns.getNextNumber();
                            newVoucher = true;
                        }
                        if (newVoucher) {
                            try {
                                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                                params.put("voucherNo", tVoucherNo);
                                String response = Config.loadDataFromPhp("mastercreate?type=mobitillvoucher", params, this.getUser());
                                Gson g = new Gson();
                                JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                                if (!jr.isStatus()) {
                                    return;
                                }
                                this.voucherNo.setText(jr.getOverLoad1());
                                this.createdOn.setText(jr.getOverLoad2());
                                ns.updateLastUsed(tVoucherNo);
                            }
                            catch (Exception e4) {
                                e4.printStackTrace();
                                return;
                            }
                        }
                        final BufferedReader br = new BufferedReader(new FileReader(file));
                        final BufferedReader br2 = new BufferedReader(new FileReader(file));
                        ObservableList toImport = FXCollections.observableArrayList();
                        final String mVoucherNo = tVoucherNo;
                        Task<Void> task = new Task<Void>(){

                            public Void call() throws InterruptedException {
                                Platform.runLater(() -> {
                                    MobitillCardController.this.masker.setText("Uploading Records");
                                    MobitillCardController.this.masker.setVisible(true);
                                });
                                try {
                                    String line;
                                    MobitillCardController.this.postVoucher.setDisable(true);
                                    int i = 0;
                                    int y = 0;
                                    String line2 = "";
                                    while ((line2 = br2.readLine()) != null) {
                                        int counter = ++y;
                                        Platform.runLater(() -> MobitillCardController.this.progressLabel.setText(" Counting Records:  " + Config.formatNumber(counter) + " records found"));
                                    }
                                    --y;
                                    while ((line = br.readLine()) != null) {
                                        String[] fields = line.split(",");
                                        int j = ++i - 1;
                                        int limit = y;
                                        this.updateProgress(i, limit);
                                        Platform.runLater(() -> {
                                            MobitillCardController.this.progressLabel.setText(" Uploading " + Config.formatNumber(j) + "  of " + Config.formatNumber(limit));
                                            MobitillCardController.this.masker.setText("Uploading " + Config.formatNumber(j) + "  of " + Config.formatNumber(limit));
                                        });
                                        try {
                                            double quantity = Double.parseDouble(fields[5].trim());
                                            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                                            params.put("deviceName", fields[0]);
                                            params.put("memberName", fields[1]);
                                            params.put("memberNumber", fields[2]);
                                            params.put("mode", fields[3]);
                                            params.put("productName", fields[4]);
                                            params.put("quantity", fields[5]);
                                            params.put("ticketNo", fields[6]);
                                            params.put("timestamp", fields[7]);
                                            params.put("total", fields[8]);
                                            params.put("vehicleNo", fields[9]);
                                            params.put("voucherNo", mVoucherNo);
                                            String string = Config.loadDataFromPhp("mastercreate?type=mobitillline", params, MobitillCardController.this.getUser());
                                        }
                                        catch (Exception exception) {}
                                    }
                                    MobitillCardController.this.postVoucher.setDisable(false);
                                    MobitillCardController.this.loadLines();
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                                return null;
                            }
                        };
                        Thread backgroundThread = new Thread((Runnable)task);
                        backgroundThread.setDaemon(true);
                        this.progress.progressProperty().bind((ObservableValue)task.progressProperty());
                        this.masker.progressProperty().bind((ObservableValue)task.progressProperty());
                        backgroundThread.start();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                catch (Exception ioe) {
                    ioe.printStackTrace();
                }
            }
        });
        this.postVoucher.setOnAction(e -> {
            Task<Void> task1 = new Task<Void>(){

                public Void call() {
                    try {
                        String vNo = MobitillCardController.this.voucherNo.getText().trim();
                        if (!vNo.equals("") && !vNo.equals(null)) {
                            Platform.runLater(() -> {
                                MobitillCardController.this.search.setDisable(true);
                                MobitillCardController.this.chooseFile.setDisable(true);
                                MobitillCardController.this.postVoucher.setDisable(true);
                                MobitillCardController.this.deleteVoucherLines.setDisable(true);
                                MobitillCardController.this.reValidate.setDisable(true);
                                MobitillCardController.this.masker.setVisible(true);
                                MobitillCardController.this.masker.setText("Posting Entries. Please Wait....");
                                MobitillCardController.this.progressLabel.setText("Posting Entries. Please Wait....");
                            });
                            JsonResponses jr = new MobitillVoucher().postVoucher(vNo, MobitillCardController.this.getUser());
                            Platform.runLater(() -> {
                                if (jr.isStatus()) {
                                    Stage stage = (Stage)MobitillCardController.this.postVoucher.getScene().getWindow();
                                    stage.close();
                                } else {
                                    Platform.runLater(() -> {
                                        MobitillCardController.this.notificationPane.setText(jr.getMessage());
                                        MobitillCardController.this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                                        MobitillCardController.this.notificationPane.show();
                                    });
                                }
                                MobitillCardController.this.chooseFile.setDisable(false);
                                MobitillCardController.this.postVoucher.setDisable(false);
                                MobitillCardController.this.deleteVoucherLines.setDisable(false);
                                MobitillCardController.this.reValidate.setDisable(false);
                                MobitillCardController.this.search.setDisable(false);
                            });
                        }
                    }
                    catch (NullPointerException vNo) {
                    }
                    catch (Exception y) {
                        Platform.runLater(() -> {
                            MobitillCardController.this.notificationPane.setText("We encountered an error while processing your request. Please try again");
                            MobitillCardController.this.notificationPane.setGraphic((Node)Config.getBanIcon());
                            MobitillCardController.this.notificationPane.show();
                            MobitillCardController.this.chooseFile.setDisable(false);
                            MobitillCardController.this.postVoucher.setDisable(false);
                            MobitillCardController.this.deleteVoucherLines.setDisable(false);
                            MobitillCardController.this.reValidate.setDisable(false);
                            MobitillCardController.this.search.setDisable(false);
                        });
                    }
                    Platform.runLater(() -> MobitillCardController.this.masker.setVisible(false));
                    return null;
                }
            };
            Thread backgroundThread = new Thread((Runnable)task1);
            backgroundThread.setDaemon(true);
            backgroundThread.start();
            Thread thread1 = new Thread((Runnable)task1);
            thread1.setDaemon(true);
            thread1.start();
        });
        this.notificationPane.setContent((Node)this.tab);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.notificationPane.setCloseButtonVisible(true);
        this.colId.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        this.colDeviceName.setCellValueFactory((Callback)new PropertyValueFactory("deviceName"));
        this.colMode.setCellValueFactory((Callback)new PropertyValueFactory("mode"));
        this.colProductName.setCellValueFactory((Callback)new PropertyValueFactory("productName"));
        this.colQuantity.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.colTicketNo.setCellValueFactory((Callback)new PropertyValueFactory("ticketNo"));
        this.colTimestamp.setCellValueFactory((Callback)new PropertyValueFactory("timeStamp"));
        this.colTotal.setCellValueFactory((Callback)new PropertyValueFactory("total"));
        this.colVehicleNo.setCellValueFactory((Callback)new PropertyValueFactory("vehicleNo"));
        this.colMemberNo.setCellValueFactory((Callback)new PropertyValueFactory("memberNo"));
        this.colMemberName.setCellValueFactory((Callback)new PropertyValueFactory("memberName"));
        this.colLoanNo.setCellValueFactory((Callback)new PropertyValueFactory("loanNo"));
        this.colError.setCellValueFactory((Callback)new PropertyValueFactory("error"));
        this.colTransType.setCellValueFactory((Callback)new PropertyValueFactory("productName"));
        this.colTotalAmount.setCellValueFactory((Callback)new PropertyValueFactory("totalString"));
        this.noOfTransactions.setCellValueFactory((Callback)new PropertyValueFactory("count"));
        this.clearFilter.setOnAction(e -> {
            this.search.setText("");
            this.loadLines();
        });
        this.reValidate.setOnAction(e -> {
            Task<Void> task1 = new Task<Void>(){

                public Void call() {
                    try {
                        String vNo = MobitillCardController.this.voucherNo.getText().trim();
                        if (!vNo.equals("") && !vNo.equals(null)) {
                            Platform.runLater(() -> {
                                MobitillCardController.this.masker.setVisible(true);
                                MobitillCardController.this.masker.setText("Re-validating entries");
                                MobitillCardController.this.progressLabel.setText("Re-validating entries");
                            });
                            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                            params.put("voucherNo", vNo);
                            String response = Config.loadDataFromPhp("mastercreate?type=revalidatemobitillvoucher", params, MobitillCardController.this.getUser());
                            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                            if (jr.isStatus()) {
                                MobitillCardController.this.loadLines();
                            }
                            Platform.runLater(() -> {
                                MobitillCardController.this.notificationPane.setText(jr.getMessage());
                                MobitillCardController.this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                                MobitillCardController.this.notificationPane.show();
                            });
                        }
                    }
                    catch (NullPointerException vNo) {
                    }
                    catch (Exception y) {
                        MobitillCardController.this.notificationPane.setText("We encountered an error while processing your request. Please try again");
                        MobitillCardController.this.notificationPane.setGraphic((Node)Config.getBanIcon());
                        MobitillCardController.this.notificationPane.show();
                    }
                    Platform.runLater(() -> MobitillCardController.this.masker.setVisible(false));
                    return null;
                }
            };
            Thread backgroundThread = new Thread((Runnable)task1);
            backgroundThread.setDaemon(true);
            backgroundThread.start();
            Thread thread1 = new Thread((Runnable)task1);
            thread1.setDaemon(true);
            thread1.start();
        });
        this.search.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.equals("")) {
                try {
                    this.loadLines();
                }
                catch (Exception exception) {}
            } else {
                String searchString = this.search.getText().trim().toLowerCase();
                ObservableList afterSearch = FXCollections.observableArrayList();
                for (MobillVoucherLine current : this.toSearch) {
                    String tMode = current.getMode().toLowerCase();
                    String tProductName = current.getProductName().toLowerCase();
                    String tTotal = current.getTotal() + "";
                    String mTotal = Config.formatNumber(current.getTotal());
                    String tTicketNo = current.getTicketNo().toLowerCase();
                    String tVehicleNo = current.getVehicleNo().toLowerCase();
                    String tMemberNo = "";
                    try {
                        tMemberNo = current.getMemberNo().toLowerCase();
                    }
                    catch (Exception r) {
                        tMemberNo = "";
                    }
                    String tMemberName = "";
                    try {
                        tMemberName = current.getMemberName().toLowerCase();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String tLoanNo = "";
                    try {
                        tLoanNo = current.getLoanNo().toLowerCase();
                    }
                    catch (Exception r) {
                        tLoanNo = "";
                    }
                    String tError = "";
                    try {
                        tError = current.getError().toLowerCase();
                    }
                    catch (Exception r) {
                        tError = "";
                    }
                    current.getLoanNo().toLowerCase();
                    current.getError().toLowerCase();
                    if (!tMode.contains(searchString) && !tProductName.contains(searchString) && !tTotal.contains(searchString) && !mTotal.contains(searchString) && !tTicketNo.contains(searchString) && !tVehicleNo.contains(searchString) && !tMemberName.contains(searchString) && !tMemberNo.contains(searchString) && !tLoanNo.contains(searchString) && !tError.contains(searchString)) continue;
                    afterSearch.add((Object)current);
                }
                this.allEntries.getItems().clear();
                this.allEntries.setItems(afterSearch);
            }
        });
    }

    public void loadLines() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                try {
                    ObservableList chartData = FXCollections.observableArrayList();
                    Platform.runLater(() -> MobitillCardController.this.masker.setVisible(true));
                    String vNo = MobitillCardController.this.voucherNo.getText().trim();
                    if (!vNo.equals("")) {
                        Platform.runLater(() -> {
                            MobitillCardController.this.allEntries.setItems(new MobillVoucherLine().getLines(vNo, MobitillCardController.this.getUser()));
                            MobitillCardController.this.toSearch = new MobillVoucherLine().getLines(vNo, MobitillCardController.this.getUser());
                            ObservableList<MobillVoucherLine.MobitillVoucherSummary> allLines = new MobillVoucherLine().getSummary(vNo, MobitillCardController.this.getUser());
                            MobitillCardController.this.summary.setItems(allLines);
                            for (MobillVoucherLine.MobitillVoucherSummary line : allLines) {
                                chartData.add((Object)new PieChart.Data(line.getProductName(), line.getTotalAmount()));
                            }
                            MobitillCardController.this.summaryPiechart.setData(chartData);
                        });
                    }
                    Platform.runLater(() -> MobitillCardController.this.masker.setVisible(false));
                }
                catch (Exception ty) {
                    ty.printStackTrace();
                }
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
        Thread thread1 = new Thread((Runnable)task1);
        thread1.setDaemon(true);
        thread1.start();
    }
}

