/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Account;
import classes.Config;
import classes.FixedAssets;
import classes.Town;
import classes.TreeMapValueFactory;
import classes.User;
import com.google.gson.Gson;
import controllers.ChartOfAccountsController;
import java.net.URL;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.controlsfx.control.CheckComboBox;
import org.controlsfx.control.MaskerPane;

public class PNLViewController
implements Initializable {
    ObservableList<Town> allTowns;
    private User user;
    @FXML
    private ComboBox<?> company;
    @FXML
    private ComboBox<String> columns;
    @FXML
    private DatePicker startDate;
    @FXML
    private DatePicker endDate;
    @FXML
    private CheckComboBox<FixedAssets> fixedAssets;
    @FXML
    private CheckComboBox<Town> office;
    @FXML
    private VBox companyVbox;
    @FXML
    private VBox fixedAssetsVBox;
    @FXML
    private VBox locationVBox;
    @FXML
    private Button generate;
    @FXML
    private TreeTableView<HashMap> entries;
    @FXML
    private MaskerPane masker;

    public User getUser() {
        return this.user;
    }

    public void setUser(final User user) {
        this.user = user;
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {});
                PNLViewController.this.allTowns = new Town().getAllTowns(user);
                ObservableList<FixedAssets> allAssets = new FixedAssets().getAllAssets(user);
                Platform.runLater(() -> {
                    PNLViewController.this.fixedAssets.getItems().addAll((Collection)allAssets);
                    PNLViewController.this.office.getItems().addAll(PNLViewController.this.allTowns);
                    PNLViewController.this.company.getSelectionModel().select(0);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.companyVbox.managedProperty().bind((ObservableValue)this.companyVbox.visibleProperty());
        this.fixedAssetsVBox.managedProperty().bind((ObservableValue)this.fixedAssetsVBox.visibleProperty());
        this.locationVBox.managedProperty().bind((ObservableValue)this.locationVBox.visibleProperty());
        this.startDate.setValue((Object)Config.getCurrentLocaldate().with(TemporalAdjusters.firstDayOfYear()));
        this.endDate.setValue((Object)Config.getCurrentLocaldate());
        ObservableList allColumns = FXCollections.observableArrayList();
        allColumns.add((Object)"None");
        allColumns.add((Object)"Days");
        allColumns.add((Object)"Weeks");
        allColumns.add((Object)"Months");
        allColumns.add((Object)"Quarters");
        allColumns.add((Object)"Years");
        allColumns.add((Object)"Sales Person");
        allColumns.add((Object)"Location");
        allColumns.add((Object)"Fixed Assets");
        this.columns.setItems(allColumns);
        this.columns.setValue(allColumns.get(0));
        this.masker.setVisible(false);
        this.generate.setOnAction(e -> {
            Task<Void> task1 = new Task<Void>(){

                public Void call() {
                    Platform.runLater(() -> PNLViewController.this.masker.setVisible(true));
                    Gson gson = new Gson();
                    String myCompanyCode = "";
                    String myColumns = "";
                    String myStartDate = "";
                    String myEndDate = "";
                    try {
                        myColumns = (String)PNLViewController.this.columns.getValue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        myStartDate = Config.localDateToString((LocalDate)PNLViewController.this.startDate.getValue());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        myEndDate = Config.localDateToString((LocalDate)PNLViewController.this.endDate.getValue());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ArrayList<Integer> myTowns = new ArrayList<Integer>();
                    ArrayList<String> myVehicles = new ArrayList<String>();
                    try {
                        for (Object t : PNLViewController.this.office.getCheckModel().getCheckedItems()) {
                            myTowns.add(((Town)t).getTownId());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        for (Object t : PNLViewController.this.fixedAssets.getCheckModel().getCheckedItems()) {
                            myVehicles.add(((FixedAssets)t).getAssetNo());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("companyCode", myCompanyCode);
                    params.put("columns", myColumns);
                    params.put("startDate", myStartDate);
                    params.put("endDate", myEndDate);
                    params.put("towns", gson.toJson(myTowns));
                    params.put("vehicles", gson.toJson(myVehicles));
                    String response = Config.loadDataFromPhp("masterfetch?type=pnl_view", params, PNLViewController.this.getUser());
                    System.out.println(response);
                    TreeItem root1 = null;
                    try {
                        HashMap myResponse = (HashMap)gson.fromJson(response, HashMap.class);
                        ArrayList columns = (ArrayList)myResponse.get("columns");
                        Platform.runLater(() -> PNLViewController.this.entries.getColumns().removeAll((Collection)PNLViewController.this.entries.getColumns()));
                        TreeTableColumn accountCategory = new TreeTableColumn("Account Category");
                        accountCategory.setPrefWidth(250.0);
                        accountCategory.setCellValueFactory(new TreeMapValueFactory("accountCategory"));
                        Platform.runLater(() -> PNLViewController.this.entries.getColumns().add((Object)accountCategory));
                        TreeTableColumn accountName = new TreeTableColumn("Account Name");
                        accountName.setCellValueFactory(new TreeMapValueFactory("accountName"));
                        accountName.setPrefWidth(350.0);
                        Platform.runLater(() -> PNLViewController.this.entries.getColumns().add((Object)accountName));
                        for (int a = 2; a < columns.size(); ++a) {
                            TreeTableColumn column = new TreeTableColumn((String)columns.get(a));
                            column.setPrefWidth(150.0);
                            column.setCellFactory(PNLViewController.this.getFactory((String)columns.get(a)));
                            column.setCellValueFactory(new TreeMapValueFactory(columns.get(a)));
                            column.setStyle("-fx-alignment: CENTER-RIGHT;");
                            Platform.runLater(() -> PNLViewController.this.entries.getColumns().add((Object)column));
                        }
                        String allData = myResponse.get("entries").toString();
                        HashMap<String, String> root = new HashMap<String, String>();
                        root.put("accountName", "");
                        root.put("accountCategory", "PNL");
                        root1 = new TreeItem(root);
                        root1.setExpanded(true);
                        ObservableList myData = FXCollections.observableArrayList((Object[])((Object[])gson.fromJson(allData, HashMap[].class)));
                        for (HashMap myEntry : myData) {
                            TreeItem treeItem = new TreeItem((Object)myEntry);
                            treeItem.setExpanded(true);
                            try {
                                String children = myEntry.get("children").toString();
                                ObservableList myChildren = FXCollections.observableArrayList((Object[])((Object[])gson.fromJson(children, HashMap[].class)));
                                for (HashMap child : myChildren) {
                                    TreeItem childItem = new TreeItem((Object)child);
                                    treeItem.getChildren().add((Object)childItem);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            root1.getChildren().add((Object)treeItem);
                        }
                    }
                    catch (Exception p) {
                        p.printStackTrace();
                    }
                    TreeItem finalRoot = root1;
                    Platform.runLater(() -> {
                        PNLViewController.this.entries.setRoot(finalRoot);
                        PNLViewController.this.masker.setVisible(false);
                    });
                    return null;
                }
            };
            Thread backgroundThread = new Thread((Runnable)task1);
            backgroundThread.setDaemon(true);
            backgroundThread.start();
        });
    }

    public Callback<TreeTableColumn<HashMap, Object>, TreeTableCell<HashMap, Object>> getFactory(String columnName) {
        return new Callback<TreeTableColumn<HashMap, Object>, TreeTableCell<HashMap, Object>>(){

            public TreeTableCell<HashMap, Object> call(TreeTableColumn<HashMap, Object> param) {
                TreeTableCell<HashMap, Object> cell = new TreeTableCell<HashMap, Object>(){
                    private final Hyperlink btn = new Hyperlink("");
                    {
                        this.btn.setOnAction(e -> {
                            try {
                                HashMap selectedRow = (HashMap)this.getTreeTableRow().getTreeItem().getValue();
                                String accountNo = selectedRow.get("accountNumber").toString();
                                if (accountNo.trim().length() > 0) {
                                    String accountName = selectedRow.get("accountName").toString();
                                    Account myAccount = new Account(accountNo);
                                    myAccount.setAccountName(accountName);
                                    try {
                                        new ChartOfAccountsController().showEntries(myAccount, (LocalDate)PNLViewController.this.startDate.getValue(), (LocalDate)PNLViewController.this.endDate.getValue(), PNLViewController.this.allTowns, "", "", PNLViewController.this.getUser());
                                    }
                                    catch (Exception j) {
                                        j.printStackTrace();
                                    }
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.btn.setVisited(false);
                        });
                    }

                    public void updateItem(Object item, boolean empty) {
                        super.updateItem(item, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else {
                            String formatted = "";
                            try {
                                double myFigure = Double.parseDouble(item.toString());
                                formatted = myFigure != 0.0 ? Config.formatNumber(myFigure * -1.0) : "0.00";
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.btn.setText(formatted);
                            this.setGraphic((Node)this.btn);
                        }
                    }
                };
                return cell;
            }
        };
    }
}

