/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.Config;
import classes.JsonResponses;
import classes.Member;
import classes.Month;
import classes.NumberSeries;
import classes.ParkingReceipt;
import classes.PaymentMethod;
import classes.Town;
import classes.User;
import classes.Vehicle;
import classes.Year;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.time.LocalDate;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class ParkingFeeController
implements Initializable {
    private User user;
    private ParkingReceipt receipt;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox notificationHolder;
    @FXML
    private Label receiptNo;
    @FXML
    private DatePicker date;
    @FXML
    private ComboBox<Month> month;
    @FXML
    private ComboBox<Year> year;
    @FXML
    private ComboBox<Member> member;
    @FXML
    private Button searchMember;
    @FXML
    private ComboBox<Vehicle> vehicle;
    @FXML
    private ComboBox<Bank> bank;
    @FXML
    private ComboBox<PaymentMethod> paymentMethod;
    @FXML
    private TextField externalDocNo;
    @FXML
    private TextField amount;
    public static TextField publicAmount = new TextField();
    @FXML
    private TableView<Town> allTowns;
    public static TableView<Town> publicTowns = new TableView();
    @FXML
    private TableColumn colTown;
    @FXML
    private TableColumn colAmount;
    @FXML
    private TableColumn colSelect;
    @FXML
    private Button cancel;
    @FXML
    private Button save;
    @FXML
    private Button post;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public ParkingReceipt getReceipt() {
        return this.receipt;
    }

    public void setReceipt(ParkingReceipt receipt) {
        this.receipt = receipt;
        this.receiptNo.setText(receipt.getReceiptNo());
        this.date.setValue((Object)Config.stringToLocalDate(receipt.getPaymentDate()));
        this.month.setValue((Object)receipt.getMonth());
        this.year.setValue((Object)receipt.getYear());
        this.member.setValue((Object)receipt.getMember());
        try {
            Member myMember = (Member)this.member.getValue();
            this.vehicle.setItems(new Vehicle().getMemberVehicles(myMember.getMemberNumber(), this.getUser()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.vehicle.setValue((Object)receipt.getVehicle());
        this.bank.setValue((Object)receipt.getBank());
        this.paymentMethod.setValue((Object)receipt.getPaymentMethod());
        this.externalDocNo.setText(receipt.getExternalDocNo());
        this.amount.setText(Config.formatNumber(receipt.getAmount()));
        this.loadLines();
        if (receipt.isPosted()) {
            this.disableControls();
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.notificationHolder);
        publicTowns = this.allTowns;
        publicAmount = this.amount;
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
        this.amount = new Config().setDoubleTextField(this.amount);
        this.date.setValue((Object)Config.getCurrentLocaldate());
        this.month.setItems(new Month().getAllMonths());
        Platform.runLater(() -> {
            this.year.setItems(new Year().getAllYears(this.getUser()));
            this.bank.setItems(Bank.getAllBanks(this.getUser()));
            this.paymentMethod.setItems(new PaymentMethod().getAllPaymentMethods(this.getUser()));
            this.member.setItems(new Member().getAllMembers(this.getUser()));
            this.allTowns.setItems(new Town().getAllTowns(this.getUser()));
        });
        this.searchMember.setOnAction(e -> {
            try {
                Member myMember = new Member().getMemberFromSelection(this.getUser());
                String memberNo = myMember.getMemberNumber();
                this.member.setValue((Object)myMember);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.member.setOnAction(e -> {
            try {
                Member myMember = (Member)this.member.getValue();
                this.vehicle.setItems(new Vehicle().getMemberVehicles(myMember.getMemberNumber(), this.getUser()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.date, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.month, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.year, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.member, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.vehicle, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.bank, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.paymentMethod, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.amount, Validator.createEmptyValidator((String)"Required"));
        this.colTown.setCellValueFactory((Callback)new PropertyValueFactory("townName"));
        this.colAmount.setCellValueFactory((Callback)new PropertyValueFactory("saccoParkingFeeString"));
        this.colSelect.setCellValueFactory((Callback)new PropertyValueFactory("checkbox"));
        this.save.setOnAction(e -> this.save());
        this.post.setOnAction(e -> {
            if (this.save()) {
                this.post();
            }
        });
        this.amount.setDisable(true);
    }

    public boolean save() {
        block24: {
            try {
                this.notificationPane.hide();
                NumberSeries ns = new NumberSeries(33, this.getUser());
                ObservableList myTowns = this.allTowns.getItems();
                ObservableList selectedTowns = FXCollections.observableArrayList();
                double myTotal = 0.0;
                for (Town myTown : myTowns) {
                    if (!myTown.isSelected()) continue;
                    selectedTowns.add((Object)myTown);
                    myTotal += myTown.getSaccoParkingFee();
                }
                if (selectedTowns.size() < 1) {
                    this.notificationPane.setText("Please select atleast one town");
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                    break block24;
                }
                boolean newReceipt = false;
                boolean error = false;
                String message = "";
                String tReceiptNo = "";
                String tDate = "";
                int tMonth = 0;
                int tYear = 0;
                String tMemberNo = "";
                String tVehicleReg = "";
                int tBankCode = 0;
                int tPaymentMethodCode = 0;
                String tExternalDocNo = "";
                try {
                    tReceiptNo = this.receiptNo.getText().trim();
                    if (tReceiptNo.length() < 1) {
                        throw new Exception();
                    }
                }
                catch (Exception n) {
                    newReceipt = true;
                    tReceiptNo = ns.getNextNumber();
                }
                tExternalDocNo = this.externalDocNo.getText().trim();
                try {
                    tDate = Config.localDateToString((LocalDate)this.date.getValue());
                }
                catch (Exception y) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please select the date";
                }
                try {
                    tMonth = ((Month)this.month.getValue()).getCode();
                }
                catch (Exception y) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please select the month ";
                }
                try {
                    tYear = ((Year)this.year.getValue()).getYear();
                }
                catch (Exception y) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please select the year ";
                }
                try {
                    tMemberNo = ((Member)this.member.getValue()).getMemberNumber();
                }
                catch (Exception y) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please select the member ";
                }
                try {
                    tVehicleReg = ((Vehicle)this.vehicle.getValue()).getRegNo();
                }
                catch (Exception y) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please select the vehicle ";
                }
                try {
                    tBankCode = ((Bank)this.bank.getValue()).getCode();
                }
                catch (Exception y) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please select the receiving bank ";
                }
                try {
                    PaymentMethod tMethod = (PaymentMethod)this.paymentMethod.getValue();
                    tPaymentMethodCode = tMethod.getCode();
                    if (tMethod.isRequiresRef() && tExternalDocNo.length() < 1) {
                        error = true;
                        message = message + (message.length() > 0 ? "\n" : "");
                        message = message + "Please enter the external document No";
                    }
                }
                catch (Exception y) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please select the payment method ";
                }
                if (error) {
                    this.notificationPane.setText(message);
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                    break block24;
                }
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("receiptNo", tReceiptNo);
                params.put("date", tDate);
                params.put("month", tMonth);
                params.put("year", tYear);
                params.put("memberNo", tMemberNo);
                params.put("vehicleReg", tVehicleReg);
                params.put("bankCode", tBankCode);
                params.put("paymentMethodCode", tPaymentMethodCode);
                params.put("externalDocNo", tExternalDocNo);
                params.put("towns", new Gson().toJson((Object)selectedTowns));
                String response = Config.loadDataFromPhp("mastercreate?type=parkingfee", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus() && newReceipt) {
                    ns.updateLastUsed(tReceiptNo);
                    this.receiptNo.setText(tReceiptNo);
                }
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                return jr.isStatus();
            }
            catch (Exception y) {
                this.notificationPane.setText("We encountered an error while processing your request. Please try again");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
        return false;
    }

    public void post() {
        try {
            String tReceiptNo = this.receiptNo.getText().trim();
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("receiptNo", tReceiptNo);
            String response = Config.loadDataFromPhp("masterpost?type=parkingreceipt", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                GeneralListController.publicNotificationPane.setText(jr.getMessage());
                GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                GeneralListController.publicNotificationPane.show();
                Stage stage = (Stage)this.post.getScene().getWindow();
                stage.close();
            } else {
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
            }
        }
        catch (Exception y) {
            this.notificationPane.setText("We encountered an error while processing your request. Please try again");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
    }

    public void disableControls() {
        this.receiptNo.setDisable(true);
        this.date.setDisable(true);
        this.month.setDisable(true);
        this.year.setDisable(true);
        this.member.setDisable(true);
        this.searchMember.setDisable(true);
        this.vehicle.setDisable(true);
        this.bank.setDisable(true);
        this.paymentMethod.setDisable(true);
        this.externalDocNo.setDisable(true);
        this.amount.setDisable(true);
        this.allTowns.setDisable(true);
        this.post.setDisable(true);
        this.save.setDisable(true);
    }

    public void loadLines() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("receiptNo", this.receiptNo.getText().trim());
        String response = Config.loadDataFromPhp("masterfetch?type=parkingLines", params, this.getUser());
        ObservableList myTowns = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, Town[].class)));
        if (myTowns.size() > 0) {
            this.allTowns.getItems().removeAll((Collection)this.allTowns.getItems());
            if (this.getReceipt().isPosted()) {
                ObservableList selectedTowns = FXCollections.observableArrayList();
                for (Town town1 : myTowns) {
                    if (!town1.isSelected()) continue;
                    selectedTowns.add((Object)town1);
                }
                this.allTowns.setItems(selectedTowns);
            } else {
                this.allTowns.setItems(myTowns);
            }
        }
    }
}

