/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.Department;
import classes.Employee;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import sun.misc.BASE64Decoder;

public class PayrollEmployeeCardController
implements Initializable {
    private User user;
    private Employee employee;
    String imagePath = "";
    @FXML
    private AnchorPane root;
    @FXML
    private AnchorPane holder;
    @FXML
    private TextField firstName;
    @FXML
    private TextField middleName;
    @FXML
    private ComboBox<String> paymentMethod;
    @FXML
    private TextField lastName;
    @FXML
    private ImageView profilePhoto;
    @FXML
    private TextField payrollNumber;
    @FXML
    private TextField phoneNumber;
    @FXML
    private TextField emailAddress;
    @FXML
    private JFXButton editEmployee;
    @FXML
    private JFXButton reset;
    @FXML
    private TextField kraPin;
    @FXML
    private TextField nssfNumber;
    @FXML
    private TextField nhifNumber;
    @FXML
    private TextField jobTitle;
    @FXML
    private CheckBox hod;
    @FXML
    private ComboBox<Department> department;
    @FXML
    private TextField bank;
    @FXML
    private TextField bankBranch;
    @FXML
    private TextField bankAccountNo;
    @FXML
    private TextField basicSalary;
    @FXML
    private CheckBox paysPaye;
    @FXML
    private CheckBox paysNHIF;
    @FXML
    private CheckBox paysNSSF;
    @FXML
    private CheckBox suspendPay;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private JFXButton earnings;
    @FXML
    private JFXButton deductions;
    @FXML
    private JFXButton sendPayslip;
    @FXML
    private JFXButton payslip;
    @FXML
    private JFXButton p9;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.department.setItems(new Department().getAllDepartments(this.getUser()));
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee = new Employee().getEmployeeDetails(employee.getEmployeeNumber(), this.getUser());
        this.firstName.setText(employee.getFirstName());
        this.middleName.setText(employee.getMidddleName());
        this.lastName.setText(employee.getLastName());
        this.payrollNumber.setText(employee.getPayrollNumber());
        this.phoneNumber.setText(employee.getPhoneNumber());
        this.emailAddress.setText(employee.getEmail());
        String date = employee.getDateOfBirth();
        try {
            LocalDate localDate = Config.stringToLocalDate(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.kraPin.setText(employee.getKraPin());
        this.nssfNumber.setText(employee.getNssfNo());
        this.nhifNumber.setText(employee.getNhifNo());
        this.jobTitle.setText(employee.getJobTitle());
        this.hod.setSelected(employee.isHod());
        this.department.setValue((Object)employee.getDepartment());
        this.bank.setText(employee.getBank());
        this.bankBranch.setText(employee.getBankBranch());
        this.bankAccountNo.setText(employee.getBankAccountNumber());
        this.basicSalary.setText(employee.getBasicSalary() + "");
        try {
            this.paymentMethod.setValue((Object)employee.getPaymentMethod());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.paysPaye.setSelected(employee.isPaysPAYE());
        this.paysNHIF.setSelected(employee.isPaysNHIF());
        this.paysNSSF.setSelected(employee.isPaysNSSF());
        this.suspendPay.setSelected(employee.isSuspendPay());
        try {
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] imageByte = decoder.decodeBuffer(employee.getPhotoBlob());
            ByteArrayInputStream bis = new ByteArrayInputStream(imageByte);
            Image image = new Image((InputStream)bis);
            this.profilePhoto.setImage(image);
            bis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        String path = System.getProperty("user.dir");
        path = path.replace("\\", "/");
        this.imagePath = path + "/holder.png";
        ValidationSupport validationSupport = new ValidationSupport();
        validationSupport.registerValidator((Control)this.firstName, Validator.createEmptyValidator((String)"First name is required"));
        validationSupport.registerValidator((Control)this.lastName, Validator.createEmptyValidator((String)"Last name is required"));
        ObservableList paymentMethods = FXCollections.observableArrayList();
        paymentMethods.add((Object)"Cash");
        paymentMethods.add((Object)"Bank");
        this.paymentMethod.setItems(paymentMethods);
        this.paymentMethod.setValue((Object)"Cash");
        validationSupport.registerValidator((Control)this.phoneNumber, Validator.createEmptyValidator((String)"Phone number is required"));
        this.basicSalary = new Config().setDoubleTextField(this.basicSalary);
        this.notificationPane.setContent((Node)this.holder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.reset.setOnAction(e -> {
            Stage stage = (Stage)this.reset.getScene().getWindow();
            stage.close();
        });
        this.editEmployee.setOnAction(e -> {
            Employee myEmployee = this.getEmployee();
            String fName = "";
            String tPaymentMethod = "";
            String lName = "";
            String mName = "";
            String tidNumber = myEmployee.getIdNumber() + "";
            String tphoneNumber = "";
            String tPayrollN = "";
            String email = "";
            String dob = myEmployee.getDateOfBirth();
            boolean tDisabled = myEmployee.isDisabled();
            String tdisabilityDescription = myEmployee.getDisabilityDescription();
            String tKra = "";
            String tNssf = "";
            String tNhif = "";
            int tDepartment = 0;
            String tJobTitle = "";
            boolean tHod = this.hod.isSelected();
            boolean error = false;
            String message = "";
            String tBank = "";
            String tBankBranch = "";
            String tBankAccount = "";
            double mBasicSalary = 0.0;
            int tPaysPaye = this.paysPaye.isSelected() ? 1 : 0;
            int tPaysNHIF = this.paysNHIF.isSelected() ? 1 : 0;
            int tPaysNSSF = this.paysNSSF.isSelected() ? 1 : 0;
            int tSuspendPay = this.suspendPay.isSelected() ? 1 : 0;
            try {
                tBank = this.bank.getText().trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                tBankBranch = this.bankBranch.getText().trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                tBankAccount = this.bankAccountNo.getText().trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                String bPay = this.basicSalary.getText().trim();
                mBasicSalary = bPay.length() > 0 ? Double.parseDouble(bPay) : 0.0;
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() == 0 ? "" : "\n");
                message = message + "Please enter a valid value for basic pay ";
            }
            try {
                fName = this.firstName.getText().trim();
                if (fName.equals("")) {
                    throw new Exception();
                }
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() == 0 ? "" : "\n");
                message = message + "Please input the employee first name. ";
            }
            try {
                lName = this.lastName.getText().trim();
                if (lName.equals("")) {
                    throw new Exception();
                }
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() == 0 ? "" : "\n");
                message = message + "Please input the employee last name. ";
            }
            try {
                tphoneNumber = this.phoneNumber.getText().trim();
                if (tphoneNumber.equals("")) {
                    throw new Exception();
                }
                if (tphoneNumber.length() < 10 || tphoneNumber.length() > 13) {
                    throw new Exception();
                }
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() == 0 ? "" : "\n");
                message = message + "Please input a valid phone number. ";
            }
            try {
                mName = this.middleName.getText().trim();
            }
            catch (Exception t) {
                mName = "";
            }
            try {
                tPayrollN = this.payrollNumber.getText().trim();
            }
            catch (Exception t) {
                tPayrollN = "";
            }
            try {
                email = this.emailAddress.getText().trim();
            }
            catch (Exception t) {
                email = "";
            }
            try {
                tKra = this.kraPin.getText().trim();
            }
            catch (Exception t) {
                tKra = "";
            }
            try {
                tNhif = this.nhifNumber.getText().trim();
            }
            catch (Exception t) {
                tNhif = "";
            }
            try {
                tNssf = this.nssfNumber.getText().trim();
            }
            catch (Exception t) {
                tNssf = "";
            }
            try {
                tJobTitle = this.jobTitle.getText().trim();
            }
            catch (Exception t) {
                tJobTitle = "";
            }
            try {
                tDepartment = ((Department)this.department.getValue()).getCode();
            }
            catch (Exception t) {
                tDepartment = 0;
            }
            try {
                tPaymentMethod = (String)this.paymentMethod.getValue();
            }
            catch (Exception t) {
                tPaymentMethod = "Cash";
            }
            if (error) {
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.setText(message);
                this.notificationPane.show();
            } else {
                try {
                    this.notificationPane.setText("Please wait while we add the employee.........");
                    this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    this.notificationPane.show();
                    ByteArrayOutputStream ba = Config.convertFileToJson(this.imagePath);
                    String photoJson = StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])ba.toByteArray()));
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("employeeNumber", this.employee.getEmployeeNumber());
                    params.put("fName", fName);
                    params.put("lName", lName);
                    params.put("mName", mName);
                    params.put("idNumber", tidNumber);
                    params.put("phoneNumber", tphoneNumber);
                    params.put("payrollNumber", tPayrollN);
                    params.put("email", email);
                    params.put("dob", dob);
                    params.put("disabled", tDisabled);
                    params.put("disabilityDescription", tdisabilityDescription);
                    params.put("kra", tKra);
                    params.put("nssf", tNssf);
                    params.put("nhif", tNhif);
                    params.put("department", tDepartment);
                    params.put("jobTitle", tJobTitle);
                    params.put("hod", tHod);
                    params.put("photo", photoJson);
                    params.put("bank", tBank);
                    params.put("bankBranch", tBankBranch);
                    params.put("bankAccount", tBankAccount);
                    params.put("basicSalary", mBasicSalary);
                    params.put("paysPAYE", tPaysPaye);
                    params.put("paysNHIF", tPaysNHIF);
                    params.put("paysNSSF", tPaysNSSF);
                    params.put("suspendPay", tSuspendPay);
                    params.put("gender", this.employee.getGender());
                    params.put("paymentMethod", tPaymentMethod);
                    String response = Config.loadDataFromPhp("mastercreate?type=payrollemployees", params, this.getUser());
                    Gson g = new Gson();
                    JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        Stage stage = (Stage)this.editEmployee.getScene().getWindow();
                        stage.close();
                    } else {
                        this.notificationPane.setText(jr.getMessage());
                        this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                        this.notificationPane.show();
                    }
                }
                catch (Exception y) {
                    this.notificationPane.setText("We encountered an error while trying to update the employee. Please try again later");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                    y.printStackTrace();
                }
            }
        });
        final ContextMenu imageOptions = new ContextMenu();
        MenuItem upload = new MenuItem("Upload");
        upload.setOnAction(e -> {
            FileChooser chooser = new FileChooser();
            chooser.setTitle("Select Item Picture");
            chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("All Images", new String[]{"*.jpg", "*.png"}), new FileChooser.ExtensionFilter("JPG", new String[]{"*.jpg"}), new FileChooser.ExtensionFilter("PNG", new String[]{"*.png"})});
            File file = chooser.showOpenDialog((Window)new Stage());
            if (file != null) {
                this.openFile(file);
            }
        });
        MenuItem reset = new MenuItem("Reset to Default");
        String myPath = path;
        reset.setOnAction(e -> {
            String fileLocation = myPath + "/holder.png";
            File imgFile = new File(fileLocation);
            this.openFile(imgFile);
        });
        imageOptions.getItems().addAll((Object[])new MenuItem[]{upload, reset});
        this.profilePhoto.setOnContextMenuRequested((EventHandler)new EventHandler<ContextMenuEvent>(){

            public void handle(ContextMenuEvent event) {
                imageOptions.show((Node)PayrollEmployeeCardController.this.profilePhoto, event.getScreenX(), event.getScreenY());
            }
        });
    }

    private void openFile(File file) {
        try {
            Image image = new Image(file.toURI().toString());
            this.profilePhoto.setImage(image);
            this.imagePath = file.getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

