/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Account;
import classes.AllowancesDeductions;
import classes.Config;
import classes.JsonResponses;
import classes.PayrollSetup;
import classes.User;
import com.google.gson.Gson;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import org.controlsfx.control.NotificationPane;

public class PayrollSetups
implements Initializable {
    private User user;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox vbHolder;
    @FXML
    private ComboBox<AllowancesDeductions> basicSalary;
    @FXML
    private ComboBox<AllowancesDeductions> paye;
    @FXML
    private ComboBox<AllowancesDeductions> nhif;
    @FXML
    private ComboBox<AllowancesDeductions> nssf;
    @FXML
    private ComboBox<Account> nssfEmployer;
    @FXML
    private ComboBox<AllowancesDeductions> housingLevy;
    @FXML
    private ComboBox<Account> housingLevyEmployer;
    @FXML
    private ComboBox<AllowancesDeductions> nita;
    @FXML
    private ComboBox<Account> nitaEmployer;
    @FXML
    private Button searchNetPay;
    @FXML
    private ComboBox<AllowancesDeductions> salaryAdvance;
    @FXML
    private ComboBox<AllowancesDeductions> staffLoans;
    @FXML
    private ComboBox<Account> netPay;
    @FXML
    private TextField minimumTaxable;
    @FXML
    private TextField taxRelief;
    @FXML
    private TextField employerKRAPin;
    @FXML
    private TextField employerNhifNo;
    @FXML
    private TextField employerNSSFNo;
    @FXML
    private Button btnSave;
    @FXML
    private Button searchNssfEmployer;
    @FXML
    private Button searchHousingLevyEmployer;
    @FXML
    private Button searchNitaEmployer;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.btnSave.setDisable(false);
        this.notificationPane.setText("Loading content...");
        this.notificationPane.setGraphic((Node)new ProgressIndicator());
        this.notificationPane.show();
        Task task = new Task(){

            protected Object call() throws Exception {
                ObservableList<AllowancesDeductions> allAllowances = new AllowancesDeductions().getAllAllowances(PayrollSetups.this.getUser());
                ObservableList<AllowancesDeductions> allDeductions = new AllowancesDeductions().getAllDeductions(PayrollSetups.this.getUser());
                PayrollSetups.this.basicSalary.setItems(allAllowances);
                PayrollSetups.this.paye.setItems(allDeductions);
                PayrollSetups.this.nhif.setItems(allDeductions);
                PayrollSetups.this.nssf.setItems(allDeductions);
                PayrollSetups.this.salaryAdvance.setItems(allDeductions);
                PayrollSetups.this.staffLoans.setItems(allDeductions);
                PayrollSetups.this.housingLevy.setItems(allDeductions);
                PayrollSetups.this.nita.setItems(allDeductions);
                LinkedHashMap<String, Integer> params = new LinkedHashMap<String, Integer>();
                params.put("category", 4);
                ObservableList<Account> expensesAccounts = Account.getAccounts(PayrollSetups.this.getUser());
                PayrollSetups.this.nssfEmployer.setItems(expensesAccounts);
                PayrollSetups.this.housingLevyEmployer.setItems(expensesAccounts);
                PayrollSetups.this.nitaEmployer.setItems(expensesAccounts);
                LinkedHashMap<String, Integer> liabilitiesParams = new LinkedHashMap<String, Integer>();
                liabilitiesParams.put("category", 2);
                ObservableList<Account> liabilities = Account.getAccounts(PayrollSetups.this.getUser());
                PayrollSetups.this.netPay.setItems(liabilities);
                PayrollSetups.this.notificationPane.hide();
                Platform.runLater(() -> PayrollSetups.this.loadData());
                return null;
            }
        };
        Thread thread = new Thread((Runnable)task);
        thread.setDaemon(false);
        thread.start();
    }

    public void initialize(URL location, ResourceBundle resources) {
        Platform.runLater(() -> {
            this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.vbHolder);
        });
        this.searchNssfEmployer.setOnAction(e -> {
            try {
                Gson gson = new Gson();
                String response = new Config().getObjectFromSelection("glaccount", gson.toJson((Object)this.nssfEmployer.getItems()), this.getUser());
                this.nssfEmployer.setValue(gson.fromJson(response, Account.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.searchHousingLevyEmployer.setOnAction(e -> {
            try {
                Gson gson = new Gson();
                String response = new Config().getObjectFromSelection("glaccount", gson.toJson((Object)this.housingLevyEmployer.getItems()), this.getUser());
                this.housingLevyEmployer.setValue(gson.fromJson(response, Account.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.searchNitaEmployer.setOnAction(e -> {
            try {
                Gson gson = new Gson();
                String response = new Config().getObjectFromSelection("glaccount", gson.toJson((Object)this.nitaEmployer.getItems()), this.getUser());
                this.nitaEmployer.setValue(gson.fromJson(response, Account.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.searchNetPay.setOnAction(e -> {
            try {
                Gson gson = new Gson();
                String response = new Config().getObjectFromSelection("glaccount", gson.toJson((Object)this.netPay.getItems()), this.getUser());
                this.netPay.setValue(gson.fromJson(response, Account.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    @FXML
    void save(ActionEvent event) {
        String t_nssf = "";
        String t_nssfEmployer = "";
        String t_housingLevy = "";
        String t_housingLevyEmployer = "";
        String t_basicSalary = "";
        String t_paye = "";
        String t_nhif = "";
        String t_nita = "";
        String t_nitaEmployer = "";
        String t_netPay = "";
        String t_salaryAdvance = "";
        String t_staffLoans = "";
        String t_employerKRAPin = "";
        String t_employerNhifNo = "";
        String t_employerNSSFNo = "";
        double t_minimumTaxable = 0.0;
        double t_taxRelief = 0.0;
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        try {
            t_basicSalary = ((AllowancesDeductions)this.basicSalary.getValue()).getCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            t_paye = ((AllowancesDeductions)this.paye.getValue()).getCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            t_nhif = ((AllowancesDeductions)this.nhif.getValue()).getCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            t_nssf = ((AllowancesDeductions)this.nssf.getValue()).getCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            t_nssfEmployer = ((Account)this.nssfEmployer.getValue()).getAccountNumber();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            t_housingLevy = ((AllowancesDeductions)this.housingLevy.getValue()).getCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            t_housingLevyEmployer = ((Account)this.housingLevyEmployer.getValue()).getAccountNumber();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            t_nita = ((AllowancesDeductions)this.nita.getValue()).getCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            t_nitaEmployer = ((Account)this.nitaEmployer.getValue()).getAccountNumber();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            t_netPay = ((Account)this.netPay.getValue()).getAccountNumber();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            t_salaryAdvance = ((AllowancesDeductions)this.salaryAdvance.getValue()).getCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            t_staffLoans = ((AllowancesDeductions)this.staffLoans.getValue()).getCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            t_employerKRAPin = this.employerKRAPin.getText().trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            t_employerNhifNo = this.employerNhifNo.getText().trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            t_employerNSSFNo = this.employerNSSFNo.getText().trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            t_minimumTaxable = Double.parseDouble(this.minimumTaxable.getText().trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            t_taxRelief = Double.parseDouble(this.taxRelief.getText().trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            params.put("basicSalary", t_basicSalary);
            params.put("paye", t_paye);
            params.put("nhif", t_nhif);
            params.put("nssf", t_nssf);
            params.put("nssfEmployer", t_nssfEmployer);
            params.put("housingLevy", t_housingLevy);
            params.put("housingLevyEmployer", t_housingLevyEmployer);
            params.put("nita", t_nita);
            params.put("nitaEmployer", t_nitaEmployer);
            params.put("netPay", t_netPay);
            params.put("salaryAdvance", t_salaryAdvance);
            params.put("staffLoans", t_staffLoans);
            params.put("minTaxableAmount", t_minimumTaxable);
            params.put("taxRelief", t_taxRelief);
            params.put("employerKRAPin", t_employerKRAPin);
            params.put("employerNHIFCode", t_employerNhifNo);
            params.put("employerNSSFCode", t_employerNSSFNo);
            params.put("id", 1);
            String response = Config.loadDataFromPhp("masterupdate?type=payrollsetups", params, this.getUser());
            System.out.println(response);
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
        }
        catch (Exception y) {
            this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
    }

    private void loadData() {
        PayrollSetup setup = PayrollSetup.getSetup(this.getUser());
        try {
            this.basicSalary.setValue((Object)setup.getBasicSalary());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.paye.setValue((Object)setup.getPaye());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.nhif.setValue((Object)setup.getNhif());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.nssf.setValue((Object)setup.getNssf());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.nssfEmployer.setValue((Object)setup.getNssfEmployerDeduction());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.housingLevy.setValue((Object)setup.getHousingLevy());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.housingLevyEmployer.setValue((Object)setup.getHousingLevyEmployer());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.nita.setValue((Object)setup.getNita());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.nitaEmployer.setValue((Object)setup.getNitaEmployer());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.netPay.setValue((Object)setup.getNetPay());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.salaryAdvance.setValue((Object)setup.getSalaryAdvance());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.staffLoans.setValue((Object)setup.getStaffLoan());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.minimumTaxable.setText(setup.getMinimumTaxableSalary() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.taxRelief.setText(setup.getTaxRelief() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.employerKRAPin.setText(setup.getEmployerKRAPIN());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.employerNhifNo.setText(setup.getEmployerNHIFNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.employerNSSFNo.setText(setup.getEmployerNSSFNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

