/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.PenaltyVoucher;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.PenaltyCardController;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class PenaltyVouchersController
implements Initializable {
    private User user;
    private boolean posted;
    @FXML
    private VBox root;
    @FXML
    private JFXButton createVoucher;
    @FXML
    private JFXButton editVoucher;
    @FXML
    private JFXButton refresh;
    @FXML
    private JFXButton delete;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private StackPane stackpane;
    @FXML
    private TableView<PenaltyVoucher> allVouchers;
    @FXML
    private TableColumn voucherNo;
    @FXML
    private TableColumn period;
    @FXML
    private TableColumn createdOn;
    @FXML
    private TableColumn totalPenalty;
    @FXML
    private TableColumn noOfLoans;
    @FXML
    private MaskerPane maskerPane;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public boolean isPosted() {
        return this.posted;
    }

    public void setPosted(boolean posted) {
        this.posted = posted;
        this.delete.setDisable(posted);
        this.createVoucher.setDisable(posted);
        this.loadItems();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane.setContent((Node)this.stackpane);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.voucherNo.setCellValueFactory((Callback)new PropertyValueFactory("voucherNo"));
        this.period.setCellValueFactory((Callback)new PropertyValueFactory("period"));
        this.createdOn.setCellValueFactory((Callback)new PropertyValueFactory("createdOn"));
        this.totalPenalty.setCellValueFactory((Callback)new PropertyValueFactory("totalPenaltyString"));
        this.noOfLoans.setCellValueFactory((Callback)new PropertyValueFactory("noOfLoans"));
        this.refresh.setOnAction(e -> this.loadItems());
        this.delete.setOnAction(e -> {
            try {
                PenaltyVoucher voucher = (PenaltyVoucher)this.allVouchers.getSelectionModel().getSelectedItem();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("voucherNo", voucher.getVoucherNo());
                Gson g = new Gson();
                String response2 = Config.loadDataFromPhp("masterdelete?type=penaltyvoucher", params, this.getUser());
                JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                if (myResponse.isStatus()) {
                    this.loadItems();
                }
                this.notificationPane.setText(myResponse.getMessage());
                this.notificationPane.setGraphic((Node)myResponse.getIconFromStatus());
                this.notificationPane.show();
            }
            catch (Exception t) {
                this.notificationPane.setText("We encountered an error while deleting the penalty voucher. Please try again later");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
        this.createVoucher.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/penaltyCard.fxml").openStream());
                PenaltyCardController controller = (PenaltyCardController)loader.getController();
                controller.setUser(this.getUser());
                Scene scene = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(scene);
                stage.setResizable(false);
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.setTitle("Create Penalty Voucher");
                stage.show();
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                PenaltyVouchersController.this.loadItems();
                            }
                        });
                    }
                });
            }
            catch (Exception j) {
                j.printStackTrace();
            }
        });
        this.allVouchers.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    PenaltyVoucher rowData = (PenaltyVoucher)row.getItem();
                    PenaltyVoucher voucher = (PenaltyVoucher)this.allVouchers.getSelectionModel().getSelectedItem();
                    if (!voucher.equals(null)) {
                        this.editVoucher(voucher);
                    }
                }
            });
            return row;
        });
        this.editVoucher.setOnAction(r -> {
            try {
                PenaltyVoucher xm = (PenaltyVoucher)this.allVouchers.getSelectionModel().getSelectedItem();
                if (!xm.equals(null) && !xm.getVoucherNo().equals("")) {
                    this.editVoucher(xm);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
    }

    public void loadItems() {
        Platform.runLater(() -> {
            this.maskerPane.setVisible(true);
            ObservableList<PenaltyVoucher> myVouchers = new PenaltyVoucher().getAllVouchers(this.isPosted(), this.getUser());
            this.allVouchers.setItems(myVouchers);
            this.maskerPane.setVisible(false);
        });
    }

    public void editVoucher(PenaltyVoucher voucher) {
        try {
            FXMLLoader loader = new FXMLLoader();
            AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/penaltyCard.fxml").openStream());
            Scene scene = new Scene((Parent)itemPane, 1065.0, 668.0);
            final Stage stage = new Stage();
            scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(scene);
            PenaltyCardController controller = (PenaltyCardController)loader.getController();
            controller.setUser(this.getUser());
            controller.setVoucher(voucher);
            stage.setTitle("Edit Penalty Voucher");
            stage.setResizable(false);
            try {
                stage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            PenaltyVouchersController.this.loadItems();
                        }
                    });
                }
            });
            stage.showAndWait();
        }
        catch (Exception p) {
            p.printStackTrace();
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while loading your edit penalty voucher screen. Please contact support");
            alert.showAndWait();
        }
    }
}

