/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.BillOfMaterial;
import classes.Config;
import classes.FormattingCell;
import classes.JsonResponses;
import classes.ProductionReturn;
import classes.ShopItem;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class ProductionReturnController
implements Initializable {
    private ProductionReturn productionReturn;
    private User user;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;
    @FXML
    private Label voucherNo;
    @FXML
    private DatePicker productionDate;
    @FXML
    private ComboBox<ShopItem> product;
    @FXML
    private Button searchProduct;
    @FXML
    private TextField quantity;
    @FXML
    private TextField batchNo;
    @FXML
    private DatePicker expiryDate;
    @FXML
    private TableView<BillOfMaterial> allInputs;
    @FXML
    private TableColumn colInputItemCode;
    @FXML
    private TableColumn colInputItemType;
    @FXML
    private TableColumn colInputItemName;
    @FXML
    private TableColumn colInputQuantity;
    @FXML
    private TableColumn colInputUnitPrice;
    @FXML
    private TableColumn colInputTotalAmount;
    @FXML
    private TableView<BillOfMaterial> allSpoilt;
    @FXML
    private TableColumn colSpoiltItemName;
    @FXML
    private TableColumn colSpoiltQuantity;
    @FXML
    private TableColumn colSpoiltUnitPrice;
    @FXML
    private TableColumn colSpoiltTotalAmount;
    @FXML
    private Label totalProductionCost;
    @FXML
    private Label unitCost;
    @FXML
    private Label valueOfSpoilt;
    @FXML
    private Button save;
    @FXML
    private Button post;
    @FXML
    private MaskerPane inputsMasker;
    @FXML
    private MaskerPane spoiltMasker;

    public ProductionReturn getProductionReturn() {
        return this.productionReturn;
    }

    public void setProductionReturn(ProductionReturn productionReturn) {
        this.productionReturn = productionReturn;
        this.save.setDisable(true);
        this.post.setDisable(productionReturn.isPosted());
        this.searchProduct.setDisable(productionReturn.isPosted());
        this.voucherNo.setText(productionReturn.getVoucherNo());
        this.productionDate.setValue((Object)Config.stringToLocalDate(productionReturn.getProductionDate()));
        this.expiryDate.setValue((Object)Config.stringToLocalDate(productionReturn.getExpiryDate()));
        this.product.setValue((Object)productionReturn.getProduct());
        this.quantity.setText(productionReturn.getQuantity() + "");
        this.batchNo.setText(productionReturn.getBatchNo());
        this.loadInputs();
        this.loadSpoilt();
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        this.productionDate.setValue((Object)Config.getCurrentLocaldate());
        this.post.setDisable(true);
        this.inputsMasker.setVisible(false);
        this.spoiltMasker.setVisible(false);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator(this.product, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.productionDate, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.quantity, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.batchNo, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.expiryDate, Validator.createEmptyValidator((String)"Required"));
        this.colInputItemCode.setCellValueFactory((Callback)new PropertyValueFactory("itemCode"));
        this.colInputItemType.setCellValueFactory((Callback)new PropertyValueFactory("itemType"));
        this.colInputItemName.setCellValueFactory((Callback)new PropertyValueFactory("description"));
        this.colInputQuantity.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.colInputQuantity.setCellFactory(column -> new FormattingCell());
        this.colSpoiltItemName.setCellValueFactory((Callback)new PropertyValueFactory("description"));
        this.colSpoiltQuantity.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.colSpoiltQuantity.setCellFactory(column -> new FormattingCell());
        this.colSpoiltUnitPrice.setCellValueFactory((Callback)new PropertyValueFactory("unitPrice"));
        this.colSpoiltUnitPrice.setCellFactory(column -> new FormattingCell());
        this.colSpoiltTotalAmount.setCellValueFactory((Callback)new PropertyValueFactory("totalAmount"));
        this.colSpoiltTotalAmount.setCellFactory(column -> new FormattingCell());
        this.colInputUnitPrice.setCellValueFactory((Callback)new PropertyValueFactory("unitPrice"));
        this.colInputTotalAmount.setCellValueFactory((Callback)new PropertyValueFactory("totalAmount"));
        this.colInputUnitPrice.setCellFactory(column -> new FormattingCell());
        this.colInputTotalAmount.setCellFactory(column -> new FormattingCell());
        this.searchProduct.setOnAction(e -> {
            Gson gson = new Gson();
            String response = new Config().getObjectFromSelection("shopitem", gson.toJson((Object)this.product.getItems()), this.getUser());
            this.product.setValue(gson.fromJson(response, ShopItem.class));
        });
        this.save.setOnAction(e -> {
            boolean error = false;
            String message = "";
            String tProductionDate = null;
            String tProductCode = null;
            String tBatchNo = null;
            String tExpiryDate = null;
            double tQuantity = 0.0;
            try {
                tProductionDate = Config.localDateToString((LocalDate)this.productionDate.getValue());
            }
            catch (Exception ignored) {
                error = true;
                message = "Please select a production date";
            }
            try {
                tProductCode = ((ShopItem)this.product.getValue()).getCode().trim();
                if (tProductCode.length() < 1) {
                    throw new Exception();
                }
            }
            catch (Exception ignored) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select a product";
            }
            try {
                tBatchNo = this.batchNo.getText().trim();
                if (tBatchNo.length() < 1) {
                    throw new Exception();
                }
            }
            catch (Exception ignored) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter a valid batch no";
            }
            try {
                tExpiryDate = Config.localDateToString((LocalDate)this.expiryDate.getValue());
            }
            catch (Exception ignored) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select an expiry date";
            }
            try {
                tQuantity = Double.parseDouble(this.quantity.getText().trim());
            }
            catch (Exception ignored) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter a valid quantity";
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            } else {
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("productionDate", tProductionDate);
                    params.put("productCode", tProductCode);
                    params.put("batchNo", tBatchNo);
                    params.put("expiryDate", tExpiryDate);
                    params.put("quantity", tQuantity);
                    String response = Config.loadDataFromPhp("mastercreate?type=production_return", params, this.getUser());
                    System.out.println(response);
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        ProductionReturn prod = (ProductionReturn)new Gson().fromJson(jr.getOverLoad1(), ProductionReturn.class);
                        this.voucherNo.setText(prod.getVoucherNo());
                        this.totalProductionCost.setText(Config.formatNumber(prod.getTotalProductionCost()));
                        this.unitCost.setText(Config.formatNumber(prod.getUnitCost()));
                        this.valueOfSpoilt.setText(Config.formatNumber(prod.getValueOfSpoiltItems()));
                        this.loadInputs();
                        this.loadSpoilt();
                        this.save.setDisable(true);
                        this.post.setDisable(false);
                    }
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
                catch (Exception ignored) {
                    this.notificationPane.setText("We encountered an error while processing your request. Please try again");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
            }
        });
        this.post.setOnAction(e -> {
            if (Config.showConfirmDialog("Post Production Return", "Posting the return result to a change in financial position", "Are you sure you want to post production return number " + this.voucherNo.getText() + "?")) {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("voucherNo", this.voucherNo.getText().trim());
                String response = Config.loadDataFromPhp("masterpost?type=production_return", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    GeneralListController.publicNotificationPane.setText(jr.getMessage());
                    GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                    GeneralListController.publicNotificationPane.show();
                    ((Stage)this.post.getScene().getWindow()).close();
                } else {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
        });
    }

    private void loadSpoilt() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> ProductionReturnController.this.spoiltMasker.setVisible(true));
                ObservableList<BillOfMaterial> spoilt = new BillOfMaterial().getProductionReturnMaterials(ProductionReturnController.this.voucherNo.getText().trim(), "spoilt", ProductionReturnController.this.getUser());
                Platform.runLater(() -> {
                    ProductionReturnController.this.allSpoilt.setItems(spoilt);
                    ProductionReturnController.this.spoiltMasker.setVisible(false);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void loadInputs() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> ProductionReturnController.this.inputsMasker.setVisible(true));
                ObservableList<BillOfMaterial> inputs = new BillOfMaterial().getProductionReturnMaterials(ProductionReturnController.this.voucherNo.getText().trim(), "inputs", ProductionReturnController.this.getUser());
                Platform.runLater(() -> {
                    ProductionReturnController.this.allInputs.setItems(inputs);
                    ProductionReturnController.this.inputsMasker.setVisible(false);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void loadItems() {
        final Node original = this.searchProduct.getGraphic();
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> ProductionReturnController.this.searchProduct.setGraphic((Node)Config.getLoader()));
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("finishedProduct", 1);
                ObservableList<ShopItem> myItems = new ShopItem().getAllItems(params, ProductionReturnController.this.getUser());
                myItems.sort(Comparator.comparing(ShopItem::getName));
                Platform.runLater(() -> {
                    ProductionReturnController.this.product.setItems(myItems);
                    ProductionReturnController.this.searchProduct.setGraphic(original);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }
}

