/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.ProfitNLoss;
import classes.ProfitNLossLines;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import filterscontrollers.PNLFilter;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class ProfitNLossController
implements Initializable {
    private User user;
    private ProfitNLoss pnl;
    @FXML
    private Label pNLCode;
    @FXML
    private TextField pNLName;
    @FXML
    private TableView<ProfitNLossLines> allEntries;
    @FXML
    private TableColumn glAccount;
    @FXML
    private TableColumn include;
    @FXML
    private Button delete;
    @FXML
    private Button save;
    @FXML
    private Button generate;
    @FXML
    private NotificationPane notificationPane;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public ProfitNLoss getPnl() {
        return this.pnl;
    }

    public void setPnl(ProfitNLoss pnl) {
        this.pnl = pnl;
        this.pNLCode.setText(pnl.getCode() + "");
        this.pNLName.setText(pnl.getName());
        this.allEntries.setItems(new ProfitNLossLines().getAllLines(pnl.getCode(), this.getUser()));
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.glAccount.setCellValueFactory((Callback)new PropertyValueFactory("glAccount"));
        this.include.setCellValueFactory((Callback)new PropertyValueFactory("includeCheck"));
        Platform.runLater(() -> this.allEntries.setItems(new ProfitNLossLines().getAllLines(this.getUser())));
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.allEntries);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.pNLName, Validator.createEmptyValidator((String)"Name is required"));
        this.save.setOnAction(e -> this.save());
        this.generate.setOnAction(e -> {
            if (this.save()) {
                try {
                    FXMLLoader loader = new FXMLLoader();
                    VBox itemPane = (VBox)loader.load(this.getClass().getResource("/filtersfxml/pnlfilter.fxml").openStream());
                    Scene editMember = new Scene((Parent)itemPane);
                    final Stage stage = new Stage();
                    editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                        public void handle(KeyEvent t) {
                            KeyCode key = t.getCode();
                            if (key == KeyCode.ESCAPE) {
                                stage.close();
                            }
                        }
                    });
                    stage.setScene(editMember);
                    PNLFilter controller = (PNLFilter)loader.getController();
                    controller.setUser(this.getUser());
                    ProfitNLoss pnl = new ProfitNLoss();
                    pnl.setCode(Integer.parseInt(this.pNLCode.getText().trim()));
                    pnl.setName(this.pNLName.getText().trim());
                    controller.setPnl(pnl);
                    stage.setTitle("Profit And Loss Filter");
                    stage.setResizable(false);
                    stage.show();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.delete.setOnAction(e -> {
            String tCode = this.pNLCode.getText().trim();
            ProfitNLoss pnl = new ProfitNLoss();
            if (tCode.length() > 0) {
                pnl.setCode(Integer.parseInt(tCode));
                JsonResponses jr = new Config().deleteRecord(new Gson().toJson((Object)pnl), "profitnloss", this.getUser());
                if (jr.isStatus()) {
                    GeneralListController.publicNotificationPane.setText(jr.getMessage());
                    GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                    GeneralListController.publicNotificationPane.show();
                    Stage stage = (Stage)this.delete.getScene().getWindow();
                    stage.close();
                } else {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
        });
    }

    public boolean save() {
        boolean newReport = false;
        boolean error = false;
        String tName = "";
        int tCode = 0;
        try {
            tName = this.pNLName.getText().trim();
            if (tName.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception y) {
            error = true;
            this.notificationPane.setText("Please enter a valid name for the report");
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        }
        if (!error) {
            try {
                tCode = Integer.parseInt(this.pNLCode.getText().trim());
            }
            catch (Exception y) {
                tCode = 0;
                newReport = true;
            }
            try {
                ObservableList myLines = this.allEntries.getItems();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("code", tCode);
                params.put("name", tName);
                params.put("lines", new Gson().toJson((Object)myLines));
                String response = Config.loadDataFromPhp("mastercreate?type=profitnloss", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                if (jr.isStatus() && newReport) {
                    this.pNLCode.setText(jr.getOverLoad1());
                }
                return jr.isStatus();
            }
            catch (Exception y) {
                this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
        return false;
    }
}

