/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.Project;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.scene.web.HTMLEditor;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class ProjectCardController
implements Initializable {
    private Project project;
    private User user;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;
    @FXML
    private Hyperlink projectId;
    @FXML
    private TextField projectName;
    @FXML
    private DatePicker startDate;
    @FXML
    private DatePicker endDate;
    @FXML
    private HTMLEditor projectDescription;
    @FXML
    private Button cancel;
    @FXML
    private Button saveChanges;

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
        this.projectId.setText(project.getProjectId());
        this.projectName.setText(project.getProjectName());
        try {
            this.startDate.setValue((Object)Config.stringToLocalDate(project.getStartDate()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.endDate.setValue((Object)Config.stringToLocalDate(project.getEndDate()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.projectDescription.setHtmlText(project.getProjectDescription());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.projectName, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.startDate, Validator.createEmptyValidator((String)"Required"));
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
        this.saveChanges.setOnAction(e -> {
            String tProjectId = "";
            String tProjectName = "";
            String tStartDate = "";
            String tEndDate = "";
            String tProjectDescription = "";
            String message = "";
            boolean error = false;
            boolean newProject = false;
            NumberSeries ns = new NumberSeries(60, this.getUser());
            try {
                tProjectId = this.projectId.getText().trim();
                if (tProjectId.length() == 0) {
                    throw new Exception();
                }
            }
            catch (Exception u) {
                newProject = true;
                tProjectId = ns.getNextNumber();
            }
            try {
                tProjectName = this.projectName.getText().trim();
                if (tProjectName.length() < 4) {
                    throw new Exception();
                }
            }
            catch (Exception u) {
                error = true;
                message = "Please enter the project name. Atleast three characters";
            }
            try {
                tStartDate = Config.localDateToString((LocalDate)this.startDate.getValue());
            }
            catch (Exception i) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select the project start date";
            }
            try {
                tEndDate = Config.localDateToString((LocalDate)this.endDate.getValue());
            }
            catch (Exception u) {
                tEndDate = "";
            }
            try {
                tProjectDescription = this.projectDescription.getHtmlText();
            }
            catch (Exception u) {
                tProjectDescription = "";
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            } else {
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("projectId", tProjectId);
                    params.put("projectName", tProjectName);
                    params.put("startDate", tStartDate);
                    params.put("endDate", tEndDate);
                    params.put("projectDescription", tProjectDescription);
                    String response = Config.loadDataFromPhp("mastercreate?type=project", params, this.getUser());
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        if (newProject) {
                            ns.updateLastUsed(tProjectId);
                        }
                        GeneralListController.publicNotificationPane.setText(jr.getMessage());
                        GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                        GeneralListController.publicNotificationPane.show();
                        Stage stage = (Stage)this.saveChanges.getScene().getWindow();
                        stage.close();
                    } else {
                        this.notificationPane.setText(jr.getMessage());
                        this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                        this.notificationPane.show();
                    }
                }
                catch (Exception p) {
                    this.notificationPane.setText("We encountered an error while processing your request");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
            }
        });
    }
}

