/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.ChargeItem;
import classes.Config;
import classes.JsonResponses;
import classes.Property;
import classes.PropertyCharges;
import classes.User;
import com.google.gson.Gson;
import java.net.URL;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class PropertyMonthlyChargesController
implements Initializable {
    private User user;
    private Property myProperty;
    @FXML
    private ComboBox<Property> property;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private StackPane holder;
    @FXML
    private TableView<PropertyCharges> allCharges;
    @FXML
    private TableColumn colDescription;
    @FXML
    private TableColumn colAmount;
    @FXML
    private TableColumn colDelete;
    @FXML
    private MaskerPane masker;
    @FXML
    private ComboBox<ChargeItem> chargeItem;
    @FXML
    private TextField amount;
    @FXML
    private Button addCharge;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        ObservableList<Property> allProperties = new Property().getAllProperties(user);
        allProperties.sort(Comparator.comparing(Property::getName));
        this.property.setItems(allProperties);
        ObservableList<ChargeItem> allItems = new ChargeItem().getChargeItems(5, this.getUser());
        allItems.sort(Comparator.comparing(ChargeItem::getName));
        this.chargeItem.setItems(allItems);
    }

    public Property getMyProperty() {
        return this.myProperty;
    }

    public void setMyProperty(Property myProperty) {
        this.myProperty = myProperty;
        this.property.setValue((Object)myProperty);
        this.loadPropertyCharges();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        this.amount = new Config().setDoubleTextField(this.amount);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.amount, Validator.createEmptyValidator((String)"Required"));
        this.colDescription.setCellValueFactory((Callback)new PropertyValueFactory("chargeItem"));
        this.colAmount.setCellValueFactory((Callback)new PropertyValueFactory("amountString"));
        this.colDelete.setCellValueFactory((Callback)new PropertyValueFactory("floorNo"));
        this.property.setOnAction(e -> this.loadPropertyCharges());
        this.addCharge.setOnAction(e -> {
            try {
                double tAmount = 0.0;
                boolean error = false;
                int tChargeId = 0;
                String message = "";
                try {
                    tAmount = Double.parseDouble(this.amount.getText().trim());
                    if (tAmount < 1.0) {
                        throw new Exception();
                    }
                }
                catch (Exception u) {
                    error = true;
                    message = "Please enter the charge amount";
                }
                try {
                    tChargeId = ((ChargeItem)this.chargeItem.getValue()).getCode();
                }
                catch (Exception u) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please select the charge item";
                }
                if (error) {
                    this.notificationPane.setText(message);
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                } else {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("propertyCode", ((Property)this.property.getValue()).getPropertyCode());
                    params.put("chargeItem", tChargeId);
                    params.put("amount", tAmount);
                    params.put("type", "Property Monthly");
                    String response = Config.loadDataFromPhp("mastercreate?type=propertycharge", params, this.getUser());
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                    if (jr.isStatus()) {
                        this.loadPropertyCharges();
                        this.chargeItem.getSelectionModel().select(0);
                        this.amount.setText("");
                    }
                }
            }
            catch (Exception y) {
                this.notificationPane.setText("We encountered an error processing your request");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
    }

    public void loadPropertyCharges() {
        try {
            Task<Void> task1 = new Task<Void>(){

                public Void call() {
                    Platform.runLater(() -> PropertyMonthlyChargesController.this.masker.setVisible(true));
                    PropertyMonthlyChargesController.this.allCharges.setItems(new PropertyCharges().getCharges("Property Monthly", ((Property)PropertyMonthlyChargesController.this.property.getValue()).getPropertyCode(), 0, PropertyMonthlyChargesController.this.getUser()));
                    Platform.runLater(() -> PropertyMonthlyChargesController.this.masker.setVisible(false));
                    return null;
                }
            };
            Thread backgroundThread = new Thread((Runnable)task1);
            backgroundThread.setDaemon(true);
            backgroundThread.start();
        }
        catch (Exception y) {
            this.notificationPane.setText("We experienced an error while loading the data");
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        }
    }
}

