/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.ChargeItem;
import classes.Config;
import classes.FixedAssets;
import classes.JsonResponses;
import classes.LineNumbersCellFactory;
import classes.NoteReasons;
import classes.PurchaseHeader;
import classes.PurchaseLines;
import classes.ShopItem;
import classes.ShopLocation;
import classes.User;
import classes.Vendor;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.EditPurchaseLineController;
import controllers.GeneralListController;
import impl.org.controlsfx.tools.PrefixSelectionCustomizer;
import java.io.File;
import java.net.URL;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class PurchaseHeaderController
implements Initializable {
    boolean posted = false;
    boolean allowDeleteLine = true;
    private User user;
    private String documentType;
    HashMap<String, Object> fullStock = new HashMap();
    PurchaseHeader invoice;
    @FXML
    NotificationPane notificationPane;
    @FXML
    VBox holder;
    @FXML
    DatePicker invoiceDate;
    @FXML
    private ComboBox<Vendor> vendor;
    @FXML
    private Hyperlink invoiceNo;
    @FXML
    private ComboBox<String> type;
    @FXML
    private ComboBox item;
    @FXML
    private Button searchItem;
    @FXML
    private TextField description;
    @FXML
    private TextField quantity;
    @FXML
    private TextField unitPrice;
    @FXML
    private TextField discount;
    @FXML
    private VBox kilometresVBox;
    @FXML
    private TextField kilometres;
    @FXML
    private VBox vehicleVBox;
    @FXML
    private VBox vsmVBox;
    @FXML
    private ComboBox<FixedAssets> vehicle;
    @FXML
    private Button searchFixedAsset;
    @FXML
    private Button addLine;
    @FXML
    private JFXButton uploadLines;
    @FXML
    private TableView<PurchaseLines> invoiceLines;
    @FXML
    private TableColumn colType;
    @FXML
    private TableColumn rowCount;
    @FXML
    private TableColumn colItemNo;
    @FXML
    private TableColumn colDelete;
    @FXML
    private TableColumn colEdit;
    @FXML
    private TableColumn colDescription;
    @FXML
    private TableColumn colQuantity;
    @FXML
    private TableColumn colApprovedQuantity;
    @FXML
    private TableColumn colDiscount;
    @FXML
    private TableColumn colUnitPrice;
    @FXML
    private TableColumn colTotalAmount;
    @FXML
    private TableColumn colKms;
    @FXML
    private TableColumn colSalesRep;
    @FXML
    private TableColumn colVehicle;
    @FXML
    private ComboBox<User> salesRep;
    @FXML
    private Button searchSalesRep;
    @FXML
    private Button postInvoice;
    @FXML
    private Button sendApproval;
    @FXML
    private HBox addItemHBox;
    @FXML
    private JFXButton saveInvoice;
    @FXML
    private MaskerPane maskerPane;
    @FXML
    private Label totalsLabel;
    @FXML
    private Label totalQuantity;
    @FXML
    private Label totalUnitPrice;
    @FXML
    private Label totalDiscount;
    @FXML
    private Label totalAmount;
    @FXML
    private ComboBox<ShopLocation> shopLocation;
    @FXML
    private ComboBox<String> entryType;
    @FXML
    private TextField lpoNo;
    @FXML
    private TextField kraEntryNo;
    @FXML
    private TextField comment;
    @FXML
    private HBox supplierInvoiceNoHbox;
    @FXML
    private TextField supplierInvoiceNo;
    @FXML
    private Label docNoLabel;
    @FXML
    private Button search;
    @FXML
    private Label docDateLabel;
    @FXML
    private HBox lpoNoHbox;
    @FXML
    private HBox warehouseHbox;
    @FXML
    private HBox debitNoteBox;
    @FXML
    private ComboBox<NoteReasons> reason;
    @FXML
    private HBox salesRepHbox1;
    @FXML
    private ComboBox<PurchaseHeader> debitInvoice;
    @FXML
    private Button searchInvoice;
    @FXML
    private VBox fSVBox;
    @FXML
    private TextField fullStockText;

    public String getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
        if (documentType.equalsIgnoreCase("lpo")) {
            this.postInvoice.setVisible(false);
            this.docDateLabel.setText("Order Date:");
            this.docNoLabel.setText("Order No:");
            this.sendApproval.setVisible(true);
            this.colApprovedQuantity.setVisible(false);
        } else if (!Config.ERP_MODE) {
            this.postInvoice.setText("Receive Goods");
            this.vendor.setDisable(true);
            this.search.setDisable(true);
            this.addLine.setDisable(true);
            this.allowDeleteLine = false;
        }
        if (documentType.equalsIgnoreCase("debitNote")) {
            this.postInvoice.setText("Post Debit Note");
            this.docDateLabel.setText("Debit Note Date:");
            this.docNoLabel.setText("Debit Note No:");
            this.debitNoteBox.setVisible(true);
            this.loadNoteReasons();
        }
    }

    private void loadFullStock() {
        final LinkedHashMap<String, Integer> params = new LinkedHashMap<String, Integer>();
        params.put("location", ((ShopLocation)this.shopLocation.getValue()).getId());
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                String response = Config.loadDataFromPhp("masterfetch?type=all_full_stock", params, PurchaseHeaderController.this.getUser());
                System.out.println(response);
                PurchaseHeaderController.this.fullStock = (HashMap)new Gson().fromJson(response, HashMap.class);
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.loadItems();
        this.loadVendors();
        this.loadFixedAssets();
        this.loadSalesReps();
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    PurchaseHeaderController.this.notificationPane.setText("Loading Values. Please wait");
                    PurchaseHeaderController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    PurchaseHeaderController.this.notificationPane.show();
                });
                ObservableList<ShopLocation> allLocations = new ShopLocation().getAllLocations(PurchaseHeaderController.this.getUser());
                allLocations.sort(Comparator.comparing(ShopLocation::getName));
                Platform.runLater(() -> {
                    PurchaseHeaderController.this.shopLocation.setItems(allLocations);
                    if (allLocations.size() == 1) {
                        PurchaseHeaderController.this.shopLocation.setValue(PurchaseHeaderController.this.shopLocation.getItems().get(0));
                        if (PurchaseHeaderController.this.getDocumentType().equalsIgnoreCase("lpo")) {
                            PurchaseHeaderController.this.loadFullStock();
                        }
                    }
                    PurchaseHeaderController.this.notificationPane.hide();
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public PurchaseHeader getInvoice() {
        return this.invoice;
    }

    public void setInvoice(PurchaseHeader invoice) {
        this.invoice = invoice;
        try {
            try {
                this.vendor.setValue((Object)invoice.getVendor());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.invoiceDate.setValue((Object)Config.stringToLocalDate(invoice.getInvoiceDate()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.shopLocation.setValue((Object)invoice.getLocation());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (invoice.isPosted()) {
                this.postInvoice.setDisable(true);
                this.saveInvoice.setDisable(true);
                this.posted = true;
                this.invoiceLines.getColumns().remove((Object)this.colEdit);
                this.invoiceLines.getColumns().remove((Object)this.colDelete);
                this.addItemHBox.setVisible(false);
            }
            try {
                if (!invoice.getStatus().equalsIgnoreCase("Draft") && !Config.ERP_MODE) {
                    this.posted = true;
                }
            }
            catch (Exception ignored) {
                this.posted = true;
            }
            try {
                if (this.getDocumentType().equalsIgnoreCase("lpo")) {
                    if (invoice.isPosted()) {
                        this.sendApproval.setVisible(false);
                    } else {
                        if (invoice.getStatus().equalsIgnoreCase("Approved")) {
                            this.sendApproval.setVisible(false);
                        }
                        if (invoice.getStatus().equalsIgnoreCase("Pending")) {
                            this.sendApproval.setVisible(false);
                            this.sendApproval.setDisable(true);
                            if (Config.ERP_MODE) {
                                this.colApprovedQuantity.setVisible(true);
                                this.postInvoice.setVisible(true);
                                this.postInvoice.setText("Approve L.P.O.");
                                this.totalsLabel.prefWidthProperty().bind((ObservableValue)this.rowCount.widthProperty().add((ObservableNumberValue)this.colType.widthProperty()).add((ObservableNumberValue)this.colItemNo.widthProperty()).add((ObservableNumberValue)this.colDescription.widthProperty()).add((ObservableNumberValue)this.colApprovedQuantity.widthProperty()));
                                this.editApprovedQuantity();
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.invoiceNo.setText(invoice.getDocumentNo());
        try {
            this.lpoNo.setText(invoice.getLpoNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.kraEntryNo.setText(invoice.getEntryNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.comment.setText(invoice.getComment());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.supplierInvoiceNo.setText(invoice.getExternalDocNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadInvoiceLines();
    }

    public void initialize(URL location, ResourceBundle resources) {
        PrefixSelectionCustomizer.customize(this.vendor);
        PrefixSelectionCustomizer.customize((ComboBox)this.item);
        PrefixSelectionCustomizer.customize(this.shopLocation);
        PrefixSelectionCustomizer.customize(this.vehicle);
        if (!Config.ERP_MODE) {
            this.postInvoice.setText("Receive Goods");
        } else {
            this.colApprovedQuantity.setVisible(false);
        }
        this.maskerPane.setVisible(false);
        this.debitNoteBox.setVisible(false);
        this.postInvoice.managedProperty().bind((ObservableValue)this.postInvoice.visibleProperty());
        this.sendApproval.managedProperty().bind((ObservableValue)this.sendApproval.visibleProperty());
        this.sendApproval.setVisible(false);
        this.supplierInvoiceNoHbox.managedProperty().bind((ObservableValue)this.supplierInvoiceNoHbox.visibleProperty());
        this.lpoNoHbox.managedProperty().bind((ObservableValue)this.lpoNoHbox.visibleProperty());
        this.debitNoteBox.managedProperty().bind((ObservableValue)this.debitNoteBox.visibleProperty());
        this.kilometresVBox.managedProperty().bind((ObservableValue)this.kilometresVBox.visibleProperty());
        this.vehicleVBox.managedProperty().bind((ObservableValue)this.vehicleVBox.visibleProperty());
        this.vsmVBox.managedProperty().bind((ObservableValue)this.vsmVBox.visibleProperty());
        this.addItemHBox.managedProperty().bind((ObservableValue)this.addItemHBox.visibleProperty());
        this.fSVBox.managedProperty().bind((ObservableValue)this.fSVBox.visibleProperty());
        this.totalsLabel.prefWidthProperty().bind((ObservableValue)this.rowCount.widthProperty().add((ObservableNumberValue)this.colType.widthProperty()).add((ObservableNumberValue)this.colItemNo.widthProperty()).add((ObservableNumberValue)this.colDescription.widthProperty()));
        this.totalQuantity.prefWidthProperty().bind((ObservableValue)this.colQuantity.widthProperty());
        this.totalUnitPrice.prefWidthProperty().bind((ObservableValue)this.colUnitPrice.widthProperty());
        this.totalDiscount.prefWidthProperty().bind((ObservableValue)this.colDiscount.widthProperty());
        this.totalAmount.prefWidthProperty().bind((ObservableValue)this.colTotalAmount.widthProperty());
        this.notificationPane.setContent((Node)this.holder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.notificationPane.setCloseButtonVisible(true);
        this.type.getItems().add((Object)"Items");
        this.type.getItems().add((Object)"Services");
        this.type.setValue((Object)"Items");
        this.entryType.getItems().add((Object)"Purchase");
        this.entryType.getItems().add((Object)"Import");
        this.entryType.getItems().add((Object)"Opening Stock");
        this.entryType.setValue(this.entryType.getItems().get(0));
        this.invoiceDate.setValue((Object)Config.getCurrentLocaldate());
        this.search.setOnAction(e -> {
            try {
                Gson gson = new Gson();
                String response = new Config().getObjectFromSelection("vendor", gson.toJson((Object)this.vendor.getItems()), this.getUser());
                this.vendor.setValue(gson.fromJson(response, Vendor.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.searchSalesRep.setOnAction(e -> {
            try {
                Gson gson = new Gson();
                String response = new Config().getObjectFromSelection("user", gson.toJson((Object)this.salesRep.getItems()), this.getUser());
                this.salesRep.setValue(gson.fromJson(response, User.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.searchItem.setOnAction(e -> {
            try {
                if (((String)this.type.getValue()).equalsIgnoreCase("Services")) {
                    Gson gson = new Gson();
                    String response = new Config().getObjectFromSelection("charge_item", gson.toJson((Object)this.item.getItems()), this.getUser());
                    this.item.setValue(gson.fromJson(response, ChargeItem.class));
                    this.unitPrice.requestFocus();
                } else {
                    Gson gson = new Gson();
                    String response = new Config().getObjectFromSelection("shopitem", gson.toJson((Object)this.item.getItems()), this.getUser());
                    this.item.setValue(gson.fromJson(response, ShopItem.class));
                    this.quantity.requestFocus();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.vendor.setOnAction(e -> this.loadVendorInvoices());
        this.searchFixedAsset.setOnAction(e -> {
            try {
                Gson gson = new Gson();
                String response = new Config().getObjectFromSelection("fixedasset", gson.toJson((Object)this.vehicle.getItems()), this.getUser());
                this.vehicle.setValue(gson.fromJson(response, FixedAssets.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.type.setOnAction(e -> {
            this.vsmVBox.setVisible(false);
            this.kilometresVBox.setVisible(false);
            this.vehicleVBox.setVisible(false);
            String typeValue = (String)this.type.getValue();
            if (typeValue.equalsIgnoreCase("Services")) {
                Task<Void> task1 = new Task<Void>(){

                    public Void call() {
                        Platform.runLater(() -> {
                            PurchaseHeaderController.this.notificationPane.setText("Loading Services. Please wait");
                            PurchaseHeaderController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                            PurchaseHeaderController.this.notificationPane.show();
                        });
                        ObservableList<ChargeItem> allChargeItems = new ChargeItem().getChargeItems(2, PurchaseHeaderController.this.getUser());
                        allChargeItems.sort(Comparator.comparing(ChargeItem::getName));
                        Platform.runLater(() -> {
                            PurchaseHeaderController.this.item.setItems(allChargeItems);
                            PurchaseHeaderController.this.notificationPane.hide();
                        });
                        return null;
                    }
                };
                Thread backgroundThread = new Thread((Runnable)task1);
                backgroundThread.setDaemon(true);
                backgroundThread.start();
            } else if (typeValue.equalsIgnoreCase("Items")) {
                Task<Void> task1 = new Task<Void>(){

                    public Void call() {
                        Platform.runLater(() -> {
                            PurchaseHeaderController.this.notificationPane.setText("Loading Items. Please wait");
                            PurchaseHeaderController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                            PurchaseHeaderController.this.notificationPane.show();
                        });
                        ObservableList<ShopItem> allItems = new ShopItem().getAllItems(PurchaseHeaderController.this.getUser());
                        allItems.sort(Comparator.comparing(ShopItem::getName));
                        Platform.runLater(() -> {
                            PurchaseHeaderController.this.item.setItems(allItems);
                            PurchaseHeaderController.this.notificationPane.hide();
                        });
                        return null;
                    }
                };
                Thread backgroundThread = new Thread((Runnable)task1);
                backgroundThread.setDaemon(true);
                backgroundThread.start();
            }
        });
        this.item.setOnAction(e -> {
            block9: {
                try {
                    String typeValue = (String)this.type.getValue();
                    if (typeValue.equalsIgnoreCase("Services")) {
                        ChargeItem ci = (ChargeItem)this.item.getValue();
                        this.description.setText(ci.getName());
                        this.vsmVBox.setVisible(ci.isRequireVSM());
                        this.kilometresVBox.setVisible(ci.isRequireFixedAsset());
                        this.vehicleVBox.setVisible(ci.isRequireFixedAsset());
                        break block9;
                    }
                    if (!typeValue.equalsIgnoreCase("Items")) break block9;
                    ShopItem ci = (ShopItem)this.item.getValue();
                    try {
                        this.description.setText(ci.getName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.unitPrice.setText(ci.getBuyingPrice() + "");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.getDocumentType().equalsIgnoreCase("lpo") && !this.fullStock.isEmpty()) {
                        double available = Double.parseDouble(this.fullStock.getOrDefault(ci.getCode(), 0.0).toString());
                        this.fSVBox.setVisible(true);
                        this.fullStockText.setText(Config.formatNumber(available));
                    }
                }
                catch (NullPointerException typeValue) {
                }
                catch (Exception r) {
                    r.printStackTrace();
                }
            }
        });
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.quantity, Validator.createEmptyValidator((String)"Quantity is required"));
        vs.registerValidator((Control)this.unitPrice, Validator.createEmptyValidator((String)"Unit Price is required"));
        vs.registerValidator((Control)this.description, Validator.createEmptyValidator((String)"Description is required"));
        vs.registerValidator((Control)this.item, Validator.createEmptyValidator((String)"Item is required"));
        this.saveInvoice.setOnAction(e -> this.saveInvoice());
        this.sendApproval.setOnAction(e -> {
            if (this.saveInvoice() && Config.showConfirmDialog("Send L.P.O. for approval", null, "Are you sure you want to send this L.P.O. for approval?")) {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("recordType", this.getDocumentType());
                params.put("docNo", this.invoiceNo.getText().trim());
                String response = Config.loadDataFromPhp("masterupdate?type=sendapprovalentry", params, this.getUser());
                System.out.println(response);
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    GeneralListController.publicNotificationPane.setText(jr.getMessage());
                    GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                    GeneralListController.publicNotificationPane.show();
                    ((Stage)this.sendApproval.getScene().getWindow()).close();
                } else {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
        });
        this.rowCount.setCellFactory(new LineNumbersCellFactory());
        this.colType.setCellValueFactory((Callback)new PropertyValueFactory("itemType"));
        this.colSalesRep.setCellValueFactory((Callback)new PropertyValueFactory("salesRep"));
        this.colVehicle.setCellValueFactory((Callback)new PropertyValueFactory("vehicle"));
        this.colKms.setCellValueFactory((Callback)new PropertyValueFactory("kiloMetres"));
        this.colItemNo.setCellValueFactory((Callback)new PropertyValueFactory("itemNo"));
        this.colDescription.setCellValueFactory((Callback)new PropertyValueFactory("itemDescription"));
        this.colQuantity.setCellValueFactory((Callback)new PropertyValueFactory("quantityString"));
        this.colApprovedQuantity.setCellValueFactory((Callback)new PropertyValueFactory("approvedQuantityString"));
        this.colDiscount.setCellValueFactory((Callback)new PropertyValueFactory("discountString"));
        this.colUnitPrice.setCellValueFactory((Callback)new PropertyValueFactory("unitPriceString"));
        this.colTotalAmount.setCellValueFactory((Callback)new PropertyValueFactory("totalAmountString"));
        Callback<TableColumn<PurchaseLines, PurchaseLines>, TableCell<PurchaseLines, PurchaseLines>> cellFactory = new Callback<TableColumn<PurchaseLines, PurchaseLines>, TableCell<PurchaseLines, PurchaseLines>>(){

            public TableCell<PurchaseLines, PurchaseLines> call(TableColumn<PurchaseLines, PurchaseLines> param) {
                TableCell<PurchaseLines, PurchaseLines> cell = new TableCell<PurchaseLines, PurchaseLines>(){
                    private final Button btn = new Button();
                    {
                        this.btn.setOnAction(e -> {
                            if (PurchaseHeaderController.this.posted) {
                                PurchaseHeaderController.this.showDocumentAlreadyPosted();
                            } else if (!PurchaseHeaderController.this.allowDeleteLine) {
                                PurchaseHeaderController.this.showActionRestricted();
                            } else {
                                PurchaseLines data = (PurchaseLines)this.getTableView().getItems().get(this.getIndex());
                                if (Config.showConfirmDialog("Delete Invoice Line", "The invoice line will be permanently deleted", "Are you sure you want to remove the item " + data.getItemDescription() + " from this invoice?")) {
                                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                                    params.put("headerNo", PurchaseHeaderController.this.invoiceNo.getText().trim());
                                    params.put("itemType", data.getItemType());
                                    params.put("lineId", data.getLineId());
                                    params.put("invoiceLine", data.getLineId());
                                    params.put("documentType", PurchaseHeaderController.this.getDocumentType());
                                    String response = Config.loadDataFromPhp("masterdelete?type=vendorinvoiceline", params, PurchaseHeaderController.this.getUser());
                                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                                    if (jr.isStatus()) {
                                        PurchaseHeaderController.this.loadInvoiceLines();
                                    }
                                    PurchaseHeaderController.this.notificationPane.setText(jr.getMessage());
                                    PurchaseHeaderController.this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                                    PurchaseHeaderController.this.notificationPane.show();
                                }
                            }
                        });
                    }

                    public void updateItem(PurchaseLines item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else {
                            this.btn.setGraphic((Node)Config.getDeleteIcon());
                            this.btn.getStyleClass().add((Object)"transparent_button");
                            this.setGraphic((Node)this.btn);
                        }
                    }
                };
                return cell;
            }
        };
        this.colDelete.setCellFactory((Callback)cellFactory);
        this.colDelete.setCellValueFactory(features -> new ReadOnlyObjectWrapper(features.getValue()));
        Callback<TableColumn<PurchaseLines, PurchaseLines>, TableCell<PurchaseLines, PurchaseLines>> editCellfactory = new Callback<TableColumn<PurchaseLines, PurchaseLines>, TableCell<PurchaseLines, PurchaseLines>>(){

            public TableCell<PurchaseLines, PurchaseLines> call(TableColumn<PurchaseLines, PurchaseLines> param) {
                TableCell<PurchaseLines, PurchaseLines> cell = new TableCell<PurchaseLines, PurchaseLines>(){
                    private final Button btn = new Button();
                    {
                        this.btn.setOnAction(e -> {
                            if (PurchaseHeaderController.this.posted) {
                                PurchaseHeaderController.this.showDocumentAlreadyPosted();
                            } else {
                                PurchaseLines data = (PurchaseLines)this.getTableView().getItems().get(this.getIndex());
                                PurchaseHeaderController.this.editEntry(data);
                            }
                        });
                    }

                    public void updateItem(PurchaseLines item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else {
                            this.btn.setGraphic((Node)Config.getEditIcon());
                            this.btn.getStyleClass().add((Object)"transparent_button");
                            this.setGraphic((Node)this.btn);
                        }
                    }
                };
                return cell;
            }
        };
        this.colEdit.setCellFactory((Callback)editCellfactory);
        this.colEdit.setCellValueFactory(features -> new ReadOnlyObjectWrapper(features.getValue()));
        this.addLine.setOnAction(e -> {
            if (this.posted) {
                this.showDocumentAlreadyPosted();
            } else if (!this.allowDeleteLine) {
                this.showActionRestricted();
            } else {
                double tKiloMetres;
                String tFixedAsset;
                String tSalesRep;
                String message;
                boolean error;
                String itemNo;
                String tType;
                block41: {
                    Object cI;
                    this.notificationPane.hide();
                    tType = (String)this.type.getValue();
                    itemNo = "";
                    String typeValue = (String)this.type.getValue();
                    error = false;
                    message = "";
                    tSalesRep = "";
                    tFixedAsset = "";
                    tKiloMetres = 0.0;
                    if (typeValue.equalsIgnoreCase("Services")) {
                        try {
                            cI = (ChargeItem)this.item.getValue();
                            itemNo = ((ChargeItem)cI).getCode() + "";
                            if (((ChargeItem)cI).isRequireVSM()) {
                                try {
                                    tSalesRep = ((User)this.salesRep.getValue()).getUserName();
                                    if (tSalesRep.length() < 1) {
                                        throw new Exception();
                                    }
                                }
                                catch (Exception ignored) {
                                    error = true;
                                    message = message + "Please select a sales rep";
                                }
                            }
                            if (!((ChargeItem)cI).isRequireFixedAsset()) break block41;
                            try {
                                tFixedAsset = ((FixedAssets)this.vehicle.getValue()).getAssetNo();
                                if (tFixedAsset.length() < 1) {
                                    throw new Exception();
                                }
                            }
                            catch (Exception ignored) {
                                error = true;
                                message = message + (message.length() > 0 ? "\n" : "");
                                message = message + "Please select a fixed asset";
                            }
                            try {
                                tKiloMetres = Double.parseDouble(this.kilometres.getText().trim());
                            }
                            catch (Exception ignored) {
                            }
                        }
                        catch (Exception t) {
                            error = true;
                            message = message + "Please select an item";
                        }
                    } else if (typeValue.equalsIgnoreCase("Items")) {
                        try {
                            cI = (ShopItem)this.item.getValue();
                            itemNo = ((ShopItem)cI).getCode() + "";
                        }
                        catch (Exception t) {
                            error = true;
                            message = message + "Please select an item";
                        }
                    }
                }
                String tDescription = this.description.getText().trim();
                String tUnitPrice = this.unitPrice.getText().trim();
                double mUnitPrice = 0.0;
                String tQuantity = this.quantity.getText().trim();
                double mQuantity = 0.0;
                double tDiscount = 0.0;
                if (tType.isEmpty()) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please select line type";
                }
                if (itemNo.isEmpty()) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please enter an item for the line";
                }
                if (tDescription.isEmpty()) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please enter a description for the line";
                }
                if (tUnitPrice.isEmpty()) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please enter a unit price for the line";
                } else {
                    try {
                        mUnitPrice = Double.parseDouble(tUnitPrice);
                        if (mUnitPrice < 0.0) {
                            error = true;
                            message = message + (message.length() > 0 ? "\n" : "");
                            message = message + "Unit price cannot be less than or equal to 0";
                        }
                    }
                    catch (Exception t) {
                        error = true;
                        message = message + (message.length() > 0 ? "\n" : "");
                        message = message + "Please enter a valid unit price for the line";
                    }
                }
                if (tUnitPrice.isEmpty()) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please enter a unit price for the line";
                } else {
                    try {
                        mQuantity = Double.parseDouble(tQuantity);
                        if (mQuantity <= 0.0) {
                            error = true;
                            message = message + (message.length() > 0 ? "\n" : "");
                            message = message + "Quantity cannot be less or equal to zero";
                        }
                    }
                    catch (Exception t) {
                        error = true;
                        message = message + (message.length() > 0 ? "\n" : "");
                        message = message + "Please enter a valid quantity for the line";
                    }
                }
                try {
                    tDiscount = Double.parseDouble(this.discount.getText().trim());
                }
                catch (Exception y) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please enter a valid discount for the line";
                }
                if (error) {
                    this.notificationPane.setText(message);
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                } else if (this.saveInvoice()) {
                    try {
                        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                        params.put("invoiceNo", this.invoiceNo.getText());
                        params.put("itemType", tType);
                        params.put("itemNo", itemNo);
                        params.put("description", tDescription);
                        params.put("unitPrice", tUnitPrice);
                        params.put("quantity", tQuantity);
                        params.put("discount", tDiscount);
                        params.put("salesRep", tSalesRep);
                        params.put("fixedAsset", tFixedAsset);
                        params.put("kiloMetres", tKiloMetres);
                        String response = Config.loadDataFromPhp("mastercreate?type=vendorinvoicelines", params, this.getUser());
                        System.out.println(response);
                        Gson g = new Gson();
                        JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                        this.notificationPane.setText(jr.getMessage());
                        this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                        this.notificationPane.show();
                        if (jr.isStatus()) {
                            this.loadInvoiceLines();
                            this.description.setText("");
                            this.item.setValue(null);
                            this.unitPrice.setText("0");
                            this.discount.setText("0");
                            this.quantity.setText("1");
                            this.fullStockText.setText("0");
                            this.fSVBox.setVisible(false);
                        }
                    }
                    catch (Exception t) {
                        this.notificationPane.setText("We encountered an error while adding the invoice line. ");
                        this.notificationPane.setGraphic((Node)Config.getBanIcon());
                        this.notificationPane.show();
                        t.printStackTrace();
                    }
                }
            }
        });
        this.uploadLines.setOnAction(e -> {
            if (this.saveInvoice()) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FileChooser chooser = new FileChooser();
                        chooser.setTitle("Select Excel to Import Entries From");
                        chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Excel Files", new String[]{"*.xlsx", "*.csv"})});
                        try {
                            File file = chooser.showOpenDialog((Window)new Stage());
                            if (file != null) {
                                XSSFWorkbook wb = new XSSFWorkbook(file);
                                final XSSFSheet ws = wb.getSheetAt(0);
                                Task<Void> task1 = new Task<Void>(){

                                    public Void call() {
                                        int noOfRecords = ws.getPhysicalNumberOfRows();
                                        Platform.runLater(() -> {
                                            PurchaseHeaderController.this.notificationPane.setText("Importing Entries Please wait");
                                            PurchaseHeaderController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                                            PurchaseHeaderController.this.notificationPane.show();
                                        });
                                        for (int b = 1; b < noOfRecords; ++b) {
                                            int c = b;
                                            this.updateProgress(c + 1, noOfRecords);
                                            Platform.runLater(() -> PurchaseHeaderController.this.notificationPane.setText("Uploading Records. Please wait... " + (c + 1) + " of " + noOfRecords));
                                            XSSFRow myRow = ws.getRow(b);
                                            try {
                                                Cell myCell;
                                                String tType = "";
                                                String itemNo = "";
                                                String tDescription = "";
                                                String tSalesRep = "";
                                                String tFixedAsset = "";
                                                double tUnitPrice = 0.0;
                                                double tQuantity = 0.0;
                                                double tDiscount = 0.0;
                                                double tKiloMetres = 0.0;
                                                try {
                                                    myCell = myRow.getCell(0);
                                                    tType = myCell.toString();
                                                }
                                                catch (Exception t) {
                                                    tType = "";
                                                }
                                                try {
                                                    myCell = myRow.getCell(1);
                                                    itemNo = myCell.toString().trim();
                                                }
                                                catch (Exception t) {
                                                    itemNo = "";
                                                }
                                                try {
                                                    myCell = myRow.getCell(2);
                                                    tDescription = myCell.toString().trim();
                                                }
                                                catch (Exception t) {
                                                    tDescription = "";
                                                }
                                                try {
                                                    myCell = myRow.getCell(3);
                                                    tUnitPrice = myCell.getNumericCellValue();
                                                }
                                                catch (Exception t) {
                                                    tUnitPrice = 0.0;
                                                }
                                                try {
                                                    myCell = myRow.getCell(4);
                                                    tQuantity = myCell.getNumericCellValue();
                                                }
                                                catch (Exception t) {
                                                    tQuantity = 0.0;
                                                }
                                                try {
                                                    myCell = myRow.getCell(5);
                                                    tDiscount = myCell.getNumericCellValue();
                                                }
                                                catch (Exception t) {
                                                    tDiscount = 0.0;
                                                }
                                                try {
                                                    myCell = myRow.getCell(6);
                                                    tSalesRep = myCell.toString().trim();
                                                }
                                                catch (Exception t) {
                                                    tSalesRep = "";
                                                }
                                                try {
                                                    myCell = myRow.getCell(7);
                                                    tFixedAsset = myCell.toString().trim();
                                                }
                                                catch (Exception t) {
                                                    tFixedAsset = "";
                                                }
                                                try {
                                                    myCell = myRow.getCell(8);
                                                    tKiloMetres = myCell.getNumericCellValue();
                                                }
                                                catch (Exception t) {
                                                    tKiloMetres = 0.0;
                                                }
                                                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                                                params.put("invoiceNo", PurchaseHeaderController.this.invoiceNo.getText());
                                                params.put("itemType", tType);
                                                params.put("itemNo", itemNo);
                                                params.put("description", tDescription);
                                                params.put("unitPrice", tUnitPrice);
                                                params.put("quantity", tQuantity);
                                                params.put("discount", tDiscount);
                                                params.put("salesRep", tSalesRep);
                                                params.put("fixedAsset", tFixedAsset);
                                                params.put("kiloMetres", tKiloMetres);
                                                String response = Config.loadDataFromPhp("mastercreate?type=vendorinvoicelines", params, PurchaseHeaderController.this.getUser());
                                                System.out.println(response);
                                                continue;
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                        PurchaseHeaderController.this.loadInvoiceLines();
                                        Platform.runLater(() -> PurchaseHeaderController.this.notificationPane.hide());
                                        return null;
                                    }
                                };
                                Thread backgroundThread = new Thread((Runnable)task1);
                                backgroundThread.setDaemon(true);
                                backgroundThread.start();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        });
        this.postInvoice.setOnAction(e -> {
            block10: {
                String tInvoiceNo;
                boolean error = false;
                try {
                    if (this.getInvoice().isPosted()) {
                        error = true;
                        Stage stage = (Stage)this.postInvoice.getScene().getWindow();
                        stage.close();
                        return;
                    }
                }
                catch (Exception t) {
                    t.printStackTrace();
                }
                if (this.saveInvoice() && !error && !(tInvoiceNo = this.invoiceNo.getText().trim()).isEmpty()) {
                    try {
                        String title = "Confirm Post";
                        String headerText = "Posting the document results in a change in financial position. ";
                        String contentText = "Are you sure you want to post the document number " + tInvoiceNo + "?";
                        if (this.getDocumentType().equalsIgnoreCase("lpo")) {
                            title = "Approve L.P.O";
                            headerText = "Approving the L.P.O cannot be undone. ";
                            contentText = "Are you sure you want to approve L.P.O " + tInvoiceNo + "?";
                        }
                        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                        alert.setTitle(title);
                        alert.setHeaderText(headerText);
                        alert.setContentText(contentText);
                        Optional result = alert.showAndWait();
                        if (result.get() != ButtonType.OK) break block10;
                        try {
                            JsonResponses jr = new PurchaseHeader().postInvoice(tInvoiceNo, this.getUser());
                            if (jr.isStatus()) {
                                GeneralListController.publicNotificationPane.setText(jr.getMessage());
                                GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                                GeneralListController.publicNotificationPane.show();
                                Stage stage = (Stage)this.postInvoice.getScene().getWindow();
                                stage.close();
                                break block10;
                            }
                            this.notificationPane.setText(jr.getMessage());
                            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                            this.notificationPane.show();
                        }
                        catch (Exception t) {
                            this.notificationPane.setText("We encountered an error while posting the vendor invoice. Please try again later");
                            this.notificationPane.setGraphic((Node)Config.getBanIcon());
                            this.notificationPane.show();
                        }
                    }
                    catch (Exception r) {
                        this.notificationPane.setText("We encountered an error while posting the customer invoice. Please try again later");
                        this.notificationPane.setGraphic((Node)Config.getBanIcon());
                        this.notificationPane.show();
                    }
                }
            }
        });
    }

    public boolean saveInvoice() {
        if (!this.posted) {
            boolean isNew = false;
            String tInvoiceNo = this.invoiceNo.getText().trim();
            if (tInvoiceNo.isEmpty()) {
                tInvoiceNo = "";
                isNew = true;
            }
            String tvendorNo = "";
            String tInvoiceDate = "";
            int shopLocationCode = 0;
            try {
                tvendorNo = ((Vendor)this.vendor.getValue()).getVendorNumber();
                if (tvendorNo.isEmpty()) {
                    tvendorNo = "";
                }
            }
            catch (Exception t) {
                tvendorNo = "";
            }
            try {
                tInvoiceDate = Config.localDateToString((LocalDate)this.invoiceDate.getValue());
            }
            catch (Exception t) {
                tInvoiceDate = "";
            }
            try {
                shopLocationCode = ((ShopLocation)this.shopLocation.getValue()).getId();
            }
            catch (Exception t) {
                shopLocationCode = 0;
            }
            String tLpoNo = "";
            String tExternalDocNo = "";
            String tEntryNo = "";
            String tComment = "";
            String tEntryType = "";
            String tDebitInvoiceNo = "";
            int debitReason = 0;
            try {
                tLpoNo = this.lpoNo.getText().trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                tEntryNo = this.kraEntryNo.getText().trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                tComment = this.comment.getText().trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                tExternalDocNo = this.supplierInvoiceNo.getText().trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                tEntryType = ((String)this.entryType.getValue()).trim();
            }
            catch (Exception i) {
                tEntryType = (String)this.entryType.getItems().get(0);
            }
            try {
                tDebitInvoiceNo = ((PurchaseHeader)this.debitInvoice.getValue()).getDocumentNo();
            }
            catch (Exception u) {
                tDebitInvoiceNo = "";
            }
            try {
                debitReason = ((NoteReasons)this.reason.getValue()).getId();
            }
            catch (Exception u) {
                debitReason = 0;
            }
            String response = "";
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("documentType", this.getDocumentType());
                params.put("documentNo", tInvoiceNo);
                params.put("vendor", tvendorNo);
                params.put("purchaseDate", tInvoiceDate);
                params.put("shopLocationCode", shopLocationCode);
                params.put("lpoNo", tLpoNo);
                params.put("entryNo", tEntryNo);
                params.put("comment", tComment);
                params.put("externalDocNo", tExternalDocNo);
                params.put("entryType", tEntryType);
                params.put("projectCode", "");
                params.put("debitReason", debitReason);
                params.put("debitInvoiceNo", tDebitInvoiceNo);
                response = Config.loadDataFromPhp("mastercreate?type=purchaseheader", params, this.getUser());
                System.out.println(response);
                Gson g = new Gson();
                JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    this.invoiceNo.setText(jr.getOverLoad1());
                }
                this.notificationPane.setText(response);
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                return jr.isStatus();
            }
            catch (Exception o) {
                this.notificationPane.setText(o.getMessage());
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
                return false;
            }
        }
        this.showDocumentAlreadyPosted();
        return false;
    }

    public void loadInvoiceLines() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> PurchaseHeaderController.this.maskerPane.setVisible(true));
                String tInvoiceNo = PurchaseHeaderController.this.invoiceNo.getText().trim();
                ObservableList<PurchaseLines> allLines = new PurchaseLines().getAllLines(tInvoiceNo, PurchaseHeaderController.this.getUser());
                double tTotalAmount = allLines.stream().mapToDouble(PurchaseLines::getTotalAmount).sum();
                double tTotalQuantity = allLines.stream().mapToDouble(PurchaseLines::getQuantity).sum();
                double tTotalDiscount = allLines.stream().mapToDouble(PurchaseLines::getDiscount).sum();
                int hasServices = allLines.stream().filter(v -> v.getItemType().equalsIgnoreCase("Services")).collect(Collectors.toList()).size();
                Platform.runLater(() -> {
                    PurchaseHeaderController.this.invoiceLines.setItems(allLines);
                    PurchaseHeaderController.this.totalQuantity.setText(Config.formatNumber(tTotalQuantity));
                    PurchaseHeaderController.this.totalAmount.setText(Config.formatNumber(tTotalAmount));
                    PurchaseHeaderController.this.totalDiscount.setText(Config.formatNumber(tTotalDiscount));
                    if (hasServices > 0) {
                        PurchaseHeaderController.this.colSalesRep.setVisible(true);
                        PurchaseHeaderController.this.colVehicle.setVisible(true);
                        PurchaseHeaderController.this.colKms.setVisible(true);
                    }
                    PurchaseHeaderController.this.maskerPane.setVisible(false);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void editEntry(PurchaseLines details) {
        try {
            final Stage stage = new Stage();
            FXMLLoader loader = new FXMLLoader();
            VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/edit_purchase_line.fxml").openStream());
            Scene editMember = new Scene((Parent)itemPane);
            editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(editMember);
            EditPurchaseLineController controller = (EditPurchaseLineController)loader.getController();
            controller.setUser(this.getUser());
            controller.setItems((ObservableList<ShopItem>)this.item.getItems());
            controller.setLine(details);
            controller.setDocumentType(this.getDocumentType());
            stage.setTitle("Edit Sales");
            stage.setResizable(false);
            try {
                stage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            PurchaseHeaderController.this.loadInvoiceLines();
                        }
                    });
                }
            });
            stage.showAndWait();
        }
        catch (Exception p) {
            p.printStackTrace();
            this.notificationPane.setText("An error occurred while loading your edit record screen. Please contact support");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
    }

    private void showDocumentAlreadyPosted() {
        this.notificationPane.setText("You cannot make any changes as the document is no longer open");
        this.notificationPane.setGraphic((Node)Config.getBanIcon());
        this.notificationPane.show();
    }

    private void showActionRestricted() {
        this.notificationPane.setText("This action has been restricted");
        this.notificationPane.setGraphic((Node)Config.getBanIcon());
        this.notificationPane.show();
    }

    private void loadItems() {
        final Node original = this.searchItem.getGraphic();
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> PurchaseHeaderController.this.searchItem.setGraphic((Node)Config.getLoader()));
                ObservableList<ShopItem> myItems = new ShopItem().getAllItems(PurchaseHeaderController.this.getUser());
                myItems.sort(Comparator.comparing(ShopItem::getName));
                Platform.runLater(() -> {
                    PurchaseHeaderController.this.item.setItems(myItems);
                    PurchaseHeaderController.this.searchItem.setGraphic(original);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void loadVendors() {
        final Node original = this.search.getGraphic();
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> PurchaseHeaderController.this.search.setGraphic((Node)Config.getLoader()));
                ObservableList<Vendor> allVendors = new Vendor().getAllVendors(PurchaseHeaderController.this.user);
                allVendors.sort(Comparator.comparing(Vendor::getVendorName));
                Platform.runLater(() -> {
                    PurchaseHeaderController.this.vendor.setItems(allVendors);
                    PurchaseHeaderController.this.search.setGraphic(original);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void loadVendorInvoices() {
        final Node original = this.searchInvoice.getGraphic();
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> PurchaseHeaderController.this.searchInvoice.setGraphic((Node)Config.getLoader()));
                ObservableList<PurchaseHeader> allInvoices = new PurchaseHeader().getVendorInvoices((Vendor)PurchaseHeaderController.this.vendor.getValue(), true, PurchaseHeaderController.this.user);
                allInvoices.sort(Comparator.comparing(PurchaseHeader::getInvoiceDate));
                Platform.runLater(() -> {
                    PurchaseHeaderController.this.debitInvoice.setItems(allInvoices);
                    PurchaseHeaderController.this.searchInvoice.setGraphic(original);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void loadNoteReasons() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                ObservableList<NoteReasons> allReasons = new NoteReasons().getAllReasons("DebitNote", PurchaseHeaderController.this.user);
                Platform.runLater(() -> PurchaseHeaderController.this.reason.setItems(allReasons));
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void loadFixedAssets() {
        final Node original = this.searchFixedAsset.getGraphic();
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> PurchaseHeaderController.this.searchFixedAsset.setGraphic((Node)Config.getLoader()));
                ObservableList<FixedAssets> allAssets = new FixedAssets().getAllAssets(true, PurchaseHeaderController.this.getUser());
                Platform.runLater(() -> {
                    PurchaseHeaderController.this.vehicle.setItems(allAssets);
                    PurchaseHeaderController.this.searchFixedAsset.setGraphic(original);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void loadSalesReps() {
        final Node original = this.searchSalesRep.getGraphic();
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> PurchaseHeaderController.this.searchSalesRep.setGraphic((Node)Config.getLoader()));
                ObservableList<User> allPeps = new User().getAllUsers(true, PurchaseHeaderController.this.user);
                Platform.runLater(() -> {
                    PurchaseHeaderController.this.salesRep.setItems(allPeps);
                    PurchaseHeaderController.this.searchSalesRep.setGraphic(original);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void editApprovedQuantity() {
        Callback<TableColumn<PurchaseLines, PurchaseLines>, TableCell<PurchaseLines, PurchaseLines>> confirmCellFactory = new Callback<TableColumn<PurchaseLines, PurchaseLines>, TableCell<PurchaseLines, PurchaseLines>>(){

            public TableCell<PurchaseLines, PurchaseLines> call(TableColumn<PurchaseLines, PurchaseLines> param) {
                TableCell<PurchaseLines, PurchaseLines> cell = new TableCell<PurchaseLines, PurchaseLines>(){
                    private final Hyperlink btn = new Hyperlink("Edit");
                    {
                        this.btn.setOnAction(e -> {
                            PurchaseLines data = (PurchaseLines)this.getTableView().getItems().get(this.getIndex());
                            TextInputDialog alert = new TextInputDialog(data.getApprovedQuantity() + "");
                            alert.setHeaderText("Approved Quantity");
                            alert.setTitle("Edit Approved Quantity");
                            alert.setContentText("Edit Approved Quantity");
                            Optional result = alert.showAndWait();
                            result.ifPresent(approvedQuantity -> PurchaseHeaderController.this.editApprovedAmount((String)approvedQuantity, data));
                        });
                    }

                    public void updateItem(PurchaseLines item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else {
                            this.btn.setText(item.getApprovedQuantityString());
                            this.setGraphic((Node)this.btn);
                        }
                    }
                };
                return cell;
            }
        };
        this.colApprovedQuantity.setCellFactory((Callback)confirmCellFactory);
        this.colApprovedQuantity.setCellValueFactory(features -> new ReadOnlyObjectWrapper(features.getValue()));
    }

    public void editApprovedAmount(String approvedAmount, PurchaseLines line) {
        try {
            double tApproved = Double.parseDouble(approvedAmount.trim());
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("lineId", line.getLineId());
            params.put("approvedQuantity", tApproved);
            params.put("itemCode", line.getItemNo());
            params.put("itemType", line.getItemType());
            params.put("documentType", line.getDocumentType());
            params.put("headerNo", this.invoiceNo.getText());
            String response = Config.loadDataFromPhp("masterupdate?type=edit_approved_quantity", params, this.getUser());
            System.out.println(response);
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                line.setApprovedQuantity(tApproved);
                this.notificationPane.hide();
                this.invoiceLines.refresh();
            } else {
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
            }
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
    }
}

