/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.User;
import java.awt.Desktop;
import java.awt.Dialog;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.ProgressBar;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.data.JsonDataSource;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsxReportConfiguration;
import net.sf.jasperreports.view.JasperViewer;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ReportController
implements Initializable {
    @FXML
    private ProgressBar progressBar;

    public void getReport(final String reportName, final String dataUrl, final Map<String, Object> dataVariables, final String reportUrl, final Map<String, Object> reportVariables, final User user) {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                try {
                    Platform.runLater(() -> {});
                    String response2 = "";
                    try {
                        response2 = Config.loadDataFromPhp(dataUrl, dataVariables, user);
                        ByteArrayInputStream jsonDataStream = new ByteArrayInputStream(response2.getBytes());
                        JsonDataSource ds = new JsonDataSource((InputStream)jsonDataStream);
                        if (ds.recordCount() < 1) {
                            Platform.runLater(() -> {
                                Alert alert = new Alert(Alert.AlertType.ERROR);
                                alert.setTitle("NO RECORDS FOUND");
                                alert.setHeaderText("No records found for your report");
                                alert.showAndWait();
                            });
                        } else {
                            String jasperReport = Config.getReportURL() + reportUrl;
                            try {
                                JasperPrint print2 = JasperFillManager.fillReport((String)jasperReport, (Map)reportVariables, (JRDataSource)ds);
                                print2.setProperty("net.sf.jasperreports.export.xls.white.page.background", "false");
                                JasperViewer jv = new JasperViewer(print2, false);
                                jv.setDefaultCloseOperation(0);
                                jv.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
                                jv.setTitle(reportName);
                                jv.setVisible(true);
                            }
                            catch (Exception y) {
                                Platform.runLater(() -> {
                                    Alert alert = new Alert(Alert.AlertType.ERROR);
                                    alert.setTitle("Could not load report");
                                    alert.setHeaderText("We could not generate your report. See below detailed error");
                                    alert.setContentText(y.getMessage());
                                    alert.showAndWait();
                                });
                            }
                        }
                    }
                    catch (Exception r) {
                        System.out.println(response2);
                        r.printStackTrace();
                        Platform.runLater(() -> {
                            Alert alert = new Alert(Alert.AlertType.ERROR);
                            alert.setTitle("Could not load report");
                            alert.setHeaderText("We could not generate your report. See below detailed error");
                            alert.setContentText(r.getMessage());
                            alert.showAndWait();
                        });
                    }
                    Platform.runLater(() -> {
                        Stage stage = (Stage)ReportController.this.progressBar.getScene().getWindow();
                        stage.close();
                    });
                }
                catch (Exception ty) {
                    ty.printStackTrace();
                    Platform.runLater(() -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Could not load report");
                        alert.setHeaderText("We could not generate your report. See below detailed error");
                        alert.setContentText(ty.getMessage());
                        alert.showAndWait();
                    });
                }
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
        Thread thread1 = new Thread((Runnable)task1);
        thread1.setDaemon(true);
        thread1.start();
    }

    public void saveReportAsPDF(String reportName, final String dataUrl, final Map<String, Object> dataVariables, final String reportUrl, final Map<String, Object> reportVariables, final User user, final String fileName) {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                try {
                    Platform.runLater(() -> {});
                    try {
                        String response2 = Config.loadDataFromPhp(dataUrl, dataVariables, user);
                        ByteArrayInputStream jsonDataStream = new ByteArrayInputStream(response2.getBytes());
                        JsonDataSource ds = new JsonDataSource((InputStream)jsonDataStream);
                        String jasperReport = Config.getReportURL() + reportUrl;
                        try {
                            JasperPrint print2 = JasperFillManager.fillReport((String)jasperReport, (Map)reportVariables, (JRDataSource)ds);
                            print2.setProperty("net.sf.jasperreports.export.xls.white.page.background", "false");
                            JasperExportManager.exportReportToPdfFile((JasperPrint)print2, (String)(Config.getReportURL() + fileName));
                        }
                        catch (Exception y) {
                            Platform.runLater(() -> {
                                Alert alert = new Alert(Alert.AlertType.ERROR);
                                alert.setTitle("Could not load report");
                                alert.setHeaderText("We could not generate your report. See below detailed error");
                                alert.setContentText(y.getMessage());
                                alert.showAndWait();
                            });
                        }
                    }
                    catch (Exception r) {
                        r.printStackTrace();
                    }
                    Platform.runLater(() -> {
                        Stage stage = (Stage)ReportController.this.progressBar.getScene().getWindow();
                        stage.close();
                    });
                }
                catch (Exception ty) {
                    ty.printStackTrace();
                }
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
        Thread thread1 = new Thread((Runnable)task1);
        thread1.setDaemon(true);
        thread1.start();
    }

    public void saveJsonReportAsPDF(String reportName, final String json, final String reportUrl, final Map<String, Object> reportVariables, User user, final String fileName) {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                try {
                    Platform.runLater(() -> {});
                    try {
                        String response2 = json;
                        ByteArrayInputStream jsonDataStream = new ByteArrayInputStream(response2.getBytes());
                        JsonDataSource ds = new JsonDataSource((InputStream)jsonDataStream);
                        String jasperReport = Config.getReportURL() + reportUrl;
                        try {
                            JasperPrint print2 = JasperFillManager.fillReport((String)jasperReport, (Map)reportVariables, (JRDataSource)ds);
                            JasperExportManager.exportReportToPdfFile((JasperPrint)print2, (String)(Config.exportReportLocation() + fileName));
                        }
                        catch (Exception y) {
                            y.printStackTrace();
                            Platform.runLater(() -> {
                                Alert alert = new Alert(Alert.AlertType.ERROR);
                                alert.setTitle("Could not load report");
                                alert.setHeaderText("We could not generate your report. See below detailed error");
                                alert.setContentText(y.getMessage());
                                alert.showAndWait();
                            });
                        }
                    }
                    catch (Exception r) {
                        r.printStackTrace();
                    }
                    Platform.runLater(() -> {
                        Stage stage = (Stage)ReportController.this.progressBar.getScene().getWindow();
                        stage.close();
                    });
                }
                catch (Exception ty) {
                    ty.printStackTrace();
                }
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
        Thread thread1 = new Thread((Runnable)task1);
        thread1.setDaemon(true);
        thread1.start();
    }

    public void getReportWithJson(final String reportName, final String json, final String reportUrl, final Map<String, Object> reportVariables) {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                try {
                    Platform.runLater(() -> {});
                    try {
                        ByteArrayInputStream jsonDataStream = new ByteArrayInputStream(json.getBytes());
                        JsonDataSource ds = new JsonDataSource((InputStream)jsonDataStream);
                        String jasperReport = Config.getReportURL() + reportUrl;
                        try {
                            JasperPrint print2 = JasperFillManager.fillReport((String)jasperReport, (Map)reportVariables, (JRDataSource)ds);
                            JasperViewer jv = new JasperViewer(print2, false);
                            jv.setDefaultCloseOperation(0);
                            jv.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
                            jv.setTitle(reportName);
                            jv.setExtendedState(6);
                            jv.requestFocus();
                            jv.setVisible(true);
                            jv.toFront();
                        }
                        catch (Exception y) {
                            Platform.runLater(() -> {
                                Alert alert = new Alert(Alert.AlertType.ERROR);
                                alert.setTitle("Could not load report");
                                alert.setHeaderText("We could not generate your report. See below detailed error");
                                alert.setContentText(y.getMessage());
                                alert.showAndWait();
                            });
                        }
                    }
                    catch (Exception r) {
                        r.printStackTrace();
                    }
                    Platform.runLater(() -> {
                        Stage stage = (Stage)ReportController.this.progressBar.getScene().getWindow();
                        stage.close();
                    });
                }
                catch (Exception ty) {
                    ty.printStackTrace();
                }
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
        Thread thread1 = new Thread((Runnable)task1);
        thread1.setDaemon(true);
        thread1.start();
    }

    public void printReport(String reportName, final String dataUrl, final Map<String, Object> dataVariables, final String reportUrl, final Map<String, Object> reportVariables, final User user) {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                try {
                    Platform.runLater(() -> {});
                    try {
                        String response2 = Config.loadDataFromPhp(dataUrl, dataVariables, user);
                        ByteArrayInputStream jsonDataStream = new ByteArrayInputStream(response2.getBytes());
                        JsonDataSource ds = new JsonDataSource((InputStream)jsonDataStream);
                        String jasperReport = Config.getReportURL() + reportUrl;
                        try {
                            JasperPrint print2 = JasperFillManager.fillReport((String)jasperReport, (Map)reportVariables, (JRDataSource)ds);
                            JasperPrintManager.printReport((JasperPrint)print2, (boolean)true);
                        }
                        catch (Exception y) {
                            Platform.runLater(() -> {
                                Alert alert = new Alert(Alert.AlertType.ERROR);
                                alert.setTitle("Could not load report");
                                alert.setHeaderText("We could not generate your report. See below detailed error");
                                alert.setContentText(y.getMessage());
                                alert.showAndWait();
                            });
                        }
                    }
                    catch (Exception r) {
                        r.printStackTrace();
                    }
                    Platform.runLater(() -> {
                        Stage stage = (Stage)ReportController.this.progressBar.getScene().getWindow();
                        stage.close();
                    });
                }
                catch (Exception ty) {
                    ty.printStackTrace();
                }
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
        Thread thread1 = new Thread((Runnable)task1);
        thread1.setDaemon(true);
        thread1.start();
    }

    public void printReportWithJson(String reportName, final String json, final String reportUrl, final Map<String, Object> reportVariables) {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                try {
                    Platform.runLater(() -> {});
                    try {
                        ByteArrayInputStream jsonDataStream = new ByteArrayInputStream(json.getBytes());
                        JsonDataSource ds = new JsonDataSource((InputStream)jsonDataStream);
                        String jasperReport = Config.getReportURL() + reportUrl;
                        try {
                            JasperPrint print2 = JasperFillManager.fillReport((String)jasperReport, (Map)reportVariables, (JRDataSource)ds);
                            JasperPrintManager.printReport((JasperPrint)print2, (boolean)false);
                        }
                        catch (Exception y) {
                            Platform.runLater(() -> {
                                Alert alert = new Alert(Alert.AlertType.ERROR);
                                alert.setTitle("Could not load report");
                                alert.setHeaderText("We could not generate your report. See below detailed error");
                                alert.setContentText(y.getMessage());
                                alert.showAndWait();
                            });
                        }
                    }
                    catch (Exception r) {
                        r.printStackTrace();
                    }
                    Platform.runLater(() -> {
                        Stage stage = (Stage)ReportController.this.progressBar.getScene().getWindow();
                        stage.close();
                    });
                }
                catch (Exception ty) {
                    ty.printStackTrace();
                }
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
        Thread thread1 = new Thread((Runnable)task1);
        thread1.setDaemon(true);
        thread1.start();
    }

    public void saveReportAsExcel(String reportName, final String dataUrl, final Map<String, Object> dataVariables, final String reportUrl, final Map<String, Object> reportVariables, final User user) {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                try {
                    Platform.runLater(() -> {});
                    String response2 = "";
                    try {
                        response2 = Config.loadDataFromPhp(dataUrl, dataVariables, user);
                        ByteArrayInputStream jsonDataStream = new ByteArrayInputStream(response2.getBytes());
                        JsonDataSource ds = new JsonDataSource((InputStream)jsonDataStream);
                        if (ds.recordCount() < 1) {
                            Platform.runLater(() -> {
                                Alert alert = new Alert(Alert.AlertType.ERROR);
                                alert.setTitle("NO RECORDS FOUND");
                                alert.setHeaderText("No records found for your report");
                                alert.showAndWait();
                            });
                        } else {
                            String jasperReport = Config.getReportURL() + reportUrl;
                            try {
                                JasperPrint print2 = JasperFillManager.fillReport((String)jasperReport, (Map)reportVariables, (JRDataSource)ds);
                                Platform.runLater(() -> {
                                    block44: {
                                        try {
                                            FileChooser fileChooser = new FileChooser();
                                            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Excel Files (*.xlsx)", new String[]{"*.xlsx"});
                                            fileChooser.getExtensionFilters().add((Object)extFilter);
                                            Stage stage = new Stage();
                                            File file = fileChooser.showSaveDialog((Window)stage);
                                            JRXlsxExporter exporter = new JRXlsxExporter();
                                            exporter.setExporterInput((ExporterInput)new SimpleExporterInput(print2));
                                            exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(file));
                                            SimpleXlsxReportConfiguration config = new SimpleXlsxReportConfiguration();
                                            config.setOnePagePerSheet(Boolean.valueOf(false));
                                            config.setDetectCellType(Boolean.valueOf(true));
                                            exporter.setConfiguration((ReportExportConfiguration)config);
                                            exporter.exportReport();
                                            try (FileInputStream in = new FileInputStream(file);
                                                 Workbook workbook = WorkbookFactory.create((InputStream)in);){
                                                Sheet sheet = workbook.getSheetAt(0);
                                                for (int col = 0; col < sheet.getRow(0).getLastCellNum(); ++col) {
                                                    sheet.autoSizeColumn(col);
                                                }
                                                try (FileOutputStream out = new FileOutputStream(file);){
                                                    workbook.write((OutputStream)out);
                                                }
                                            }
                                            new Config();
                                            if (!Config.showConfirmDialog("Open File", "Would you like to open the created file?", null)) break block44;
                                            try {
                                                if (Desktop.isDesktopSupported()) {
                                                    Desktop desktop = Desktop.getDesktop();
                                                    if (file.exists()) {
                                                        desktop.open(file);
                                                    }
                                                }
                                            }
                                            catch (Exception f) {
                                                f.printStackTrace();
                                            }
                                        }
                                        catch (Exception ignored) {
                                            ignored.printStackTrace();
                                        }
                                    }
                                });
                            }
                            catch (Exception y) {
                                Platform.runLater(() -> {
                                    Alert alert = new Alert(Alert.AlertType.ERROR);
                                    alert.setTitle("Could not load report");
                                    alert.setHeaderText("We could not generate your report. See below detailed error");
                                    alert.setContentText(y.getMessage());
                                    alert.showAndWait();
                                });
                            }
                        }
                    }
                    catch (Exception r) {
                        System.out.println(response2);
                        r.printStackTrace();
                        Platform.runLater(() -> {
                            Alert alert = new Alert(Alert.AlertType.ERROR);
                            alert.setTitle("Could not load report");
                            alert.setHeaderText("We could not generate your report. See below detailed error");
                            alert.setContentText(r.getMessage());
                            alert.showAndWait();
                        });
                    }
                    Platform.runLater(() -> {
                        Stage stage = (Stage)ReportController.this.progressBar.getScene().getWindow();
                        stage.close();
                    });
                }
                catch (Exception ty) {
                    ty.printStackTrace();
                    Platform.runLater(() -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Could not load report");
                        alert.setHeaderText("We could not generate your report. See below detailed error");
                        alert.setContentText(ty.getMessage());
                        alert.showAndWait();
                    });
                }
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
        Thread thread1 = new Thread((Runnable)task1);
        thread1.setDaemon(true);
        thread1.start();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.progressBar.setProgress(-1.0);
    }
}

