/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.Config;
import classes.Employee;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.SalaryAdvance;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class SalaryAdvanceForm
implements Initializable {
    private User user;
    @FXML
    private VBox vbSalaryAdvance;
    @FXML
    private VBox vbHolder;
    @FXML
    private Label labelId;
    @FXML
    private ComboBox<Employee> cbEmployee;
    @FXML
    private TextField tfAmount;
    @FXML
    private Button btnCancel;
    @FXML
    private Button btnSave;
    @FXML
    private Button btnPost;
    @FXML
    private Button btnReverse;
    @FXML
    private ComboBox<Bank> cbBank;
    @FXML
    private TextField tfDocNo;
    @FXML
    private DatePicker dpDate;
    @FXML
    private NotificationPane notificationPane;
    private SalaryAdvance salaryAdvance;

    public User getUser() {
        return this.user;
    }

    public void setUser(final User user) {
        this.user = user;
        this.btnSave.setDisable(false);
        this.btnPost.setDisable(false);
        Task task = new Task(){

            public Void call() {
                Platform.runLater(() -> {
                    SalaryAdvanceForm.this.notificationPane.setText("Loading Values. Please wait...");
                    SalaryAdvanceForm.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    SalaryAdvanceForm.this.notificationPane.show();
                });
                SalaryAdvanceForm.this.cbEmployee.setItems(FXCollections.observableArrayList(new Employee().getAllEmployees(user)));
                SalaryAdvanceForm.this.cbBank.setItems(FXCollections.observableArrayList(Bank.getAllBanks(user)));
                Platform.runLater(() -> SalaryAdvanceForm.this.notificationPane.hide());
                return null;
            }
        };
        Thread thread = new Thread((Runnable)task);
        thread.start();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.vbHolder);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator(this.cbEmployee, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.tfAmount, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.dpDate, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.cbBank, Validator.createEmptyValidator((String)"Required"));
        this.btnSave.setOnAction(event -> this.save());
    }

    @FXML
    void cancel(ActionEvent event) {
        Stage stage = (Stage)this.vbSalaryAdvance.getScene().getWindow();
        stage.fireEvent(new Event(WindowEvent.WINDOW_CLOSE_REQUEST));
    }

    @FXML
    void post(ActionEvent event) {
        if (this.save()) {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                String loanNo = this.labelId.getText().trim();
                params.put("loanNo", loanNo);
                String response = Config.loadDataFromPhp("masterpost?type=salaryadvances", params, this.user);
                System.out.println(response);
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    GeneralListController.publicNotificationPane.setText(jr.getMessage());
                    GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                    GeneralListController.publicNotificationPane.show();
                    Stage stage = (Stage)this.btnPost.getScene().getWindow();
                    stage.close();
                } else {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
            catch (Exception y) {
                this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
                y.printStackTrace();
            }
        }
    }

    @FXML
    void reverse(ActionEvent event) {
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            String loanNo = this.labelId.getText().trim();
            params.put("loanNo", loanNo);
            String response = Config.loadDataFromPhp("masterpost?type=reversesalaryadvances", params, this.user);
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                GeneralListController.publicNotificationPane.setText(jr.getMessage());
                GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                GeneralListController.publicNotificationPane.show();
                Stage stage = (Stage)this.btnPost.getScene().getWindow();
                stage.close();
            } else {
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
            }
        }
        catch (Exception y) {
            this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
    }

    private boolean save() {
        String installments = "";
        String errorMessage = "";
        String extDocNo = "";
        String date = "";
        Employee employee = null;
        double amount = 0.0;
        Bank bank = null;
        NumberSeries ns = new NumberSeries(46, this.getUser());
        String id = "";
        boolean error = false;
        try {
            employee = (Employee)this.cbEmployee.getValue();
            if (employee == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage + "Select a valid employee";
        }
        try {
            amount = Double.parseDouble(this.tfAmount.getText().trim().replaceAll(",", ""));
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage.concat(errorMessage.equals("") ? "Enter a valid amount" : "\nEnter a valid amount");
        }
        try {
            bank = (Bank)this.cbBank.getValue();
            if (bank == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage.concat(errorMessage.equals("") ? "Select a valid Bank" : "\nSelect a valid Bank");
        }
        try {
            date = Config.localDateToString((LocalDate)this.dpDate.getValue());
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage.concat(errorMessage.equals("") ? "Select a valid date" : "\nSelect a valid date");
        }
        if (error) {
            this.notificationPane.setText(errorMessage);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        } else {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            id = !this.labelId.getText().trim().equals("") ? this.labelId.getText().trim() : ns.getNextNumber();
            extDocNo = extDocNo + this.tfDocNo.getText().trim();
            try {
                params.put("id", id);
                params.put("employee", employee.getEmployeeNumber());
                params.put("amount", amount);
                params.put("installments", installments);
                params.put("extDocNo", extDocNo);
                params.put("date", date);
                params.put("bank", bank.getCode());
                String url = this.labelId.getText().trim().equals("") ? "mastercreate" : "masterupdate";
                String response = Config.loadDataFromPhp(url + "?type=salaryadvances", params, this.user);
                System.out.println(response);
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.show();
                if (jr.isStatus()) {
                    if (this.labelId.getText().trim().equals("")) {
                        ns.updateLastUsed(id);
                    }
                    this.labelId.setText(id);
                }
                return jr.isStatus();
            }
            catch (Exception t) {
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.setText("We encountered an error while processing your request. Please try again");
                this.notificationPane.show();
            }
        }
        return false;
    }

    public void setSalaryAdvance(SalaryAdvance salaryAdvance) {
        this.salaryAdvance = salaryAdvance;
        this.labelId.setText(salaryAdvance.getId());
        this.cbEmployee.getSelectionModel().select((Object)salaryAdvance.getEmployee());
        this.tfAmount.setText(salaryAdvance.getAmount() + "");
        this.btnPost.setDisable(salaryAdvance.isPosted());
        this.tfDocNo.setText(salaryAdvance.getExtDocNo());
        this.cbBank.getSelectionModel().select((Object)salaryAdvance.getBank());
        this.dpDate.setValue((Object)Config.stringToLocalDate(salaryAdvance.getDate()));
        if (salaryAdvance.isPosted()) {
            this.btnReverse.setDisable(false);
            this.btnSave.setDisable(true);
            this.btnPost.setDisable(true);
            this.cbEmployee.setDisable(true);
            this.dpDate.setDisable(true);
            this.tfAmount.setDisable(true);
            this.cbBank.setDisable(true);
            this.tfDocNo.setDisable(true);
        } else {
            this.btnSave.setDisable(false);
        }
        if (salaryAdvance.isReversed()) {
            this.btnReverse.setDisable(true);
        }
    }
}

