/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.User;
import com.google.gson.Gson;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.PieChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;

public class SalesDashboard
implements Initializable {
    private User user;
    @FXML
    private LineChart<String, Number> noOfSales;
    @FXML
    private LineChart<String, Number> noOfReceipts;
    @FXML
    private Label noOfCustomers;
    @FXML
    private Label customerBalances;
    @FXML
    private Label availableInventory;
    @FXML
    private Label inventoryValue;
    @FXML
    private Label supplierBalances;
    @FXML
    private PieChart customersByGender;
    @FXML
    private PieChart customersByRegion;
    @FXML
    private PieChart productsByCategories;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    public void loadDashboardData() {
        String response = Config.loadDataFromPhp("masterfetch?type=dashboard", new LinkedHashMap<String, Object>(), this.user);
        System.out.println(response);
        Gson gson = new Gson();
        Map tResponse = (Map)gson.fromJson(response, Map.class);
        this.noOfCustomers.setText(tResponse.get("noOfCustomers").toString());
        this.customerBalances.setText(tResponse.get("customerBalances").toString());
        this.availableInventory.setText(tResponse.get("availableInventory").toString());
        this.inventoryValue.setText(tResponse.get("inventoryValue").toString());
        this.supplierBalances.setText(tResponse.get("supplierBalances").toString());
        ObservableList chartData = FXCollections.observableArrayList();
        String genderValues = tResponse.get("genderValues").toString();
        String[] mGenderValues = (String[])gson.fromJson(genderValues, String[].class);
        String genderOptions = tResponse.get("allGenders").toString();
        String[] allGender = (String[])gson.fromJson(genderOptions, String[].class);
        for (int a = 0; a < allGender.length; ++a) {
            double genderValue = 0.0;
            try {
                genderValue = Double.parseDouble(mGenderValues[a].trim());
            }
            catch (Exception u) {
                genderValue = 0.0;
            }
            chartData.add((Object)new PieChart.Data(allGender[a], genderValue));
        }
        this.customersByGender.setData(chartData);
        ObservableList regionsChartData = FXCollections.observableArrayList();
        String regionValues = tResponse.get("regionValues").toString();
        System.out.println(regionValues);
        String[] mRegionValues = (String[])gson.fromJson(regionValues, String[].class);
        String regionOptions = tResponse.get("allRegionsJson").toString();
        String[] allRegions = (String[])gson.fromJson(regionOptions, String[].class);
        for (int a = 0; a < allRegions.length; ++a) {
            double regionValue = 0.0;
            try {
                regionValue = Double.parseDouble(mRegionValues[a].trim());
            }
            catch (Exception u) {
                regionValue = 0.0;
            }
            regionsChartData.add((Object)new PieChart.Data(allRegions[a], regionValue));
        }
        this.customersByRegion.setData(regionsChartData);
        ObservableList categoriesChartData = FXCollections.observableArrayList();
        String categoryValues = tResponse.get("categoriesValues").toString();
        String[] mCategoryValues = (String[])gson.fromJson(categoryValues, String[].class);
        String[] allCategories = (String[])gson.fromJson(tResponse.get("allCategoriesJson").toString(), String[].class);
        for (int a = 0; a < allCategories.length; ++a) {
            double categoryValue = 0.0;
            try {
                categoryValue = Double.parseDouble(mCategoryValues[a].trim());
            }
            catch (Exception u) {
                categoryValue = 0.0;
            }
            categoriesChartData.add((Object)new PieChart.Data(allCategories[a], categoryValue));
        }
        this.productsByCategories.setData(categoriesChartData);
        String[] allDates = (String[])gson.fromJson(tResponse.get("allDatesJson").toString(), String[].class);
        String[] allInvoices = (String[])gson.fromJson(tResponse.get("invoices").toString(), String[].class);
        String[] allReceipts = (String[])gson.fromJson(tResponse.get("mpesaTransactions").toString(), String[].class);
        XYChart.Series series = new XYChart.Series();
        series.setName("Sales");
        XYChart.Series receiptsSeries = new XYChart.Series();
        receiptsSeries.setName("Receipts");
        for (int a = 0; a < allDates.length; ++a) {
            double noOfTrans = 0.0;
            double noOfReceipts = 0.0;
            try {
                noOfTrans = Double.parseDouble(allInvoices[a].trim());
            }
            catch (Exception u) {
                noOfTrans = 0.0;
            }
            try {
                noOfReceipts = Double.parseDouble(allReceipts[a].trim());
            }
            catch (Exception u) {
                noOfReceipts = 0.0;
            }
            series.getData().add((Object)new XYChart.Data((Object)allDates[a], (Object)noOfTrans));
            receiptsSeries.getData().add((Object)new XYChart.Data((Object)allDates[a], (Object)noOfReceipts));
        }
        this.noOfSales.getData().add((Object)series);
        this.noOfReceipts.getData().add((Object)receiptsSeries);
    }
}

